/*
 * Copyright 2010 SpringSource
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.build.osgi.validator;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Arrays;

import org.junit.Test;

public class BundleResolutionValidatorTests {

    @Test
    public void successfulValidation() throws ValidationFailedException, URISyntaxException {
        BundleResolutionValidator validator = new BundleResolutionValidator(new File("src/test/resources/bundles/a"), Arrays.asList(new File(
            "src/test/resources/bundles/b")));
        validator.validate();
    }

    @Test(expected = ValidationFailedException.class)
    public void failingValidation() throws ValidationFailedException, URISyntaxException {
        BundleResolutionValidator validator = new BundleResolutionValidator(new File("src/test/resources/bundles/b"), Arrays.<File> asList());
        try {
        	validator.validate();
        } catch (ValidationFailedException vfe) {
        	vfe.printStackTrace(System.out);
        	throw vfe;
        }
    }

}
