
#ifndef SSHGUARD_FW_H
#define SSHGUARD_FW_H

#include "sshguard_services.h"
#include "sshguard_addresskind.h"

/*      return values for fw backend functions:     */
/* success */
#define FWALL_OK        0
/* error */
#define FWALL_ERR       -1
/* unsupported operation */
#define FWALL_UNSUPP    -2

/*      fw backend functions        */
/* initialization */
int fw_init();

/* finalization */
int fw_fin();

/* block an address (of kind addrkind) */
/* the buffer addr is not guaranteed to maintain its content after
 * the function returns. */
int fw_block(char *addr, int addrkind, int service);

/* release an address formerly blocked (of kind addrkind) */
/* the buffer addr is not guaranteed to maintain its content after
 * the function returns. */
int fw_release(char *addr, int addrkind, int service);


/* release all addresses formerly blocked */
int fw_flush(void);

#endif

