/* -*-C-*-
 ********************************************************************************
 *
 * File:        render.h  (Formerly render.h)
 * Description:  Convert the various data type into line lists
 * Author:       Mark Seaman, OCR Technology
 * Created:      Fri Jul 28 13:14:48 1989
 * Modified:     Fri Apr 26 09:59:45 1991 (Mark Seaman) marks@hpgrlt
 * Language:     C
 * Package:      N/A
 * Status:       Experimental (Do Not Distribute)
 *
 * (c) Copyright 1989, Hewlett-Packard Company.
 ** Licensed under the Apache License, Version 2.0 (the "License");
 ** you may not use this file except in compliance with the License.
 ** You may obtain a copy of the License at
 ** http://www.apache.org/licenses/LICENSE-2.0
 ** Unless required by applicable law or agreed to in writing, software
 ** distributed under the License is distributed on an "AS IS" BASIS,
 ** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ** See the License for the specific language governing permissions and
 ** limitations under the License.
 *
 *********************************************************************************/
#ifndef RENDER_H
#define RENDER_H

#include "host.h"
#include "callcpp.h"
#include "tessclas.h"

/*----------------------------------------------------------------------
              V a r i a b l e s
----------------------------------------------------------------------*/
extern void *blob_window;        /* Window for blobs */
extern C_COL color_list[];       /* Colors for outlines */
extern int blob_pause;           /* Wait after each blob */
extern int display_all_blobs;    /* Display blobs ? */
extern int display_all_words;    /* Display words ? */

#define NUM_COLORS 6

/*----------------------------------------------------------------------
              F u n c t i o n s
----------------------------------------------------------------------*/
void display_blob(TBLOB *blob, C_COL color); 

void init_render_vars(); 

void render_blob(void *window, TBLOB *blob, TPOINT origin, C_COL color); 

void render_edgepts(void *window, EDGEPT *edgept, C_COL color); 

void render_outline(void *window,
                    TESSLINE *outline,
                    TPOINT origin,
                    C_COL color);

/*
#if defined(__STDC__) || defined(__cplusplus)
# define _ARGS(s) s
#else
# define _ARGS(s) ()
#endif*/

/* render.c
void display_blob
  _ARGS((BLOB *blob,
  char *color));

void render_blob
  _ARGS((X_WINDOW *window,
  BLOB *blob,
  TPOINT origin,
  char *color));

void render_edgepts
  _ARGS((X_WINDOW *window,
  EDGEPT *edgept,
  char *color));

void render_outline
  _ARGS((X_WINDOW *window,
  TESSLINE *outline,
  TPOINT origin,
  char *color));

#undef _ARGS
*/
#endif
