#!/usr/bin/env python
# -*- coding: latin-1 -*-
#
# Time-stamp: <2004-09-04 17:08:47 graham>
#
#  COPYRIGHT
# Togaware 2004 All rights are reserved.
#
# Authors: Graham Williams
#

"""Add a DOCTYPE if it is missing."""

########################################################################
# IMPORTS
#

import re
import sys
import os
import shutil

########################################################################
# SYSTEM VARIABLES
#
__version__ = "$Revision: 1.9 $".split()[1]
__verdate__ = "$Date: 2004/09/04 07:08:46 $".split()[1:3]
__source__  = "$Source: /cvsroot/texcatalogue/texcatalogue/src/doctypes.py,v $".\
              split()[1]
__program__ = re.sub('^.RCSfile: (.*).py,v .', "\\1",
                     "$RCSfile: doctypes.py,v $")

########################################################################
#
# CONSTANTS
#
CTAN_host = "http://mirror.aarnet.edu.au/pub/CTAN/"

########################################################################
#
# BUILD LIST OF ENTRIES.
#
def list_packages(path = "./entries"):
    entries = []
    for w in os.walk(path, True, None):
        entries += w[2]
    Xmlre = re.compile("^[a-z][a-zA-Z0-9_\-]*\.xml$")
    entries = map(lambda x: re.sub("\.xml", "", x),filter(Xmlre.match,entries))
    entries.sort()
    return entries

########################################################################
#
# READ AND ADD DOCTYPE
#

def add_doctype(packages, path = "./entries"):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        doc = open(xmlfname).readlines()
        #        if doc[1] <> "<!DOCTYPE entry SYSTEM 'catalogue.dtd'>\n" and \
        #           doc[1] <> '<!DOCTYPE entry SYSTEM "catalogue.dtd">\n':
        if "<!DOCTYPE entry SYSTEM" not in doc[1]:
            print "Add DOCTYPE to %s." % p
            shutil.copy(xmlfname, xmlfname + ".bak")
            ndoc = "".join([doc[0]] + \
                           ["<!DOCTYPE entry SYSTEM 'catalogue.dtd'>\n"] + \
                           doc[1:])
            nfile = open(xmlfname, "w")
            nfile.write(ndoc)
            nfile.close()
            
###################################################################
# MAIN PROGRAM
#
def _usage():
    """Print documentation."""
    print __doc__

def _main():
    """Process command line options then perform the action."""
    packages = list_packages()
    print "The catalogue contains %d entries." % len(packages)
    add_doctype(packages)

########################################################################
#
# INTERACTIVE
#
# Test to see if we are running as a main program, rather than being
# imported as a library. If it's a main program, then let's do some
# work. Otherwise let's quielty proceed.
#
if __name__ == "__main__":
    _main()
