#!/usr/bin/env python
# -*- coding: latin-1 -*-
#
# Time-stamp: <2004-10-21 05:39:53 graham>
#
#  COPYRIGHT
# Togaware 2004 All rights are reserved.
#
# Authors: Graham Williams
#

"""
Transform the XML entries that make up the TeX Catalogue into a single XML
file.
"""

import codecs
import re
import datetime
from tcutils import list_packages

########################################################################
# SYSTEM VARIABLES
#
__version__ = "$Revision: 1.4 $".split()[1]
__verdate__ = "$Date: 2004/10/20 19:42:46 $".split()[1:3]
__source__  = "$Source: /cvsroot/texcatalogue/texcatalogue/src/fullcat.py,v $".\
              split()[1]
__program__ = re.sub('^.RCSfile: (.*).py,v .', "\\1",
                     "$RCSfile: fullcat.py,v $")

catfile = "catalogue.xml"
entries = list_packages()

catalogue = codecs.open(catfile, "w", "utf-8")
catalogue.write("""<?xml version="1.0"  encoding="utf-8"?>
<!DOCTYPE fullcat SYSTEM "http://texcatalogue.sarovar.org/catalogue.dtd">
<fullcat>
""")
#
# Authors
#
doc = codecs.open("./entries/authors", "r", "utf-8").readlines()
catalogue.write("".join(doc[2:]))
#
# Entries
#
catalogue.write("""<catalogue maintainer="Graham.Williams togaware.com"
           datestamp="%s"
           license="Copyright 1986-2004 (c) Graham J. Williams under the GPL">
""" % datetime.datetime.utcnow() )
for p in entries:
    xmlfile = "./entries/" + p[0] + "/" + p + ".xml"
    doc = codecs.open(xmlfile, "r", "utf-8").readlines()
    #doc = doc[2:]
    catalogue.write("".join(doc[2:]))
catalogue.write("""
</catalogue>
</fullcat>
""")
catalogue.close()
print "Full catalogue written to `%s'." % (catfile)
