
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : source-kbd.scm
;; DESCRIPTION : shortcuts for dynamic markup
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(texmacs-module (source source-kbd)
  (:use (source source-edit)))

(kbd-map
  ("M-)" (make-style-with "src-compact" "none"))
  ("M-(" (make-style-with "src-compact" "all"))
  ("M-@" (make-mod-active 'style-only*))
  ("M--" (make-mod-active 'inactive*))
  ("M-+" (make-mod-active 'active*))
  ("M-A-@" (make-mod-active 'style-only))
  ("M-A--" (make-mod-active 'inactive))
  ("M-A-+" (make-mod-active 'active))

  ("inactive a" (make 'arg))
  ("inactive A" (make 'map-args))
  ("inactive c" (make 'compound))
  ("inactive C" (make 'case))
  ("inactive d" (make 'drd-props))
  ("inactive e" (make 'eval-args))
  ("inactive i" (make 'include))
  ("inactive l" (make-latex))
  ("inactive m" (make 'macro))
  ("inactive M" (make 'meaning))
  ("inactive n" (make 'get-arity))
  ("inactive N" (make 'get-label))
  ("inactive p" (make 'provides))
  ("inactive q" (make 'quasi))
  ("inactive s" (make 'surround))
  ("inactive t" (make 'tag))
  ("inactive v" (make 'value))
  ("inactive w" (make-arity 'with 3))
  ("inactive W" (make 'while))
  ("inactive x" (make 'xmacro))
  ("inactive X" (make 'extern))
  ("inactive !" (make 'eval))
  ("inactive *" (make 'action))
  ("inactive =" (make 'assign))
  ("inactive (" (make 'tuple))
  ("inactive <" (make 'tuple))
  ("inactive @" (make 'attr))
  ("inactive >" (make 'hlink))
  ("inactive C->" (make 'write))
  ("inactive #" (make 'arg))
  ("inactive $" (make 'symbol))
  ("inactive '" (make 'quote))
  ("inactive `" (make 'quasiquote))
  ("inactive ," (make 'unquote))
  ("inactive ?" (make 'if))
  ("inactive C-?" (make 'if*))

  ("executable d" (make 'div))
  ("executable f" (make 'find-file))
  ("executable F" (make 'flag))
  ("executable l" (make 'length))
  ("executable m" (make 'mod))
  ("executable q" (make 'is-tuple))
  ("executable t" (make 'translate))
  ("executable |" (make 'or))
  ("executable ^" (make 'xor))
  ("executable &" (make 'and))
  ("executable !" (make 'not))
  ("executable +" (make 'plus))
  ("executable -" (make 'minus))
  ("executable *" (make 'times))
  ("executable /" (make 'over))
  ("executable ;" (make 'merge))
  ("executable ," (make 'range))
  ("executable #" (make 'number))
  ("executable @" (make-arity 'date 0))
  ("executable [" (make 'look-up))
  ("executable =" (make 'equal))
  ("executable <" (make 'less))
  ("executable >" (make 'greater))
  ("executable C-@" (make 'date))
  ("executable C-=" (make 'unequal))
  ("executable C-<" (make 'lesseq))
  ("executable C->" (make 'greatereq)))

(kbd-map
  (:mode in-source?)
  ("A-a" (make 'arg))
  ("A-A" (make 'map-args))
  ("A-c" (make 'compound))
  ("A-C" (make 'case))
  ("A-d" (make 'drd-props))
  ("A-e" (make 'eval-args))
  ("A-m" (make 'macro))
  ("A-n" (make 'get-arity))
  ("A-N" (make 'get-label))
  ("A-q" (make 'quasi))
  ("A-s" (make 'surround))
  ("A-v" (make 'value))
  ("A-w" (make-arity 'with 3))
  ("A-W" (make 'while))
  ("A-x" (make 'xmacro))
  ("A-=" (make 'assign))
  ("A-(" (make 'tuple))
  ("A-#" (make 'arg))
  ("A-!" (make 'eval))
  ("A-'" (make 'quote))
  ("A-`" (make 'quasiquote))
  ("A-," (make 'unquote))
  ("A-?" (make 'if)))
