#ifndef OPTIONS_H
#define OPTIONS_H

#include <qstring.h>
#include <qstringlist.h>

enum OptionType  {SwitchOption,StringOption};

class Option
{
public:
	Option();
	void set (const QString &, const OptionType &, const QString &, const QString &);
	QString getName();
	QString getShort();
	QString getLong();
	OptionType getType();
	void setArg(const QString &);
	QString getArg();
	void setActive();
	bool isActive();
private:
	QString name;
	OptionType type;
	QString sName;
	QString lName;
	QString sarg;
	bool active;
};



typedef QValueList <Option> OptionList;

class Options
{
public:
	Options();
	int parse();
	void add (const QString &,const OptionType &, const QString &, const QString&);
	void setHelpText(const QString&);
	QString getHelpText();
	QString getProgramName();
	QStringList getFileList();
	bool isOn (const QString &);
	QString getArg (const QString &);

private:
	QString progname;
	QString helptext;
	QStringList filelist;
    OptionList optlist;
};

#endif
