#include "xlinkobj.h"
#include "branchobj.h"
#include "mapeditor.h"


/////////////////////////////////////////////////////////////////
// XLinkObj
/////////////////////////////////////////////////////////////////

int XLinkObj::arrowSize=10;						// make instances 

XLinkObj::XLinkObj ():MapObj() 
{
	//	cout << "Const XLinkObj ()\n";
	init();
}

XLinkObj::XLinkObj (QCanvas* c):MapObj(c)
{
	//	cout << "Const XLinkObj (c)  called from MapCenterObj (c)\n";
	init();
}


XLinkObj::~XLinkObj ()
{
	//	cout << "Destr XLinkObj\n";
	if (xLinkState!=undefinedXLink)
		deactivate();
	delete (line);
	delete (poly);
}


void XLinkObj::init () 
{
	beginBranch=NULL;
	endBranch=NULL;
	visBranch=NULL;
	xLinkState=undefinedXLink;

	color=QColor (180,180,180);
	line=new QCanvasLine (canvas);
	width=1;
	line->setPen (QPen(color, width));
	line->setZ (Z_XLINK);

	poly=new QCanvasPolygon (canvas);
	poly->setBrush( color );
	poly->setZ (Z_XLINK);

	setVisibility (false);
}

void XLinkObj::copy (XLinkObj* other)
{
	// TODO copy not used yet
	MapObj::copy (other);
	setVisibility (other->visible);
	beginBranch=other->beginBranch;
	endBranch=other->endBranch;
	width=other->width;
}

void XLinkObj::setBegin (BranchObj *bo)
{
	if (bo) 
	{
		xLinkState=initXLink;
		beginBranch=bo;
		beginPos=beginBranch->getChildPos();
	}	
}

BranchObj* XLinkObj::getBegin ()
{
	return beginBranch;
}

void XLinkObj::setEnd (BranchObj *bo)
{
	if (bo) 
	{
		xLinkState=initXLink;
		endBranch=bo;
		endPos=endBranch->getChildPos();
	}		
}

BranchObj* XLinkObj::getEnd()
{
	return endBranch;
}

void XLinkObj::setWidth (int w)
{
	width=w;
	setColor (color);
}

int XLinkObj::getWidth()
{
	return width;
}

void XLinkObj::setColor(QColor c)
{
	color=c;
	line->setPen (QPen(color, width));
	poly->setBrush( color );
}

QColor XLinkObj::getColor()
{
	return color;
}

void XLinkObj::setEnd (QPoint p)
{
	endPos=p;
}

bool XLinkObj::activate ()
{
	if (beginBranch && endBranch)
	{
		if (beginBranch==endBranch) return false;
		xLinkState=activeXLink;
		beginBranch->addXLink (this);
		endBranch->addXLink (this);
		setVisibility ();
		return true;
	} else
		return false;
}

void XLinkObj::deactivate ()
{
	if (beginBranch)
		beginBranch->removeXLinkRef (this);
	beginBranch=NULL;	
	if (endBranch)
		endBranch->removeXLinkRef (this);
	endBranch=NULL;	
	visBranch=NULL;
	xLinkState=undefinedXLink;

	line->hide();
}

bool XLinkObj::isUsed()
{
	if (beginBranch || endBranch || xLinkState!=undefinedXLink)
		return true;
	else
		return false;
}

void XLinkObj::updateXLink()
{
	QPoint a,b;
	QPointArray pa (3);
	if (visBranch)
	{
		// Only one of the linked branches is visible
		a=b=visBranch->getChildPos();
		if (visBranch->getOrientation()==OrientRightOfCenter)
		{
			b.setX (b.x()+25);
			pa.putPoints (0,3,
				b.x(),b.y(),
				b.x()-arrowSize,b.y()-arrowSize,
				b.x()-arrowSize,b.y()+arrowSize
			);
			poly->setPoints (pa);
		} else
		{
			b.setX (b.x()-25);
			pa.putPoints (0,3,
				b.x(),b.y(),
				b.x()+arrowSize,b.y()-arrowSize,
				b.x()+arrowSize,b.y()+arrowSize);
			poly->setPoints (pa);
		}	
	} else
	{
		// Both linked branches are visible
		if (beginBranch)
			// If a link is just drawn in the editor,
			// we have already a beginBranch
			a=beginBranch->getChildPos();
		else
			// This shouldn't be reached normally...
			a=beginPos;
		if (xLinkState==activeXLink && endBranch)
			b=endBranch->getChildPos();
		else
			b=endPos;
	}


	if (line->startPoint()==a && line->endPoint()==b && !visBranch)
	{
		// update is called from both branches, so only
		// update if something has changed
		return;
	}	
	else
	{
		beginPos=a;
		endPos=b;
		line->setPen (QPen(color, width));
		line->setPoints (a.x(), a.y(), b.x(), b.y());
	}
}

BranchObj* XLinkObj::otherBranch(BranchObj* thisBranch)
{
	if (!beginBranch && !endBranch)
		return NULL;
	if (thisBranch==beginBranch)
		return endBranch;
	else	
		return beginBranch;
}

void XLinkObj::positionBBox()
{
}

void XLinkObj::calcBBoxSize()
{
}

void XLinkObj::setVisibility (bool b)
{
	MapObj::setVisibility (b);
	if (b)
	{
		line->show();
		if (visBranch) 
			poly->show();
		else	
			poly->hide();
	}	
	else
	{
		line->hide();
		poly->hide();
	}	
}

void XLinkObj::setVisibility ()
{
	if (beginBranch && endBranch)
	{
		if(beginBranch->isVisibleObj() && endBranch->isVisibleObj())
		{	// Both ends are visible
			visBranch=NULL;
			setVisibility (true);
		} else
		{
			if(!beginBranch->isVisibleObj() && !endBranch->isVisibleObj())
			{	//None of the ends is visible
				visBranch=NULL;
				setVisibility (false);
			} else
			{	// Just one end is visible, draw a symbol that shows
				// that there is a link to a scrolled branch
				if (beginBranch->isVisibleObj())
					visBranch=beginBranch;
				else
					visBranch=endBranch;
				setVisibility (true);
			}
		}
	}
}

QString XLinkObj::saveToDir ()
{
	QString s="";
	if (beginBranch && endBranch &&xLinkState==activeXLink)
	{
		if (beginBranch==endBranch && xLinkState)
			s="";
		else
		{
			QString colAttr=attribut ("color",color.name());
			QString widAttr=attribut ("width",QString().setNum(width,10));
			QString begSelAttr=attribut ("beginBranch",beginBranch->getSelectString());
			QString endSelAttr=attribut ("endBranch",  endBranch->getSelectString());
			s=beginElement ("xlink", colAttr +widAttr +begSelAttr +endSelAttr);

			s+=endElement ("xlink");
		}
	}
	return s;
}

