/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __XFPRINT_PRINTSETTINGS_H__
#define __XFPRINT_PRINTSETTINGS_H__

#include <option.h>

typedef struct _XfprintSettingsSheets		XfprintSettingsSheets;
typedef struct _XfprintSettingsVirtualPages	XfprintSettingsVirtualPages;
typedef struct _XfprintSettingsPrettyPrint	XfprintSettingsPrettyPrint;
typedef struct _XfprintSettingsInput		XfprintSettingsInput;
typedef struct _XfprintSettingsHeadings		XfprintSettingsHeadings;
typedef struct _XfprintSettings			XfprintSettings;

struct _XfprintSettingsSheets
{
	gboolean	landscape;
	gboolean	fillcols;
	guint		cols;
	guint		rows;
	const gchar	*papersize;
	gboolean	borders;
	gboolean	reverse;
};

struct _XfprintSettingsVirtualPages
{
	guint		linenumbers;
	guint		lpp;		/* lines per page */
	guint		cpl;		/* chars per line */
	guint		tabsize;
	const gchar	*nonprtfmt;
};

struct _XfprintSettingsPrettyPrint
{
	const gchar	*language;
	const gchar	*highlight;
	guint		strip;
};

struct _XfprintSettingsInput
{
	const gchar	*encoding;
	gboolean	all;
	guint		from;
	guint		to;
	gboolean	cut;
	gboolean	interpret;
	gboolean	binary;
};

struct _XfprintSettingsHeadings
{
	gboolean	headers;
	gchar		header[64];
	gchar		underlay[64];
	gchar		ctitle[64];
	gchar		ltitle[64];
	gchar		rtitle[64];
	gchar		cfooter[64];
	gchar		lfooter[64];
	gchar		rfooter[64];
};

struct _XfprintSettings
{
	XfprintSettingsSheets		sheets;
	XfprintSettingsVirtualPages	vpages;
	XfprintSettingsPrettyPrint	pprint;
	XfprintSettingsInput		input;
	XfprintSettingsHeadings		headings;

	guint				copies;
};

extern XfprintSettings	*xfprintsettings_defaults(void);
extern XfprintSettings	*xfprintsettings_load(void);
extern void		xfprintsettings_save(const XfprintSettings *);
extern void		xfprintsettings_free(XfprintSettings *);

/* predefined options */
extern const XfprintOption papersizes[];
extern const XfprintOption encodings[];
extern const XfprintOption languages[];
extern const XfprintOption non_printable_fmts[];
extern const XfprintOption hilevels[];

#endif	/* !__XFPRINT_PRINTSETTINGS_H__ */
