/* src/framework/XSECConfig.hpp.  Generated by configure.  */
/*
 * Copyright 2002-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * XSEC
 *
 * Configuration template for XSECConfig.hpp
 *
 * Filled out by configure
 *
 */

/*
 * These are the high level numerics that need to be changed to bump the
 * version number.  They are generally defined via the configure script.
 *
 * They are used to create version strings - see the details at the end of this file
 */

#define XSEC_VERSION_MAJOR 1
#define XSEC_VERSION_MEDIUM 5
#define XSEC_VERSION_MINOR 1

/*
 * The following defines whether Xalan integration is required.
 *
 * Xalan is used for XSLT and complex XPath processing.
 * Activate this #define if Xalan is not required (or desired)
 */

#define XSEC_NO_XALAN 1

/*
 * Find out the idiosyncracies of the version of Xerces we are using
 */

/* 2.3 and above introduced a version parameter in the XMLFormatter ctor */

#define XSEC_XERCES_FORMATTER_REQUIRES_VERSION 1

/* 2.3 and above use a user defined Memory Manager.  In some cases, this
   actually needs to be passed to functions
*/

#define XSEC_XERCES_REQUIRES_MEMMGR 1

/* Is it possible to setIdAttributes? - DOM level 3 call */

#define XSEC_XERCES_HAS_SETIDATTRIBUTE 1

/* Is it possible to setIdAttributes? - DOM level 3 call.  V3.x
   API Version */

/* #undef XSEC_XERCES_HAS_BOOLSETIDATTRIBUTE */

/* 3.0 no longer supports DOMWriter, must use DOMLSSerializer instead
*/

/* #undef XSEC_XERCES_DOMLSSERIALIZER */

/* 3.0 now uses getInputEncoding rather than getEncoding to determine
   encoding that was found in input document */

/* #undef XSEC_XERCES_DOMENTITYINPUTENCODING */

/* 3.0 now 64-bit safe */

/* #undef XSEC_XERCES_64BITSAFE */

/* 3.0 InputStream must expose content type */

/* #undef XSEC_XERCES_INPUTSTREAM_HAS_CONTENTTYPE */

/*
 * Find out the idiosyncracies of the version of Xalan we are using
 */

/* 1.9 and above have XSLException::getType() returns XalanDOMChar *, not
   XalanDOMString
*/

/* #undef XSEC_XSLEXCEPTION_RETURNS_DOMSTRING */

/* 1.9 and above do not take a XercesDOMSupport as input to the ctor */

/* #undef XSEC_XERCESPARSERLIAISON_REQS_DOMSUPPORT */

/* 1.9 and above require a NodeRefList as input to XPathEvaluator::
   selectNodeList
*/

/* #undef XSEC_SELECTNODELIST_REQS_NODEREFLIST */

/* 1.9 and above use MemoryManager for the XPath Function classes
*/

/* #undef XSEC_XALAN_REQS_MEMORYMANAGER */

/* Does XMLString::release() exist */

#define XSEC_XERCES_XMLSTRING_HAS_RELEASE 1

/*
 * Define presence of cryptographic providers
 */

#define HAVE_OPENSSL 1

/* #undef HAVE_WINCAPI */

/*
 * Some settings for OpenSSL if we have it
 *
 */

#define XSEC_OPENSSL_CONST_BUFFERS 1
#define XSEC_OPENSSL_HAVE_AES 1
#define XSEC_OPENSSL_CANSET_PADDING 1
#define XSEC_OPENSSL_D2IX509_CONST_BUFFER 1
#define XSEC_OPENSSL_HAVE_CRYPTO_CLEANUP_ALL_EX_DATA 1

/*
 * Some string functions (mainly to get past microsoft warning
 * messages
 */

/* Do we have _strdup(const char *) - probably not, but... */

/* #undef XSEC_HAVE__STRDUP */
/* #undef XSEC_HAVE__STRICMP */

/* How do we handle stricmp style requirements? */

/* #undef XSEC_HAVE_STRICMP */
#define XSEC_HAVE_STRCASECMP 1

/*
 * Macros used to determine what header files exist on this
 * system
 */

/* Posix unistd.h */
#define HAVE_UNISTD_H 1

/* Windows direct.h */
/* #undef HAVE_DIRECT_H */

// --------------------------------------------------------------------------------
//           Version Handling
// --------------------------------------------------------------------------------

/*
 * The following code makes use of the Xerces version handling macros to define
 * some constants that can be used during conditional compilation.
 */

/* This can be used for conditional compilation and for testing during
 * autoconfigures.
 *
 * It will create a string of the form 10000 * MAJOR + 100 * MEDIUM + MINOR
 * E.g. 10301 for version 1.3.1
 */

#define _XSEC_VERSION_FULL CALC_EXPANDED_FORM (XSEC_VERSION_MAJOR,XSEC_VERSION_MEDIUM,XSEC_VERSION_MINOR)

/* Some useful strings for versioning - based on the same strings from Xerces */

#define XSEC_FULLVERSIONSTR INVK_CAT3_SEP_UNDERSCORE(XSEC_VERSION_MAJOR,XSEC_VERSION_MEDIUM,XSEC_VERSION_MINOR)
#define XSEC_FULLVERSIONDOT INVK_CAT3_SEP_PERIOD(XSEC_VERSION_MAJOR,XSEC_VERSION_MEDIUM,XSEC_VERSION_MINOR)
#define XSEC_FULLVERSIONNUM INVK_CAT3_SEP_NIL(XSEC_VERSION_MAJOR,XSEC_VERSION_MEDIUM,XSEC_VERSION_MINOR)
#define XSEC_VERSIONSTR     INVK_CAT2_SEP_UNDERSCORE(XSEC_VERSION_MAJOR,XSEC_VERSION_MEDIUM)

/* The following is used for backwards compatibility with previous version handling */

#define XSEC_VERSION "1.5.1"


