#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <gtk/gtk.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "globals.h"

void init_temp_img()
	{ gchar *tempo;
	tempimg=strdup("/tmp/xmmscoverXXXXXX");
	tempo=mkdtemp(tempimg);
	tempdir=strdup(tempo);
	free(tempimg);
	tempimg=g_strdup_printf("%s/coverviewer/pingoo.jpg",DATADIR);
	}

void clean_temp()
{ gchar *cmd;
  cmd = g_strdup_printf("\\rm -r %s", tempdir);
  system(cmd);
  g_free(cmd);
 }

void purge_temp()
{ gchar *cmd;
  cmd = g_strdup_printf("\\rm -r %s/*.img 2>/dev/null", tempdir);
  system(cmd);
  g_free(cmd);
 }


gchar *up(gchar *str)
	{ char *buf;
	  int i;
	i=strlen(str);
	buf=strdup(str);
	*(buf+i)=0;
	while (i>=0)
		{
		*(buf+i)=toupper(*(buf+i));
		i--;
		}
	return buf;
	}

gchar *replace(gchar *str, gchar *oldchaine, gchar *newchaine)
	{ gchar *wstr,*temp,*pos;
	
	if (str==NULL || strlen(oldchaine)==0) {return NULL; }
	//printf("ENTREE : [%s] OLD : [%s] NEW [%s]\n",str,oldchaine,newchaine);
	wstr=strdup(str);
	free(str);
	while ((pos=strstr(wstr,oldchaine))!=NULL)
		{
		temp=(gchar*) malloc(strlen(wstr)-strlen(oldchaine)+strlen(newchaine)+1);
		strncpy(temp,wstr,pos-wstr);
		temp[pos-wstr]=0;
		strcat(temp,newchaine);
		strcat(temp,pos+strlen(oldchaine)),
		//temp[strlen(wstr)-strlen(oldchaine)+strlen(newchaine)]=0;
		free(wstr);
		wstr=temp;
		}
	return wstr;
	}

gchar *find_file(gchar *path, gchar *filter)
	{ gchar *temp,*name;
	DIR *dir;
	struct dirent *files;
	struct stat buf;
	
	dir = opendir (path);
	if (dir != NULL)
		{
		while ((files=readdir(dir))!=NULL)
			{
			if (!strcmp(files->d_name, ".") ||!strcmp(files->d_name, ".."))
                        	{ continue; }
			temp=malloc(strlen(path)+strlen(files->d_name)+2);
			strcpy(temp,path);
			strcat(temp,"/");
			strcat(temp,files->d_name);
			stat(temp, &buf);
			if (S_ISDIR(buf.st_mode))
				{
				//Rpertoire
				name=find_file(temp,filter);
				free(temp);
				if (name)
					{
					//Trouv!
					closedir(dir);
					return name;
					}
				}
			else
				{
				//FILE
				name=up(files->d_name);
				if (strcmp(name,filter)==0)
					{
					//Trouv
					closedir(dir);
					free(name);
					return temp;
					}
				}
			}
		}
	closedir(dir);
	return NULL;
	}

gchar *exists_file(gchar *path, gchar *filter, gchar *ext)
	{ gchar *name,*temp;
	DIR *dir;
	struct dirent *files;
	
	dir = opendir (path);
	if (dir != NULL)
		{
		while ((files=readdir(dir))!=NULL)
			{
			temp=malloc(strlen(path)+strlen(files->d_name)+2);
			strcpy(temp,path);
			strcat(temp,"/");
			strcat(temp,files->d_name);
			name=up(files->d_name);
			if (strstr(name,filter)!=NULL && strstr(name,ext)!=NULL)
				{
				//Trouv
				free(name);
				closedir(dir);
				return temp;
				}
			free(temp);
			free(name);
			}
		}
	closedir(dir);
	return NULL;
	}
