
local recover
func __recover(__fname,s=)
/* DOCUMENT  recover(file,s=)
   restore the date in FILE. Can be Yorick (not .sav) or IDL (.sav) file.

   KEYWORDS: s= : if set and not null, do it silently.
*/
{
  if(is_func(autoload)!=2) require,"idlsave.i";
  if(is_void(s)) s=0;
  
  suffix=strpart(__fname,-2:);
  if(suffix=="sav")  __ff=idl_open(__fname);
  else __ff=openb(__fname);
    
  if(!s) show,__ff;
  restore,__ff;
  close,__ff;
}
if(is_func(recover)!=2) {
  recover=__recover;
  if(is_void(upload)||__BASTIEN) upload=recover;
}

local ssave;
func __ssave(fstrm,var_name,var_value)
/* DOCUMENT ssave(fstrm,var_name,var_value)

   Same as 'save' but the data 'VAR_VALUE' are saved under the name
   'VAR_NAME'. FSTRM is a binary stream open/create with
   openb/createb/updateb

   EXAMPLE:  save,fstrm,a is equivalent to ssave,fstrm,"a",a
   
   SEE ALSO:
 */
{
  if(is_void(var_value)) var_value=symbol_def(var_name);
  add_variable,fstrm,-1,var_name,structof(var_value),dimsof(var_value);
  get_member(fstrm,var_name)=var_value;
}
if(is_func(ssave)!=2) ssave=__ssave;


func duplicateb(fstrmi,fstrmo,vars,nvars)
/* DOCUMENT duplicateb(fstrmi,fstrmo,vars,nvars)

   Save all the variables in FSTRMI listed in VARS but not in NVARS to
   the file FSTRMO (thus duplicateb). If VARS is void, it is initialized
   with the variable names present in FSTRMI.

   SEE ALSO:
 */
{
  name_list=(is_void(vars)?(*get_vars(fstrmi)(1)):vars);
  if(!is_void(nvars))
    {
      idx=where((name_list(,-)!=nvars(-,))(,sum));
      if(is_array(idx))
        name_list=name_list(idx);
      else
        return;
    }
  name_list=suniq(name_list);
  for(i=1;i<=numberof(name_list);i++)
    ssave,fstrmo,name_list(i),get_member(fstrmi,name_list(i));
}




















