#include "vpm450m_fw.h"

static int init_vpm450m(void *wc)
{
	tOCT6100_CHIP_OPEN ChipOpen;
	tOCT6100_GET_INSTANCE_SIZE InstanceSize;
	UINT32 ulResult;
	tOCT6100_CHANNEL_OPEN ChannelOpen;
	
	struct stat sb;
	char *filename = "OCT6104-128D.ima";
	int fd;
	void *fw;
	int x;
	
	Oct6100ChipOpenDef(&ChipOpen);

	/* Setup Chip Open Parameters */
	ChipOpen.ulUpclkFreq = cOCT6100_UPCLK_FREQ_33_33_MHZ;
	Oct6100GetInstanceSizeDef(&InstanceSize);
	
	ChipOpen.pbyImageFile = vpm450m_fw;
	ChipOpen.pProcessContext = wc;
	ChipOpen.ulImageSize = sizeof(vpm450m_fw); 
	ChipOpen.fEnableMemClkOut = TRUE;
	ChipOpen.ulMemClkFreq = cOCT6100_MCLK_FREQ_133_MHZ;
	ChipOpen.ulMaxChannels = 128;
	ChipOpen.ulMemoryType = cOCT6100_MEM_TYPE_DDR;
	ChipOpen.ulMemoryChipSize = cOCT6100_MEMORY_CHIP_SIZE_32MB;
	ChipOpen.ulNumMemoryChips = 1;
	ChipOpen.ulMaxTdmStreams = 4;
	ChipOpen.aulTdmStreamFreqs[0] = cOCT6100_TDM_STREAM_FREQ_8MHZ;
	ChipOpen.ulTdmSampling = cOCT6100_TDM_SAMPLE_AT_FALLING_EDGE;
#if 0
	ChipOpen.fEnableAcousticEcho = TRUE;
#endif		

	ulResult = Oct6100GetInstanceSize(&ChipOpen, &InstanceSize);
	if (ulResult != cOCT6100_ERR_OK) {
		fprintf(stderr, "Failed to get instance size, code %08x!\n", ulResult);
		return -1;
	}
	
	
	pApiInstance = malloc(InstanceSize.ulApiInstanceSize);
	if (!pApiInstance) {
		fprintf(stderr, "Out of memory (can't allocate %d bytes)!\n", InstanceSize.ulApiInstanceSize);
		return -1;
	}

	ulResult = Oct6100ChipOpen(pApiInstance, &ChipOpen);
	if (ulResult != cOCT6100_ERR_OK) {
		fprintf(stderr, "Failed to open chip, code %08x!\n", ulResult);
		return -1;
	}
	for (x=0;x<128;x++) {
		Oct6100ChannelOpenDef(&ChannelOpen);tOCT6100_CHIP_OPEN
		ChannelOpen.pulChannelHndl = &aulEchoChanHndl[x];
		ChannelOpen.ulUserChanId = x;
		ChannelOpen.TdmConfig.ulRinPcmLaw = cOCT6100_PCM_U_LAW;
		ChannelOpen.TdmConfig.ulRinStream = 1;
		ChannelOpen.TdmConfig.ulRinTimeslot = x;
		ChannelOpen.TdmConfig.ulSinPcmLaw = cOCT6100_PCM_U_LAW;
		ChannelOpen.TdmConfig.ulSinStream = 0;
		ChannelOpen.TdmConfig.ulSinTimeslot = x;
		ChannelOpen.TdmConfig.ulSoutPcmLaw = cOCT6100_PCM_U_LAW;
		ChannelOpen.TdmConfig.ulSoutStream = 3;
		ChannelOpen.TdmConfig.ulSoutTimeslot = x;
		ChannelOpen.TdmConfig.ulRoutPcmLaw = cOCT6100_PCM_U_LAW;
		ChannelOpen.TdmConfig.ulRoutStream = 2;
		ChannelOpen.TdmConfig.ulRoutTimeslot = x;
		
		ChannelOpen.VqeConfig.fEnableNlp = TRUE;
		ChannelOpen.VqeConfig.fRinDcOffsetRemoval = TRUE;
		ChannelOpen.VqeConfig.fSinDcOffsetRemoval = TRUE;
		
		ChannelOpen.fEnableToneDisabler = TRUE;
		ChannelOpen.ulEchoOperationMode = cOCT6100_ECHO_OP_MODE_POWER_DOWN;
		
		ulResult = Oct6100ChannelOpen(pApiInstance, &ChannelOpen);
		if (ulResult != GENERIC_OK) {
			fprintf(stderr, "Failed to open channel %d!\n", x);
		}
	}
	return 0;
}

static int close_chip(void)
{
	UINT32 ulResult;
	tOCT6100_CHIP_CLOSE ChipClose;
	Oct6100ChipCloseDef(&ChipClose);
	ulResult = Oct6100ChipClose(pApiInstance, &ChipClose);
	if (ulResult != cOCT6100_ERR_OK) {
		fprintf(stderr, "Failed to close chip, code %08x!\n", ulResult);
		return -1;
	}
	return 0;
}
