#ifndef __FIREGL_AGP__
#define __FIREGL_AGP__

//#include <linux/version.h>
//#include <linux/bitops.h> // for hweight16 on 2.4 kenrels

/*
 * AGPGART module version 0.99
 * Copyright (C) 1999 Jeff Hartmann
 * Copyright (C) 1999 Precision Insight, Inc.
 * Copyright (C) 1999 Xi Graphics, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * JEFF HARTMANN, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

/* further general & copyright notes, for e.g. VIA KT400/AGP3, 
 * compareable to Linux kernel 2.5/2.6 tree */
/*
 * AGPGART backend specific includes. Not for userspace consumption.
 *
 * Copyright (C) 2002-2003 Dave Jones
 * Copyright (C) 1999 Jeff Hartmann
 * Copyright (C) 1999 Precision Insight, Inc.
 * Copyright (C) 1999 Xi Graphics, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * JEFF HARTMANN, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

/*
 *
 * Modified by FGL Graphics, a division of SONICblue Inc.
 * Copyright (C) 2000 FGL Graphics, a division of SONICblue Inc.
 *
 */

/*
 *
 * Modified by Jason Barto (jpbarto@graffiti.net) to provide
 * support for the VIA P4X400 Northbridge.
 * Modifications made on 04/30/2003
 *
 */

/*
 * Update Status
 * =============
 * This source file is synced with code in:
 * - linux-2.4.16 (Linus Torvalds/Marcelo Tosatti)
 * - linux-2.4.8-ac7 (Alan Cox)
 * see www.kernel.org and related ftp sites for reference.
 * and
 * - http://innominate.org/cgi-bin/lksr/linux/include/linux/agp_backend.h
 *   version 1.1.5, 2001-10-09, CVS-Tag: LINUX_2_4_13
 */

/* AGP module will be staticly linked to FireGL kernel module */
#define _X(_x) __fgl_##_x
//extern int _X(agp_init)(void);
//extern void _X(agp_cleanup)(void);
extern int _X(agp_try_unsupported);

#ifndef __GFP_COMP
#define __GFP_COMP 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

enum _X(chipset_type) 
{
    _X(NOT_SUPPORTED),
    _X(SUPPORTED),
};

struct _X(agp_version) 
{
    u16 major;
    u16 minor;
};

struct _X(agp_kern_info) 
{
    struct _X(agp_version) version;
    struct pci_dev *device;
    enum _X(chipset_type) chipset;
    unsigned long mode;
    off_t aper_base;
    size_t aper_size;
    int max_memory;		/* In pages */
    int current_memory;
    int cant_use_aperture;
    unsigned long page_mask;
    struct vm_operations_struct *vm_ops;
};

/* 
 * The agp_memory structure has information
 * about the block of agp memory allocated.
 * A caller may manipulate the next and prev
 * pointers to link each allocated item into
 * a list.  These pointers are ignored by the 
 * backend.  Everything else should never be
 * written to, but the caller may read any of
 * the items to detrimine the status of this
 * block of agp memory.
 * 
 */

struct _X(agp_memory) {
	int key;
	struct _X(_agp_memory) *next;
	struct _X(_agp_memory) *prev;
	size_t page_count;
	int num_scratch_pages;
	unsigned long *memory;
#ifdef __ia64__
	// I tink this ifdef can go away, Johannes
	void *vmptr;
#endif
	off_t pg_start;
	u32 type;
#ifdef FGL
    u32 alloc_type;
#endif
	u32 physical;
	u8 is_bound;
	u8 is_flushed;
};

typedef struct {
    void                    (*free_memory)(struct _X(agp_memory) *);
    struct _X(agp_memory) * (*allocate_memory)(size_t, u32);
    int                     (*bind_memory)(struct _X(agp_memory) *, off_t);
    int                     (*unbind_memory)(struct _X(agp_memory) *);
    void                    (*enable)(u32);
    int                     (*acquire)(void);
    void                    (*release)(void);
    int                     (*copy_info)(struct _X(agp_kern_info) *);
} _X(drm_agp_t);

//typedef struct { volatile int counter; } atomic_t;
struct atomic_t;
struct pgprot_t;

#ifdef STANDALONE_AGPGART
#define AGP_NORMAL_MEMORY 0
#endif /* STANDALONE_AGPGART */

#ifndef FIREGL_AGP_HOOK_DEFINES_ONLY

#ifdef FGL
extern struct _X(agp_memory) *_X(agp_allocate_memory_phys_list)(size_t, u32,unsigned long *);

/*
 * agp_allocate_memory_phys_list :
 * 
 * This function assigns a group of physcial adresses of
 * to a agp_memory structure.
 * 
 * It takes a size_t argument of the number of pages, and
 * an u32 argument of the type of memory to be allocated.  
 * Every agp bridge device will allow you to allocate 
 * AGP_NORMAL_MEMORY which maps to physical ram.  Any other
 * type is device dependant.
 * 
 * It returns NULL whenever memory is unavailable.
 * 
 */
#endif

extern void _X(agp_free_memory)(struct _X(agp_memory) *);
extern void _X(_agp_free_memory)(struct _X(agp_memory) *);

/*
 * agp_free_memory :
 * 
 * This function frees memory associated with
 * an agp_memory pointer.  It is the only function
 * that can be called when the backend is not owned
 * by the caller.  (So it can free memory on client
 * death.)
 * 
 * It takes an agp_memory pointer as an argument.
 * 
 */

extern struct _X(agp_memory) *_X(agp_allocate_memory)(size_t, u32);

/*
 * agp_allocate_memory :
 * 
 * This function allocates a group of pages of
 * a certain type.
 * 
 * It takes a size_t argument of the number of pages, and
 * an u32 argument of the type of memory to be allocated.  
 * Every agp bridge device will allow you to allocate 
 * AGP_NORMAL_MEMORY which maps to physical ram.  Any other
 * type is device dependant.
 * 
 * It returns NULL whenever memory is unavailable.
 * 
 */

extern int _X(agp_copy_info)(struct _X(agp_kern_info) *);

/*
 * agp_copy_info :
 * 
 * This function copies information about the
 * agp bridge device and the state of the agp
 * backend into an agp_kern_info pointer.
 * 
 * It takes an agp_kern_info pointer as an
 * argument.  The caller should insure that
 * this pointer is valid.
 * 
 */

extern int _X(agp_bind_memory)(struct _X(agp_memory) *, off_t);

/*
 * agp_bind_memory :
 * 
 * This function binds an agp_memory structure
 * into the graphics aperture translation table.
 * 
 * It takes an agp_memory pointer and an offset into
 * the graphics aperture translation table as arguments
 * 
 * It returns -EINVAL if the pointer == NULL.
 * It returns -EBUSY if the area of the table
 * requested is already in use.
 * 
 */

extern int _X(agp_unbind_memory)(struct _X(agp_memory) *);

/* 
 * agp_unbind_memory :
 * 
 * This function removes an agp_memory structure
 * from the graphics aperture translation table.
 * 
 * It takes an agp_memory pointer as an argument.
 * 
 * It returns -EINVAL if this piece of agp_memory
 * is not currently bound to the graphics aperture
 * translation table or if the agp_memory 
 * pointer == NULL
 * 
 */

extern void _X(agp_enable)(u32);

/* 
 * agp_enable :
 * 
 * This function initializes the agp point-to-point
 * connection.
 * 
 * It takes an agp mode register as an argument
 * 
 */

extern int _X(agp_backend_acquire)(void);

/*
 * agp_backend_acquire :
 * 
 * This Function attempts to acquire the agp
 * backend.
 * 
 * returns -EBUSY if agp is in use,
 * returns 0 if the caller owns the agp backend
 */

extern void _X(agp_backend_release)(void);

struct agp_bridge_data;
extern void _X(get_agp_version)(struct agp_bridge_data *bridge);


void firegl_agp_exit(void);

void* firegl_agp_alloc_pages(void);
void firegl_agp_generic_destroy_page(void *addr);
/*
 * agp_backend_release :
 * 
 * This Function releases the lock on the agp
 * backend.
 * 
 * The caller must insure that the graphics
 * aperture translation table is read for use
 * by another entity.  (Ensure that all memory
 * it bound is unbound.)
 * 
 */

#endif // !FIREGL_AGP_HOOK_DEFINES_ONLY

/* alias defines */
#define chipset_type            _X(chipset_type)
#define SUPPORTED 1

#define _agp_version            _X(_agp_version)
#define agp_version             _X(agp_version)
#define _agp_kern_info          _X(_agp_kern_info)
#define agp_kern_info           _X(agp_kern_info)
#define _agp_memory             _X(_agp_memory)
#define agp_memory              _X(agp_memory)
#ifdef FGL
#undef agp_allocate_memory_phys_list
#define agp_allocate_memory_phys_list   _X(agp_allocate_memory_phys_list)
#endif
#undef agp_free_memory
#define agp_free_memory         _X(_agp_free_memory)
#undef agp_allocate_memory
#define agp_allocate_memory     _X(agp_allocate_memory)
#undef agp_copy_info
#define agp_copy_info           _X(agp_copy_info)
#undef agp_bind_memory
#define agp_bind_memory         _X(agp_bind_memory)
#undef agp_unbind_memory
#define agp_unbind_memory       _X(agp_unbind_memory)
#undef agp_enable
#define agp_enable              _X(agp_enable)
#undef agp_backend_acquire
#define agp_backend_acquire     _X(agp_backend_acquire)
#undef agp_backend_release
#define agp_backend_release     _X(agp_backend_release)
#undef agp_try_unsupported
#define agp_try_unsupported     _X(agp_try_unsupported)
#undef agp_frontend_initialize
#define agp_frontend_initialize _X(agp_frontend_initialize)
#undef agp_frontend_cleanup
#define agp_frontend_cleanup    _X(agp_frontend_cleanup)
#undef get_agp_version
#define get_agp_version         _X(get_agp_version)
#undef drm_agp_t
#define drm_agp_t               _X(drm_agp_t)

#ifndef PCI_ANY_ID
#define PCI_ANY_ID                      (~0)
#endif

#ifndef NOT_SUPPORTED           
#define NOT_SUPPORTED                   0
#endif
/* these defines are not from the standard agp.h, 
 * they are from pci_ids.h. Some earlier version of 
 * 2.6 kernels doesn't have these defined
 */
#ifndef PCI_DEVICE_ID_VIA_3269_0
#define PCI_DEVICE_ID_VIA_3269_0        0x0269
#endif

#ifndef PCI_DEVICE_ID_VIA_3296_0
#define PCI_DEVICE_ID_VIA_3296_0        0x0296
#endif

#ifndef PCI_DEVICE_ID_VIA_K8T800PRO_0
#define PCI_DEVICE_ID_VIA_K8T800PRO_0   0x0282
#endif

#ifndef PCI_DEVICE_ID_VIA_3238_0
#define PCI_DEVICE_ID_VIA_3238_0        0x0238
#endif

#ifndef PCI_CLASS_BRIDGE_HOST
#define PCI_CLASS_BRIDGE_HOST 		0x0600
#endif

#ifndef PCI_DEVICE_ID_INTEL_82915G_HB
#define PCI_DEVICE_ID_INTEL_82915G_HB   0x2580
#endif

#ifndef PCI_DEVICE_ID_INTEL_82915G_IG
#define PCI_DEVICE_ID_INTEL_82915G_IG   0x2582
#endif

#ifndef PCI_DEVICE_ID_AL_M1632
#define PCI_DEVICE_ID_AL_M1632          0x1632
#endif

#ifndef PCI_DEVICE_ID_AL_M1671
#define PCI_DEVICE_ID_AL_M1671          0x1671
#endif

#ifndef PCI_DEVICE_ID_AMD_8151_0
#define PCI_DEVICE_ID_AMD_8151_0        0x7454
#endif

#ifndef PCI_DEVICE_ID_VIA_8385_0
#define PCI_DEVICE_ID_VIA_8385_0        0x3188
#endif

#ifndef PCI_DEVICE_ID_VIA_8380_0
#define PCI_DEVICE_ID_VIA_8380_0        0x0204
#endif

#ifndef PCI_DEVICE_ID_VIA_838X_1
#define PCI_DEVICE_ID_VIA_838X_1        0xB188
#endif

#ifndef PCI_DEVICE_ID_NVIDIA_NFORCE3
#define PCI_DEVICE_ID_NVIDIA_NFORCE3    0x00d1
#endif

#ifndef PCI_DEVICE_ID_NVIDIA_NFORCE3S
#define PCI_DEVICE_ID_NVIDIA_NFORCE3S   0x00e1
#endif

#ifndef PCI_DEVICE_ID_SI_755
#define PCI_DEVICE_ID_SI_755            0x0755
#endif

#ifndef PCI_DEVICE_ID_ATI_RS100
#define PCI_DEVICE_ID_ATI_RS100         0xcab0
#endif

#ifndef PCI_DEVICE_ID_ATI_RS200
#define PCI_DEVICE_ID_ATI_RS200         0xcab2
#endif

#ifndef PCI_DEVICE_ID_ATI_RS200_B
#define PCI_DEVICE_ID_ATI_RS200_B       0xcbb2
#endif

#ifndef PCI_DEVICE_ID_ATI_RS250
#define PCI_DEVICE_ID_ATI_RS250         0xcab3
#endif

#ifndef PCI_DEVICE_ID_ATI_RS300_100
#define PCI_DEVICE_ID_ATI_RS300_100     0x5830
#endif

#ifndef PCI_DEVICE_ID_ATI_RS300_133
#define PCI_DEVICE_ID_ATI_RS300_133     0x5831
#endif

#ifndef PCI_DEVICE_ID_ATI_RS300_166
#define PCI_DEVICE_ID_ATI_RS300_166     0x5832
#endif

#ifndef PCI_DEVICE_ID_ATI_RS300_200
#define PCI_DEVICE_ID_ATI_RS300_200     0x5833
#endif

#ifndef PCI_VENDOR_ID_TRANSMETA
#define PCI_VENDOR_ID_TRANSMETA         0x1279
#endif

#ifndef PCI_DEVICE_ID_EFFICEON
#define PCI_DEVICE_ID_EFFICEON          0x0060
#endif

#ifndef PCI_DEVICE_ID_INTEL_82830_HB
#define PCI_DEVICE_ID_INTEL_82830_HB    0x3575
#endif

#ifndef PCI_DEVICE_ID_INTEL_82845G_HB
#define PCI_DEVICE_ID_INTEL_82845G_HB   0x2560
#endif

#ifndef PCI_DEVICE_ID_INTEL_82443GX_0
#define PCI_DEVICE_ID_INTEL_82443GX_0   0x71a0
#endif

#ifndef PCI_DEVICE_ID_INTEL_82810E_MC
#define PCI_DEVICE_ID_INTEL_82810E_MC   0x7124
#endif

#ifndef PCI_DEVICE_ID_INTEL_82810E_IG
#define PCI_DEVICE_ID_INTEL_82810E_IG   0x7125
#endif

#ifndef PCI_DEVICE_ID_INTEL_82815_MC
#define PCI_DEVICE_ID_INTEL_82815_MC    0x1130
#endif

#ifndef PCI_DEVICE_ID_INTEL_82815_CGC
#define PCI_DEVICE_ID_INTEL_82815_CGC   0x1132
#endif

#ifndef PCI_DEVICE_ID_INTEL_82820_HB
#define PCI_DEVICE_ID_INTEL_82820_HB    0x2500
#endif

#ifndef PCI_DEVICE_ID_INTEL_82820_UP_HB
#define PCI_DEVICE_ID_INTEL_82820_UP_HB 0x2501
#endif

#ifndef PCI_DEVICE_ID_INTEL_82830_HB
#define PCI_DEVICE_ID_INTEL_82830_HB    0x3575
#endif

#ifndef PCI_DEVICE_ID_INTEL_82830_CGC
#define PCI_DEVICE_ID_INTEL_82830_CGC   0x3577
#endif

#ifndef PCI_DEVICE_ID_INTEL_82840_HB
#define PCI_DEVICE_ID_INTEL_82840_HB    0x1a21
#endif

#ifndef PCI_DEVICE_ID_INTEL_82845_HB
#define PCI_DEVICE_ID_INTEL_82845_HB    0x1a30
#endif

#ifndef PCI_DEVICE_ID_INTEL_82855GM_HB
#define PCI_DEVICE_ID_INTEL_82855GM_HB  0x3580
#endif

#ifndef PCI_DEVICE_ID_INTEL_82855GM_IG
#define PCI_DEVICE_ID_INTEL_82855GM_IG  0x3582
#endif

#ifndef PCI_DEVICE_ID_INTEL_82850_HB
#define PCI_DEVICE_ID_INTEL_82850_HB    0x2530
#endif

#ifndef PCI_DEVICE_ID_INTEL_82860_HB
#define PCI_DEVICE_ID_INTEL_82860_HB    0x2531
#endif

#ifndef PCI_DEVICE_ID_INTEL_82845G_HB
#define PCI_DEVICE_ID_INTEL_82845G_HB   0x2560
#endif

#ifndef PCI_DEVICE_ID_INTEL_82845G_IG
#define PCI_DEVICE_ID_INTEL_82845G_IG   0x2562
#endif

#ifndef PCI_DEVICE_ID_INTEL_82865_HB
#define PCI_DEVICE_ID_INTEL_82865_HB    0x2570
#endif

#ifndef PCI_DEVICE_ID_INTEL_82865_IG
#define PCI_DEVICE_ID_INTEL_82865_IG    0x2572
#endif

#ifndef PCI_DEVICE_ID_INTEL_82875_HB
#define PCI_DEVICE_ID_INTEL_82875_HB    0x2578
#endif

#ifndef PCI_DEVICE_ID_INTEL_82875_IG
#define PCI_DEVICE_ID_INTEL_82875_IG    0x257b
#endif

#ifndef PCI_DEVICE_ID_INTEL_82915G_HB
#define PCI_DEVICE_ID_INTEL_82915G_HB   0x2580
#endif

#ifndef PCI_DEVICE_ID_INTEL_82915G_IG
#define PCI_DEVICE_ID_INTEL_82915G_IG   0x2582
#endif

#ifndef PCI_DEVICE_ID_INTEL_7205_0
#define PCI_DEVICE_ID_INTEL_7205_0      0x255d
#endif

#ifndef PCI_DEVICE_ID_INTEL_7505_0
#define PCI_DEVICE_ID_INTEL_7505_0      0x2550
#endif

#ifndef PCI_DEVICE_ID_INTEL_82855PM_HB
#define PCI_DEVICE_ID_INTEL_82855PM_HB  0x3340
#endif

#define PCI_VENDOR_ID_INTEL             0x8086
#define PCI_DEVICE_ID_INTEL_EESSC       0x0008
#define PCI_DEVICE_ID_INTEL_21145       0x0039
#define PCI_DEVICE_ID_INTEL_82375       0x0482
#define PCI_DEVICE_ID_INTEL_82424       0x0483
#define PCI_DEVICE_ID_INTEL_82378       0x0484
#define PCI_DEVICE_ID_INTEL_82430       0x0486
#define PCI_DEVICE_ID_INTEL_82434       0x04a3
#define PCI_DEVICE_ID_INTEL_I960        0x0960
#define PCI_DEVICE_ID_INTEL_I960RM      0x0962
#define PCI_DEVICE_ID_INTEL_82562ET     0x1031
#define PCI_DEVICE_ID_INTEL_82801CAM    0x1038
#define PCI_DEVICE_ID_INTEL_82815_MC    0x1130
#define PCI_DEVICE_ID_INTEL_82815_AB    0x1131
#define PCI_DEVICE_ID_INTEL_82815_CGC   0x1132
#define PCI_DEVICE_ID_INTEL_82559ER     0x1209
#define PCI_DEVICE_ID_INTEL_82092AA_0   0x1221
#define PCI_DEVICE_ID_INTEL_82092AA_1   0x1222
#define PCI_DEVICE_ID_INTEL_7116        0x1223
#define PCI_DEVICE_ID_INTEL_7505_0      0x2550  
#define PCI_DEVICE_ID_INTEL_7505_1      0x2552  
#define PCI_DEVICE_ID_INTEL_7205_0      0x255d
#define PCI_DEVICE_ID_INTEL_82596       0x1226
#define PCI_DEVICE_ID_INTEL_82865       0x1227
#define PCI_DEVICE_ID_INTEL_82557       0x1229
#define PCI_DEVICE_ID_INTEL_82437       0x122d
#define PCI_DEVICE_ID_INTEL_82371FB_0   0x122e
#define PCI_DEVICE_ID_INTEL_82371FB_1   0x1230
#define PCI_DEVICE_ID_INTEL_82371MX     0x1234
#define PCI_DEVICE_ID_INTEL_82437MX     0x1235
#define PCI_DEVICE_ID_INTEL_82441       0x1237
#define PCI_DEVICE_ID_INTEL_82380FB     0x124b
#define PCI_DEVICE_ID_INTEL_82439       0x1250
#define PCI_DEVICE_ID_INTEL_80960_RP    0x1960
#define PCI_DEVICE_ID_INTEL_82840_HB    0x1a21
#define PCI_DEVICE_ID_INTEL_82845_HB    0x1a30
#define PCI_DEVICE_ID_INTEL_82801AA_0   0x2410
#define PCI_DEVICE_ID_INTEL_82801AA_1   0x2411
#define PCI_DEVICE_ID_INTEL_82801AA_2   0x2412
#define PCI_DEVICE_ID_INTEL_82801AA_3   0x2413
#define PCI_DEVICE_ID_INTEL_82801AA_5   0x2415
#define PCI_DEVICE_ID_INTEL_82801AA_6   0x2416
#define PCI_DEVICE_ID_INTEL_82801AA_8   0x2418
#define PCI_DEVICE_ID_INTEL_82801AB_0   0x2420
#define PCI_DEVICE_ID_INTEL_82801AB_1   0x2421
#define PCI_DEVICE_ID_INTEL_82801AB_2   0x2422
#define PCI_DEVICE_ID_INTEL_82801AB_3   0x2423
#define PCI_DEVICE_ID_INTEL_82801AB_5   0x2425
#define PCI_DEVICE_ID_INTEL_82801AB_6   0x2426
#define PCI_DEVICE_ID_INTEL_82801AB_8   0x2428
#define PCI_DEVICE_ID_INTEL_82801BA_0   0x2440
#define PCI_DEVICE_ID_INTEL_82801BA_1   0x2442
#define PCI_DEVICE_ID_INTEL_82801BA_2   0x2443
#define PCI_DEVICE_ID_INTEL_82801BA_3   0x2444
#define PCI_DEVICE_ID_INTEL_82801BA_4   0x2445
#define PCI_DEVICE_ID_INTEL_82801BA_5   0x2446
#define PCI_DEVICE_ID_INTEL_82801BA_6   0x2448
#define PCI_DEVICE_ID_INTEL_82801BA_7   0x2449
#define PCI_DEVICE_ID_INTEL_82801BA_8   0x244a
#define PCI_DEVICE_ID_INTEL_82801BA_9   0x244b
#define PCI_DEVICE_ID_INTEL_82801BA_10  0x244c
#define PCI_DEVICE_ID_INTEL_82801BA_11  0x244e
#define PCI_DEVICE_ID_INTEL_82801E_0    0x2450
#define PCI_DEVICE_ID_INTEL_82801E_2    0x2452
#define PCI_DEVICE_ID_INTEL_82801E_3    0x2453
#define PCI_DEVICE_ID_INTEL_82801E_9    0x2459
#define PCI_DEVICE_ID_INTEL_82801E_11   0x245b
#define PCI_DEVICE_ID_INTEL_82801E_13   0x245d
#define PCI_DEVICE_ID_INTEL_82801E_14   0x245e
#define PCI_DEVICE_ID_INTEL_82801CA_0   0x2480
#define PCI_DEVICE_ID_INTEL_82801CA_2   0x2482
#define PCI_DEVICE_ID_INTEL_82801CA_3   0x2483
#define PCI_DEVICE_ID_INTEL_82801CA_4   0x2484
#define PCI_DEVICE_ID_INTEL_82801CA_5   0x2485
#define PCI_DEVICE_ID_INTEL_82801CA_6   0x2486
#define PCI_DEVICE_ID_INTEL_82801CA_7   0x2487
#define PCI_DEVICE_ID_INTEL_82801CA_10  0x248a
#define PCI_DEVICE_ID_INTEL_82801CA_11  0x248b
#define PCI_DEVICE_ID_INTEL_82801CA_12  0x248c
#define PCI_DEVICE_ID_INTEL_82801DB_0   0x24c0
#define PCI_DEVICE_ID_INTEL_82801DB_1   0x24c1
#define PCI_DEVICE_ID_INTEL_82801DB_2   0x24c2
#define PCI_DEVICE_ID_INTEL_82801DB_3   0x24c3
#define PCI_DEVICE_ID_INTEL_82801DB_4   0x24c4
#define PCI_DEVICE_ID_INTEL_82801DB_5   0x24c5
#define PCI_DEVICE_ID_INTEL_82801DB_6   0x24c6
#define PCI_DEVICE_ID_INTEL_82801DB_7   0x24c7
#define PCI_DEVICE_ID_INTEL_82801DB_9   0x24c9
#define PCI_DEVICE_ID_INTEL_82801DB_10  0x24ca
#define PCI_DEVICE_ID_INTEL_82801DB_11  0x24cb
#define PCI_DEVICE_ID_INTEL_82801DB_12  0x24cc
#define PCI_DEVICE_ID_INTEL_82801DB_13  0x24cd
#define PCI_DEVICE_ID_INTEL_82801EB_0   0x24d0
#define PCI_DEVICE_ID_INTEL_82801EB_1   0x24d1
#define PCI_DEVICE_ID_INTEL_82801EB_2   0x24d2
#define PCI_DEVICE_ID_INTEL_82801EB_3   0x24d3
#define PCI_DEVICE_ID_INTEL_82801EB_4   0x24d4
#define PCI_DEVICE_ID_INTEL_82801EB_5   0x24d5
#define PCI_DEVICE_ID_INTEL_82801EB_6   0x24d6
#define PCI_DEVICE_ID_INTEL_82801EB_7   0x24d7
#define PCI_DEVICE_ID_INTEL_82801EB_11  0x24db
#define PCI_DEVICE_ID_INTEL_82801EB_13  0x24dd
#define PCI_DEVICE_ID_INTEL_ESB_1       0x25a1
#define PCI_DEVICE_ID_INTEL_ESB_2       0x25a2
#define PCI_DEVICE_ID_INTEL_ESB_3       0x25a3
#define PCI_DEVICE_ID_INTEL_ESB_31      0x25b0
#define PCI_DEVICE_ID_INTEL_ESB_4       0x25a4
#define PCI_DEVICE_ID_INTEL_ESB_5       0x25a6
#define PCI_DEVICE_ID_INTEL_ESB_6       0x25a7
#define PCI_DEVICE_ID_INTEL_ESB_7       0x25a9
#define PCI_DEVICE_ID_INTEL_ESB_8       0x25aa
#define PCI_DEVICE_ID_INTEL_ESB_9       0x25ab
#define PCI_DEVICE_ID_INTEL_ESB_11      0x25ac
#define PCI_DEVICE_ID_INTEL_ESB_12      0x25ad
#define PCI_DEVICE_ID_INTEL_ESB_13      0x25ae
#define PCI_DEVICE_ID_INTEL_82820_HB    0x2500
#define PCI_DEVICE_ID_INTEL_82820_UP_HB 0x2501
#define PCI_DEVICE_ID_INTEL_82850_HB    0x2530
#define PCI_DEVICE_ID_INTEL_82860_HB    0x2531
#define PCI_DEVICE_ID_INTEL_82845G_HB   0x2560
#define PCI_DEVICE_ID_INTEL_82845G_IG   0x2562
#define PCI_DEVICE_ID_INTEL_82865_HB    0x2570
#define PCI_DEVICE_ID_INTEL_82865_IG    0x2572
#define PCI_DEVICE_ID_INTEL_82875_HB    0x2578
#define PCI_DEVICE_ID_INTEL_82875_IG    0x257b
#define PCI_DEVICE_ID_INTEL_82915G_HB   0x2580
#define PCI_DEVICE_ID_INTEL_82915G_IG   0x2582
#define PCI_DEVICE_ID_INTEL_82915GM_HB  0x2590
#define PCI_DEVICE_ID_INTEL_82915GM_IG  0x2592
#define PCI_DEVICE_ID_INTEL_ICH6_0      0x2640
#define PCI_DEVICE_ID_INTEL_ICH6_1      0x2641
#define PCI_DEVICE_ID_INTEL_ICH6_2      0x2642
#define PCI_DEVICE_ID_INTEL_ICH6_3      0x2651
#define PCI_DEVICE_ID_INTEL_ICH6_4      0x2652
#define PCI_DEVICE_ID_INTEL_ICH6_5      0x2653
#define PCI_DEVICE_ID_INTEL_ICH6_6      0x2658
#define PCI_DEVICE_ID_INTEL_ICH6_7      0x2659
#define PCI_DEVICE_ID_INTEL_ICH6_8      0x265a
#define PCI_DEVICE_ID_INTEL_ICH6_9      0x265b
#define PCI_DEVICE_ID_INTEL_ICH6_10     0x265c
#define PCI_DEVICE_ID_INTEL_ICH6_11     0x2660
#define PCI_DEVICE_ID_INTEL_ICH6_12     0x2662
#define PCI_DEVICE_ID_INTEL_ICH6_13     0x2664
#define PCI_DEVICE_ID_INTEL_ICH6_14     0x2666
#define PCI_DEVICE_ID_INTEL_ICH6_15     0x2668
#define PCI_DEVICE_ID_INTEL_ICH6_16     0x266a
#define PCI_DEVICE_ID_INTEL_ICH6_17     0x266d
#define PCI_DEVICE_ID_INTEL_ICH6_18     0x266e
#define PCI_DEVICE_ID_INTEL_ICH6_19     0x266f
#define PCI_DEVICE_ID_INTEL_ICH7_1      0x27b1
#define PCI_DEVICE_ID_INTEL_ICH7_2      0x27c0
#define PCI_DEVICE_ID_INTEL_ICH7_3      0x27c1
#define PCI_DEVICE_ID_INTEL_ICH7_4      0x27c2
#define PCI_DEVICE_ID_INTEL_ICH7_5      0x27c4
#define PCI_DEVICE_ID_INTEL_ICH7_6      0x27c5
#define PCI_DEVICE_ID_INTEL_ICH7_7      0x27c8
#define PCI_DEVICE_ID_INTEL_ICH7_8      0x27c9
#define PCI_DEVICE_ID_INTEL_ICH7_9      0x27ca
#define PCI_DEVICE_ID_INTEL_ICH7_10     0x27cb
#define PCI_DEVICE_ID_INTEL_ICH7_11     0x27cc
#define PCI_DEVICE_ID_INTEL_ICH7_12     0x27d0
#define PCI_DEVICE_ID_INTEL_ICH7_13     0x27d2
#define PCI_DEVICE_ID_INTEL_ICH7_14     0x27d4
#define PCI_DEVICE_ID_INTEL_ICH7_15     0x27d6
#define PCI_DEVICE_ID_INTEL_ICH7_16     0x27d8
#define PCI_DEVICE_ID_INTEL_ICH7_17     0x27da
#define PCI_DEVICE_ID_INTEL_ICH7_18     0x27dc
#define PCI_DEVICE_ID_INTEL_ICH7_19     0x27dd
#define PCI_DEVICE_ID_INTEL_ICH7_20     0x27de
#define PCI_DEVICE_ID_INTEL_ICH7_21     0x27df
#define PCI_DEVICE_ID_INTEL_ICH7_22     0x27e0
#define PCI_DEVICE_ID_INTEL_ICH7_23     0x27e2
#define PCI_DEVICE_ID_INTEL_82855PM_HB  0x3340
#define PCI_DEVICE_ID_INTEL_82830_HB    0x3575
#define PCI_DEVICE_ID_INTEL_82830_CGC   0x3577
#define PCI_DEVICE_ID_INTEL_82855GM_HB  0x3580
#define PCI_DEVICE_ID_INTEL_82855GM_IG  0x3582
#define PCI_DEVICE_ID_INTEL_E7520_MCH   0x3590
#define PCI_DEVICE_ID_INTEL_E7320_MCH   0x3592
#define PCI_DEVICE_ID_INTEL_MCH_PA      0x3595
#define PCI_DEVICE_ID_INTEL_MCH_PA1     0x3596
#define PCI_DEVICE_ID_INTEL_MCH_PB      0x3597
#define PCI_DEVICE_ID_INTEL_MCH_PB1     0x3598
#define PCI_DEVICE_ID_INTEL_MCH_PC      0x3599
#define PCI_DEVICE_ID_INTEL_MCH_PC1     0x359a
#define PCI_DEVICE_ID_INTEL_E7525_MCH   0x359e
#define PCI_DEVICE_ID_INTEL_80310       0x530d
#define PCI_DEVICE_ID_INTEL_82371SB_0   0x7000
#define PCI_DEVICE_ID_INTEL_82371SB_1   0x7010
#define PCI_DEVICE_ID_INTEL_82371SB_2   0x7020
#define PCI_DEVICE_ID_INTEL_82437VX     0x7030
#define PCI_DEVICE_ID_INTEL_82439TX     0x7100
#define PCI_DEVICE_ID_INTEL_82371AB_0   0x7110
#define PCI_DEVICE_ID_INTEL_82371AB     0x7111
#define PCI_DEVICE_ID_INTEL_82371AB_2   0x7112
#define PCI_DEVICE_ID_INTEL_82371AB_3   0x7113
#define PCI_DEVICE_ID_INTEL_82810_MC1   0x7120
#define PCI_DEVICE_ID_INTEL_82810_IG1   0x7121
#define PCI_DEVICE_ID_INTEL_82810_MC3   0x7122
#define PCI_DEVICE_ID_INTEL_82810_IG3   0x7123
#define PCI_DEVICE_ID_INTEL_82810E_MC   0x7124
#define PCI_DEVICE_ID_INTEL_82810E_IG   0x7125
#define PCI_DEVICE_ID_INTEL_82443LX_0   0x7180
#define PCI_DEVICE_ID_INTEL_82443LX_1   0x7181
#define PCI_DEVICE_ID_INTEL_82443BX_0   0x7190
#define PCI_DEVICE_ID_INTEL_82443BX_1   0x7191
#define PCI_DEVICE_ID_INTEL_82443BX_2   0x7192
#define PCI_DEVICE_ID_INTEL_440MX       0x7195
#define PCI_DEVICE_ID_INTEL_82443MX_0   0x7198
#define PCI_DEVICE_ID_INTEL_82443MX_1   0x7199
#define PCI_DEVICE_ID_INTEL_82443MX_2   0x719a
#define PCI_DEVICE_ID_INTEL_82443MX_3   0x719b
#define PCI_DEVICE_ID_INTEL_82443GX_0   0x71a0
#define PCI_DEVICE_ID_INTEL_82443GX_1   0x71a1
#define PCI_DEVICE_ID_INTEL_82443GX_2   0x71a2
#define PCI_DEVICE_ID_INTEL_82372FB_0   0x7600
#define PCI_DEVICE_ID_INTEL_82372FB_1   0x7601
#define PCI_DEVICE_ID_INTEL_82372FB_2   0x7602
#define PCI_DEVICE_ID_INTEL_82372FB_3   0x7603
#define PCI_DEVICE_ID_INTEL_82454GX     0x84c4
#define PCI_DEVICE_ID_INTEL_82450GX     0x84c5
#define PCI_DEVICE_ID_INTEL_82451NX     0x84ca
#define PCI_DEVICE_ID_INTEL_82454NX     0x84cb
#define PCI_DEVICE_ID_INTEL_84460GX     0x84ea
#define PCI_DEVICE_ID_INTEL_IXP4XX      0x8500
#define PCI_DEVICE_ID_INTEL_IXP2400     0x9001
#define PCI_DEVICE_ID_INTEL_IXP2800     0x9004
#define PCI_DEVICE_ID_INTEL_S21152BB    0xb152
#ifndef PCI_DEVICE_ID_NVIDIA_NFORCE
#define PCI_DEVICE_ID_NVIDIA_NFORCE     0x01a4
#endif

#ifndef PCI_DEVICE_ID_NVIDIA_NFORCE2
#define PCI_DEVICE_ID_NVIDIA_NFORCE2    0x01e0
#endif

#ifndef PCI_DEVICE_ID_SI_655
#define PCI_DEVICE_ID_SI_655            0x0655
#endif

#ifndef PCI_DEVICE_ID_SI_661
#define PCI_DEVICE_ID_SI_661            0x0661
#endif

#ifndef PCI_DEVICE_ID_SI_741
#define PCI_DEVICE_ID_SI_741            0x0741
#endif

#ifndef PCI_DEVICE_ID_SI_760
#define PCI_DEVICE_ID_SI_760            0x0760
#endif

#ifndef PCI_DEVICE_ID_VIA_82C691_0
#define PCI_DEVICE_ID_VIA_82C691_0      0x0691
#endif

#ifndef PCI_DEVICE_ID_VIA_XN266
#define PCI_DEVICE_ID_VIA_XN266         0x3156
#endif

#ifndef PCI_DEVICE_ID_VIA_8753_0
#define PCI_DEVICE_ID_VIA_8753_0        0x3128
#endif

#ifndef PCI_DEVICE_ID_VIA_8653_0
#define PCI_DEVICE_ID_VIA_8653_0        0x3101
#endif

#ifndef PCI_DEVICE_ID_VIA_XM266
#define PCI_DEVICE_ID_VIA_XM266         0x3116
#endif

#ifndef PCI_DEVICE_ID_VIA_862X_0
#define PCI_DEVICE_ID_VIA_862X_0        0x3123
#endif

#ifndef PCI_DEVICE_ID_VIA_8377_0
#define PCI_DEVICE_ID_VIA_8377_0        0x3189
#endif

#ifndef PCI_DEVICE_ID_VIA_8703_51_0
#define PCI_DEVICE_ID_VIA_8703_51_0     0x3148
#endif

#ifndef PCI_DEVICE_ID_VIA_8754C_0
#define PCI_DEVICE_ID_VIA_8754C_0       0x3168
#endif

#ifndef PCI_DEVICE_ID_VIA_8763_0
#define PCI_DEVICE_ID_VIA_8763_0        0x0198
#endif

#ifndef PCI_DEVICE_ID_VIA_8378_0
#define PCI_DEVICE_ID_VIA_8378_0        0x3205
#endif

#ifndef PCI_DEVICE_ID_VIA_PT880
#define PCI_DEVICE_ID_VIA_PT880         0x3258
#endif

#ifndef PCI_DEVICE_ID_VIA_8783_0
#define PCI_DEVICE_ID_VIA_8783_0        0x3208
#endif

#ifndef PCI_DEVICE_ID_VIA_PX8X0_0
#define PCI_DEVICE_ID_VIA_PX8X0_0       0x0259
#endif

#ifndef PCI_DEVICE_ID_VIA_83_87XX_1
#define PCI_DEVICE_ID_VIA_83_87XX_1     0xB198
#endif

#ifndef PCI_DEVICE_ID_VIA_8377_0
#define PCI_DEVICE_ID_VIA_8377_0        0x3189
#endif

#ifndef PCI_DEVICE_ID_VIA_82C691_0
#define PCI_DEVICE_ID_VIA_82C691_0      0x0691
#endif

#ifndef PCI_DEVICE_ID_VIA_XN266
#define PCI_DEVICE_ID_VIA_XN266         0x3156
#endif

#ifndef PCI_DEVICE_ID_VIA_8753_0
#define PCI_DEVICE_ID_VIA_8753_0        0x3128
#endif

#ifndef PCI_DEVICE_ID_VIA_8653_0
#define PCI_DEVICE_ID_VIA_8653_0        0x3101
#endif

#ifndef PCI_DEVICE_ID_VIA_XM266
#define PCI_DEVICE_ID_VIA_XM266         0x3116
#endif

#ifndef PCI_DEVICE_ID_VIA_862X_0
#define PCI_DEVICE_ID_VIA_862X_0        0x3123
#endif

#define PCI_VENDOR_ID_AL                0x10b9
#define PCI_DEVICE_ID_AL_M1445          0x1445
#define PCI_DEVICE_ID_AL_M1449          0x1449
#define PCI_DEVICE_ID_AL_M1451          0x1451
#define PCI_DEVICE_ID_AL_M1461          0x1461
#define PCI_DEVICE_ID_AL_M1489          0x1489
#define PCI_DEVICE_ID_AL_M1511          0x1511
#define PCI_DEVICE_ID_AL_M1513          0x1513
#define PCI_DEVICE_ID_AL_M1521          0x1521
#define PCI_DEVICE_ID_AL_M1523          0x1523
#define PCI_DEVICE_ID_AL_M1531          0x1531
#define PCI_DEVICE_ID_AL_M1533          0x1533
#define PCI_DEVICE_ID_AL_M1535          0x1535
#define PCI_DEVICE_ID_AL_M1541          0x1541
#define PCI_DEVICE_ID_AL_M1543          0x1543
#define PCI_DEVICE_ID_AL_M1563          0x1563
#define PCI_DEVICE_ID_AL_M1621          0x1621
#define PCI_DEVICE_ID_AL_M1631          0x1631
#define PCI_DEVICE_ID_AL_M1632          0x1632
#define PCI_DEVICE_ID_AL_M1641          0x1641
#define PCI_DEVICE_ID_AL_M1644          0x1644
#define PCI_DEVICE_ID_AL_M1647          0x1647
#define PCI_DEVICE_ID_AL_M1651          0x1651
#define PCI_DEVICE_ID_AL_M1671          0x1671
#define PCI_DEVICE_ID_AL_M1681          0x1681
#define PCI_DEVICE_ID_AL_M1683          0x1683
#define PCI_DEVICE_ID_AL_M1689          0x1689
#define PCI_DEVICE_ID_AL_M3307          0x3307
#define PCI_DEVICE_ID_AL_M4803          0x5215
#define PCI_DEVICE_ID_AL_M5219          0x5219
#define PCI_DEVICE_ID_AL_M5228          0x5228
#define PCI_DEVICE_ID_AL_M5229          0x5229
#define PCI_DEVICE_ID_AL_M5237          0x5237
#define PCI_DEVICE_ID_AL_M5243          0x5243
#define PCI_DEVICE_ID_AL_M5451          0x5451
#define PCI_DEVICE_ID_AL_M7101          0x7101
#ifndef flush_agp_cache
#define flush_agp_cache() asm volatile("wbinvd":::"memory")
#endif

#ifndef map_page_into_agp
#define map_page_into_agp(page) change_page_attr(page, 1, PAGE_KERNEL_NOCACHE)
#endif

#ifndef global_flush_tlb
#define global_flush_tlb() /* TODO for 2.4 kernel, flush_tlb_all() */
#endif

#ifndef flush_agp_mappings
#define flush_agp_mappings() global_flush_tlb()
#endif

#ifndef pfn_to_page
#define pfn_to_page(pfn) (mem_map + (pfn))
#endif

#ifndef pfn_valid
#define pfn_valid(pfn) ((pfn) < max_mapnr)
#endif

#ifndef unmap_page_from_agp
#define unmap_page_from_agp(page) change_page_attr(page, 1, PAGE_KERNEL)
#endif

#ifndef on_each_cpu
#define on_each_cpu(func,info,retry,wait)   ({ func(info); 0; })
#endif

#ifndef PG_locked
#define PG_locked                   0
#endif

#ifndef SetPageLocked
#define SetPageLocked(page) set_bit(PG_locked, &(page)->flags)
#endif

#if 0
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
#define module_put(x) MOD_DEC_USE_COUNT
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
#define __module_get(x) MOD_INC_USE_COUNT
#endif
#endif

#undef __iomem
#define __iomem

#endif
