//
//  Login.app
// 
//  Copyright (c) 1997, 1998 Per Liden
// 
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef _Panel_h_
#define _Panel_h_

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/cursorfont.h>
#include <X11/Xmu/WinUtil.h>
#include <sys/wait.h>
#include <getopt.h>
#include <stdlib.h>
#include <signal.h>
#include <iostream.h>
#include "Panel.xpm"
#include "SwitchUser.h"
#include "Input.h"
#include "Config.h"
#include "Const.h"


class Panel
{
public:   
    Panel(Display* dpy, int scr, Window root);
    ~Panel();
    void OpenPanel();
    void ClosePanel();
    void ClearPanel();
    void ShrinkPanel();
    void ShakePanel();
    void Message(char* text);
    Input* GetInput();
    int EventHandler(XEvent* event);

private:
    Panel();
    void Cursor(int visible);
    unsigned long GetColor(char* colorname);
    void OnExpose(XEvent* event);
    void OnKeyPress(XEvent* event);

    // Private data
    Window Win;
    Window Root;
    Display* Dpy;
    int Scr;
    int X, Y;
    GC TextGC;
    int Action;

    // Pixmap data
    Pixmap PanelPixmap;
    Pixmap ShrinkPixmap;
    XpmAttributes PanelPixmapAttributes;

    // Name/Passwd handler
    Input* In;
};

#endif


