/***************************************************************************
                          contactaddeduserdialog.cpp  -  description
                             -------------------
    begin                : Sun Apr 14 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "contactaddeduserdialog.h"

#include <qlabel.h>
#include <klocale.h>

ContactAddedUserDialog::ContactAddedUserDialog()
{
}



ContactAddedUserDialog::~ContactAddedUserDialog()
{
}



// The user picked "add contact to the friends list".
void ContactAddedUserDialog::addContactPressed()
{
  returnValue_ = ADD;
  close();
}



// The user chose to let the contact view his or her online state, but
//  not to add the contact.
void ContactAddedUserDialog::allowContactPressed()
{
  returnValue_ = ALLOW;
  close();
}



// The user chose to block the contact.
void ContactAddedUserDialog::blockContactPressed()
{
  returnValue_ = BLOCK;
  close();
}



// Show the dialog modally, then return the user's choice.
int ContactAddedUserDialog::launch(QString contactHandle, QString contactName)
{
  // Set the default return value
  returnValue_ = BLOCK;
  // Set up the label
  messageLabel_->setText( messageLabel_->text().arg(contactName + " (" + contactHandle + ")") );
  // Show the dialog modally
  exec();
  // The return value should be set properly.  Return it.
  return returnValue_;
}

#include "contactaddeduserdialog.moc"
