/***************************************************************************
                          contactpropertiesdialog.h  -  description
                             -------------------
    begin                : Sun Dec 15 2002
    copyright            : (C) 2002 by Michael Curtis
    email                : magnalium@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTPROPERTIESDIALOG_H
#define CONTACTPROPERTIESDIALOG_H

#include <qcstring.h>
#include <qwidget.h>
#include <kdialogbase.h>

// Forward declarations
class Contact;
class KLineEdit;
class QCheckBox;
class QLabel;

/**The dialog for modifying contact properties (ContactExtension).
  *@author Michael Curtis
  */

class ContactPropertiesDialog : public KDialogBase
{
   Q_OBJECT

  public:
  	             ContactPropertiesDialog(QWidget *parent=0, const char *name=0);
  	            ~ContactPropertiesDialog();
    // Show the dialog and obtain the contact handle.
    bool         launch(Contact *contact);

  protected slots: // Protected slots
    // The Cancel button was pressed.
    void         slotCancel();
    // The OK button was pressed.
    void         slotOk();

  private: // Private methods
    void         applyChanges();
    void         setupWidgets();
    // Get the location of a file from the user, using a KFile dialog
    void         chooseFile(KLineEdit *edit, QString wildcard);

  private slots:
   // The alt name checkbox was toggled.
   void          alternativeNameCheckBoxToggled(bool checked);
   // Choose a picture file (KFile dialog)
   void          choosePicture();
   // Choose a sound file (KFile dialog)
   void          chooseSound();
   // The online notification checkbox was toggled
   void          notifyOnlineCheckBoxToggled(bool checked);

  private: // Private attributes
    // The checkbox showing whether or not to use the contact's alternative name
    QCheckBox   *alternativeNameCheckBox_;
    // The contact to operate on
    Contact     *contact_;
    // A label showing the contact's email address
    QLabel      *emailLabel_;
    // The contact name line edit
    KLineEdit   *nameEdit_;
    // The contact's true name label
    QLabel      *trueNameLabel_;
    // The checkbox showing whether or not to notify this user if the contact goes on or offline
    QCheckBox   *notifyOnlineCheckBox_;
    // Whether or not OK was pressed.
    bool         ok_;
    // The picture file line edit
    KLineEdit   *pictureEdit_;
    // The sound file line edit
    KLineEdit   *soundEdit_;

};

#endif
