#!/bin/sh

# Use git to create src/GitRev.h.new with latest commit information. If this
# fails (e.g., because git is not available), we assume that this is an export
# so the commit info is in GitArchiveInfo.txt
git --git-dir=".git" show --no-patch --pretty="// This file is used to identify the latest git commit. Please do not touch.%n#define GIT_COMMIT_HASH \"%h\"%n#define GIT_COMMIT_DATE \"%ci\"%n" > src/GitRev.h.new 2> /dev/null || cp GitArchiveInfo.txt src/GitRev.h.new


# Check if src/GitRev.h and src/GitRev.h.new are the same. If so, we clean up
# and are done
diff --new-file src/GitRev.h src/GitRev.h.new > /dev/null && { rm -f src/GitRev.h.new; exit 0; }

# If src/GitRev.h and src/GitRev.h.new differ we take the new one
mv src/GitRev.h.new src/GitRev.h

# NB: The version info in *.plist will be generated by CMake

