/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_GUI_WINDOWOBSERVER_HPP
#define INDII_GUI_WINDOWOBSERVER_HPP

namespace indii {
class Window;

/**
 * Observer of main window.
 */
class WindowObserver {
public:
  /**
   * Notify that window is closing.
   *
   * @param window The window being closed.
   * @param exiting Is the program exiting?
   */
  virtual void notifyClose(Window* window, const bool exiting = false) = 0;
};
}

#endif
