/*
 *  Sarien AGI :: Copyright (C) 1999 Dark Fiber 
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "sarien.h"
#include "agi.h"
#include "rand.h"
#include "gfx.h"
#include "keyboard.h"
#include "picture.h"
#include "view.h"
#include "logic.h"
#include "sound.h"
#include "opcodes.h"
#include "console.h"

#define TICK_SECONDS 20
 
/* For the engine control panel */
UINT8	console_active = 1;
UINT8   console_input_active = 1;
UINT16  console_index;
UINT16	console_y = 150;
UINT16  console_first_line = CONSOLE_LINES_BUFFER - CONSOLE_LINES_ONSCREEN;
UINT16	console_input_key = 0;
UINT16  console_count;
char *console_line[CONSOLE_LINES_BUFFER];

/* FIXME: kludge */
//UINT8 blocking_window;
//UINT8 timed_window;


static void update_objects(void)
{
	SINT16	i;
	SINT16	ccel;

	/* now copy the bitmaps onto the screen */
	for(i = 0; i < MAX_VIEWTABLE; i++)
	{
#define VT view_table[i]
		/* FR
		 * Changed here 
		 */
		if ( !(VT.flags & UPDATE) )
			continue;

		if( !(VT.flags & ANIMATED) || !(VT.flags & DRAWN) )
			continue;

		if ( VT.flags & CYCLING ) {
			VT.cycle_time_count++;

			if (VT.cycle_time_count <= VT.cycle_time) {
				//--draw_obj(i);
				continue;
			}

			VT.cycle_time_count = 1;
			ccel = VT.cur_cel;

			switch (VT.cycle_status)
			{
			case CYCLE_NORMAL:	/* normale cycle status */
				if(++ccel >= VT.num_cels) 
					ccel = 0;

				set_cel (i, ccel);
				
				break;

 			case CYCLE_END_OF_LOOP:		
 				if(++ccel >= VT.num_cels) {
               VT.flags &= ~CYCLING;
               setflag (VT.parm1, __TRUE);
  				} else
 					set_cel (i, ccel);

 				break;

			case CYCLE_REV:				/* reverse cycle */
				if(--ccel < 0)
					ccel = VT.num_cels - 1;

				set_cel (i, ccel);
   			break;

 			case CYCLE_REV_LOOP:
 				if (--ccel < 0) {
					VT.flags &= ~CYCLING;
					setflag (VT.parm1, __TRUE);
 				} 
 					set_cel (i, ccel);

 				break;
			}
		} else {
			if ( (ccel = VT.cur_cel) >= VT.num_cels )
				ccel = 0;

			set_cel ( i, ccel );
		}
	} 
#undef VT
}


static void adj_direction ( UINT8 entry, SINT16 h, SINT16 w )
{
	UINT8          original_direction;
	AGI_VIEW_TABLE *vt_obj;

	if (( h == 0 ) && ( w == 0 ))
		return;

	vt_obj = &view_table[entry];

	original_direction = vt_obj->direction;

	if(abs(w) > abs(h)) {
		if (w > 0)
			vt_obj->direction = h < 0 ? 2 : h > 0 ? 4 : 3;
		else if (w < 0)
			vt_obj->direction = h < 0 ? 8 : h > 0 ? 6 : 7;
		else
			vt_obj->direction = h <=0 ? 1 : 5;
	} else {
		if (h > 0)
			vt_obj->direction = w < 0 ? 6 : w > 0 ? 4 : 5;
		else if (h < 0)
			vt_obj->direction = w < 0 ? 8 : w > 0 ? 2 : 1;
		else
			vt_obj->direction = w <= 0 ? 7 : 3;
	}

	if ( vt_obj->direction != original_direction )
		calc_direction (entry);
}


static void normal_motion (UINT8 em, SINT16 x, SINT16 y)
{
	SINT16	dir, i, w = 0;
	UINT8	v, e, z;
	AGI_VIEW_TABLE *vt_obj;

	vt_obj = &view_table[em];

	x += vt_obj->x_pos;
	y += vt_obj->y_pos;
	dir = vt_obj->direction;
	e = em == EGO_VIEW_TABLE;

	v = e ? V_border_touch_ego : V_border_touch_obj;

	if (x < 0 && (dir == 8 || dir == 7 || dir == 6)) {
		if (!e)
			setvar (V_border_code, em);
		setvar (v, 4);
		return;
	}

	if (x > _WIDTH - vt_obj->x_size &&
		(dir == 2 || dir == 3 || dir == 4)) {
		if (!e)
			setvar (V_border_code, em);
		setvar (v, 2);
		return;
	}

	if (y > _HEIGHT - 1 && (dir == 4 || dir == 5 || dir == 6)) {
		if (!e)
			setvar (V_border_code, em);
		setvar (v, 3);
		return;
	}

	if (y < horizon && (dir == 1 || dir == 2 || dir == 8)) {
		if (!e)
			setvar (V_border_code, em);
		setvar (v, 1);
		return;
	}

	if (e) {
		setflag (F_ego_water, __FALSE);
		setflag (F_ego_touched_p2, __FALSE);
	}

	/* do control lines n shit in here */

	for (i = x + vt_obj->x_size - 1; i >= x; i--)
	{
		switch (control_data[y * _WIDTH + i])
		{
		case 0:	/* unconditional black. no go at all! */
			return;
		case 1:			/* conditional blue */
			if (~vt_obj->flags & IGNORE_BLOCKS)
				return;
			break;
		case 2:			/* trigger */
			if (!e)
				break;
			setflag (3, __TRUE);
			vt_obj->x_pos = x;
			vt_obj->y_pos = y;
			return;
		case 3:			/* water */
			if (!e)
				break;
			w++;
			break;
		}
	}

	if (e) {
		/* Check if ego is completely on water */
		if (w == vt_obj->x_size) {
			vt_obj->x_pos = x;
			vt_obj->y_pos = y;
			setflag (F_ego_water, __TRUE);
			return;
		}
	}

	for (i = x + vt_obj->x_size - 1; i >= x; i--)
	{
		if (y < horizon || y >= _HEIGHT || i < 0 || i >= _WIDTH)
			return;

		/* Whats this? nobody crosses conditionals?
		 *
		 * if (control_data[y * _WIDTH + i] < 3)
		 *	return;
		 */

		z = control_data[y * _WIDTH + i];

		if ((vt_obj->flags & ON_WATER) && z != 3)
			return;

		if ((vt_obj->flags & ON_LAND) && z != 4)
			return;
	}

   /* New object direction */
   adj_direction( em, y - vt_obj->y_pos, x - vt_obj->x_pos );

	vt_obj->x_pos = x;
	vt_obj->y_pos = y;
}


static void set_motion (int em)
{
	int i, mt[9][2] = {
		{  0,  0 }, {  0, -1 }, {  1, -1 }, {  1,  0 },
		{  1,  1 }, {  0,  1 }, { -1,  1 }, { -1,  0 },
		{ -1, -1 }
	};

	i = view_table[em].direction;

	normal_motion (em, mt[i][0], mt[i][1]);
}


static void adj_pos (UINT8 em, UINT8 x2, UINT8 y2)
{
	SINT16 x1, y1, z;
	static UINT16 frac = 0;
	AGI_VIEW_TABLE *vt_obj;

	vt_obj = &view_table[em];

	x1 = vt_obj->x_pos;
	y1 = vt_obj->y_pos;

	/* step size is given * 4, must compute fractionary step increments */
	if (vt_obj->motion == MOTION_FOLLOW_EGO) {
		z = vt_obj->step_size >> 2;
		frac += vt_obj->step_size & 0x03;
		if (frac >= 4) {
			frac -= 4;
			z++;
		}
	} else
		z = vt_obj->step_size;

   /* adjust the direction */
   adj_direction (em, y2 - y1, x2 - x1);

#define CLAMP_MAX(a,b,c) { if(((a)+=(c))>(b)) { (a)=(b); } }
#define CLAMP_MIN(a,b,c) { if(((a)-=(c))<(b)) { (a)=(b); } }
#define CLAMP(a,b,c) { if((a)<(b)) CLAMP_MAX(a,b,c) else CLAMP_MIN(a,b,c) }

	CLAMP (x1, x2, z);
	CLAMP (y1, y2, z);

	vt_obj->x_pos = x1;
	vt_obj->y_pos = y1;
}


static void calc_obj_motion (void)
{
   UINT8 original_direction;
	UINT8	em;
	UINT8	ox, oy;
	AGI_VIEW_TABLE *vt_obj, *vt_ego;

	vt_ego = &view_table[EGO_VIEW_TABLE];

	for (em = 0; em < MAX_VIEWTABLE; em++)
	{
		vt_obj = &view_table[em];

        original_direction = vt_obj->direction;

		if ((~vt_obj->flags & MOTION) || (~vt_obj->flags & UPDATE)) {
			continue;
		}

		vt_obj->step_time_count += vt_obj->step_size;

		if(vt_obj->step_time_count <= vt_obj->step_time) {
			continue;
		}

		vt_obj->step_time_count=1;

		switch(vt_obj->motion)
		{
		case MOTION_NORMAL:		/* normal */
			set_motion    ( em );
			break;
		case MOTION_WANDER:		/* wander */
			ox = vt_obj->x_pos;
			oy = vt_obj->y_pos;
			set_motion (em);

			/* CM: FIXME: when object walks offscreen (x < 0)
			 *     it returns x_pos == ox, y_pos == oy and
			 *     the last frame blitted shows object facing
			 *     another direction.
			 */
			if (vt_obj->x_pos == ox && vt_obj->y_pos == oy)
				vt_obj->direction = rnd (9);
			break;
		case MOTION_FOLLOW_EGO:		/* follow ego */
			adj_pos (em, vt_ego->x_pos, vt_ego->y_pos);

			if (vt_obj->x_pos == vt_ego->x_pos &&
				vt_obj->y_pos == vt_ego->y_pos) {
				vt_obj->motion = MOTION_NORMAL;
				vt_obj->flags &= ~MOTION;
				setflag (vt_obj->parm2, __TRUE);
				vt_obj->parm2 = 1;
				vt_obj->step_size = vt_obj->parm1;
			}
			break;
		case MOTION_MOVE_OBJ:		/* move obj */
			adj_pos (em, vt_obj->parm1, vt_obj->parm2);

			if (vt_obj->x_pos == vt_obj->parm1 &&
				vt_obj->y_pos == vt_obj->parm2) {
				if (em == EGO_VIEW_TABLE)
					setvar (V_ego_dir, 0);

				vt_obj->direction = 0;
				setflag (vt_obj->parm4, __TRUE);
				vt_obj->step_size = vt_obj->parm3;
				vt_obj->flags &= ~MOTION;
				vt_obj->motion = MOTION_NORMAL;
			}
			break;
		}

      if (vt_obj->direction != original_direction)
   		calc_direction (em);
	}
}


static void interpret_cycle (void)
{
	UINT8 line_prompt = __FALSE;

	if(control_mode == program_control)
		view_table[EGO_VIEW_TABLE].direction = getvar (V_ego_dir);
	else
		setvar (V_ego_dir, view_table[EGO_VIEW_TABLE].direction);

	update_status_line (__FALSE);

	release_sprites ();

	do {
		/* set current start IP */
		logics[0].cIP = logics[0].sIP;

		run_logic (0);

		/* make sure logic 0 is not set to 'firsttime' */
		setflag (F_logic_zeron_firsttime, __FALSE);

		setvar (V_key, 0x0);
		setvar (V_word_not_found, 0);
		setvar (V_border_code, 0);			/* 5 */
		setvar (V_border_touch_obj, 0);			/* 4 */
		setflag (F_entered_cli, __FALSE);
		setflag (F_said_accepted_input, __FALSE);
		setflag (F_new_room_exec, __FALSE);		/* 5 */
		setflag (F_output_mode, __FALSE); /*************************/
		setflag (F_restart_game, __FALSE);		/* 6 */
		setflag (F_status_selects_items, __FALSE);	/* 12? */


		if (control_mode == program_control) {
			view_table[EGO_VIEW_TABLE].direction =
				getvar (V_ego_dir);
		} else {
			setvar (V_ego_dir,
				view_table[EGO_VIEW_TABLE].direction);
		}

		clean_input (); 

#ifndef NO_DEBUG
		/* quit built in debugger command */
		if (optDebug == 3 || optDebug == 4)
			optDebug = __TRUE;
#endif

		if (quit_prog_now == __TRUE)
			break;

		update_status_line (__FALSE);

		if (ego_in_new_room) {
			new_room (new_room_num);
//			--exit_all_logics = __FALSE;
//			--ego_in_new_room = __TRUE;
			update_status_line (__TRUE);
			ego_in_new_room = __FALSE;
			line_prompt     = __TRUE;
		} else {
			if (screen_mode == GFX_MODE) {
				calc_obj_motion ();
				update_objects ();
			}
			break;
		}

		exit_all_logics = __FALSE;
	} while (!exit_all_logics);

	redraw_sprites ();

	if (line_prompt)
		print_line_prompt();
}


static void update_timer ()
{

	if (clock_enabled != __TRUE)
		return;

	clock_count++;
	if (clock_count <= TICK_SECONDS)
		return;

	clock_count -= TICK_SECONDS;
	setvar (V_seconds, getvar (V_seconds) + 1);
	if (getvar (V_seconds) < 60)
		return;

	setvar (V_seconds, 0);
	setvar (V_minutes, getvar (V_minutes) + 1);
	if (getvar (V_minutes) < 60)
		return;

	setvar (V_minutes, 0);
	setvar (V_hours, getvar (V_hours) + 1);
	if (getvar (V_hours) < 24)
		return;

	setvar (V_hours, 0);
	setvar (V_days, getvar (V_days) + 1);
}


void main_cycle (UINT8 accept_key)
{
	static UINT32 msg_box_ticks = 0;

	gfx->poll_timer();	/* msdos driver -> does nothing */
	update_timer ();

	poll_keyboard ();

	if (console_active && console_input_active)
		handle_console_keys ();
	else if (accept_key)
		handle_keys ();

	console_cycle ();

	if (getvar (V_window_reset) > 0) {
		msg_box_ticks = getvar (V_window_reset) * 10;
		setvar (V_window_reset, 0);
	}

	if (msg_box_ticks > 0)
		msg_box_ticks--;
}


UINT16 run_game2 (void)
{
	UINT16	ec=err_OK;
	UINT32	x, y, z=12345678;

	stop_sound ();

	clear_buffer ();

	/*setflag(F_logic_zeron_firsttime, __TRUE);*/
	setflag (F_new_room_exec, __TRUE);
	setflag (F_restart_game, __FALSE);
	setflag (F_sound_on, __TRUE);		/* enable sound */
	setvar (V_time_delay, 2);		/* "normal" speed */

	allow_kyb_input = __FALSE;
	new_room_num = 0;
	quit_prog_now = __FALSE;
	clock_enabled = __TRUE;
	ego_in_new_room = __FALSE;
	exit_all_logics = __FALSE;

	report (" \nSarien " VERSION " is ready.\n");
	report ("Running AGI script.\n");
	console_count = 20;

	console_prompt ();

	clean_keyboard ();

	do {
		main_cycle (__TRUE);

		x = 1 + clock_count;		/* x = 1..TICK_SECONDS */
		y = getvar (V_time_delay);	/* 1/20th of second delay */

		if (y == 0 || (x % y == 0 && z != x)) {
			z = x;

			interpret_cycle ();
			clean_keyboard (); 
		}

		do_blit ();

		if (quit_prog_now == 0xFF) {
			ec = err_RestartGame;
			break;
		}
	} while (!quit_prog_now);

	stop_sound ();
	clear_buffer ();
	put_screen ();

	return ec;
}

