static char dqs_c_qmove_rcsid[]="$Id: dqs_c_qmove.c,v 1.1.1.1 1998/08/18 14:39:11 green Exp $";

/*----------------------------------------------------
 * dqs_c_qmove.c Neil Lincoln Dec. 12,1995  16:16:00
 *
 * Copyright 1995
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/************************************************************************/
void dqs_c_qmove(sfd,request_head)
     int           sfd;
     dqs_list_type **request_head;
     
     /*
       dqs_c_qmove-  is used solely by the qmaster and provides services
       to the qmove ancillary.
     */
     
{
  
  int                found;
  int                status;
  char               *cp;
  u_long32           i;
  string             str;
  dqs_list_type      *lp;
  dqs_list_type      *lp2;
  dqs_list_type      listel;
  dqs_list_type      *request_list;
  dqs_list_type      *reply_head=NULL;
  dqs_queue_type     *queue;
  dqs_job_type       *job;
  struct sockaddr_in cli_addr;
  char dqs_mail_subj[1024];
  char dqs_mail_body[1024];
  dqs_list_type *mail_users;
  int            mail_options;
  
  
  DENTER((DQS_EVENT,"dqs_c_qmove"));
  
  request_list= *request_head;
  
  if ((reply_head=dqs_locate_tid(request_list->tid))) {
    /* this transaction has already occurred */ 
    INFO((DQS_EVENT,"DQS_ERROR_0185 TRANSACTION ALREADY OCCURRED"));
    *request_head=dqs_free_list(*request_head);
    if ((sfd=dqs_send_list(NULL,NULL,sfd,reply_head))<0) {
      DEXITE;
      return;
    }
    dqs_close_sfd(sfd);
    DEXIT;
    return;
  }
  
  DPRINTF((DQS_EVENT,"------------------------------------------------------"));
  
  switch(request_list->type) {
  case QMOVE:
    DPRINTF((DQS_EVENT,"===>QMOVE:"));
    DTRACE;
    
    lp=request_list->job->job_identifier_list;
    while (lp) {
      DTRACE;
      job=dqs_locate_job(lp->str0);
      if (!job) {
	NAK((ACK_EVENT,"error: cannot locate the job \"%s\"",
	     lp->str0));
	ERROR((DQS_EVENT,"DQS_ERROR_0186 %s",ACK_EVENT));
	lp=lp->next;
	continue;
      }
      DTRACE;
      
      if( (dqs_job_owner(request_list->user,lp->str0)) && (dqs_operator(request_list->user) ) );{
	NAK((ACK_EVENT,"error: %s - you do not have the necessary privilages to move the job \"%s\"",
	     request_list->user,lp->str0));
	ERROR((DQS_EVENT,"DQS_ERROR_0187 %s",ACK_EVENT));
	lp=lp->next;
	continue;
      }
      
      DTRACE;
      if (job->master_queue) {
	queue=dqs_locate_queue(job->master_queue);
	DTRACE;
	if (!queue){
	  NAK((ACK_EVENT,"error: cannot locate the queue \"%s\" associated with this job",
	       job->master_queue));
	  ERROR((DQS_EVENT,"DQS_ERROR_0188 %s",ACK_EVENT));
	  lp=lp->next;
	  continue;
	}
      }
      
      /* Move code temporarily removed here */		    
      DTRACE;
      ACK((ACK_EVENT,"%s has moved the job \"%s\"" ,request_list->user,lp->str0));
      INFO((DQS_EVENT,"DQS_ERROR_0189 %s",ACK_EVENT));
      lp=lp->next;
    }  /* while lp */
    
    break;
    
    /*------------------------------------------------------*/
  default:
    NAK((ACK_EVENT,"error: unknown list type %d",request_list->type));
    INFO((DQS_EVENT,"DQS_ERROR_0190 %s",ACK_EVENT));
    break;
  }
  DTRACE;
  
 dqs_c_qmove_end:
  
  if (!reply_head)
    {
      NAK((ACK_EVENT,"error: no suitable queues"));
    }
  DTRACE;
  
  reply_head->tid=request_list->tid;
  dqs_save_tid(reply_head,QMOVE);
  request_list->tid=NULL;
  DTRACE;
  
  *request_head=dqs_free_list(*request_head);
  
  if ((sfd=dqs_send_list(NULL,NULL,sfd,reply_head))<0)
    {
      DEXITE;
      return;
    }
  
  dqs_close_sfd(sfd);
  
  DEXIT;
  return;
  
}
