static char dqs_utility_rcsid[]="$Id: dqs_utility.c,v 1.4 1998/10/21 14:42:01 green Exp $";

/*----------------------------------------------------
 * dqs_utility.c Tom Green Mon Jan 31 10:43:09 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_utility.c,v $
 * Revision 1.4  1998/10/21 14:42:01  green
 * Red Hat Alpha port - ADDRLEN incorporated
 *
 * Revision 1.3  1998/10/13 13:40:17  green
 * make the "UNKNOWN" state have precedence over the "ALARM" state in
 * dqs_get_states() as requested by Jim Phillips
 *
 *
 * Revision 1.1.1.1  1998/08/18 14:39:13  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.33  1996/08/26 14:21:09  nrl
 * Incorporated SCRI scheduling changes
 *
 * Revision 3.32  1996/06/27  01:56:11  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.31  1996/06/23  19:41:25  nrl
 * added missing templates for dqs_write_consumable_list,
 * added message types to log entries
 * setup GNU base for makefile.proto.in
 *
 * Revision 3.30  1996/06/17  02:29:19  nrl
 * Updtaes from Guntram Wolski, Ron Lee, John Makosky and
 * Bodo Beckebach
 *
 * Revision 3.29  1996/03/22  04:21:42  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.28  1996/03/21  22:32:00  nrl
 * updated options printing
 *
 * Revision 3.27  1996/03/14  03:16:44  nrl
 * merge in subordinate queues and consumable resource changes
 *
 * Revision 3.26  1996/03/12  17:12:52  nrl
 * removed aborts and replaced with an error messaging scheme
 * to send email to the dqs adminsitrator and wait for
 * actions by that administrator
 *
 * Revision 3.25  1996/02/07  13:08:26  nrl
 * Added "process leader" and TMP_FILES link capability
 *
 * Revision 3.24  1996/01/19  20:59:19  nrl
 * merged SCRI code and new job and queue structure changes
 *
 * Revision 3.23  1995/05/29  18:08:59  nrl
 * More solaris stuff GAGGHH had to differentiate more cases of
 * solaris2.3 and solaris2.4 stuff
 *
 * Revision 3.22  1995/03/05  03:47:46  nrl
 * Included Axel Brandes job scheduling mechanism to keep one
 * user from hawging the queue.
 *
 * Revision 3.21  1995/02/22  14:29:49  nrl
 * added "FREE" macro to make sure all freed pointers are NULL,
 * replaced all calls to free( ) with FREE.
 *
 * Revision 3.20  1995/02/09  12:49:25  nrl
 * Added "delete complex" and "modify complex"
 *
 * Revision 3.19  1995/01/24  21:05:09  nrl
 * made changes to plug memory leaks and to complete the suspend
 * on completion function.
 *
 * Revision 3.18  1994/12/29  02:20:40  nrl
 * Added an EOL to tempstring to correctly terminate the print output
 * of the mail-option display
 *
 * Revision 3.17  1994/08/02  23:24:16  green
 * added the syntax for "-hold_jid jid_list"
 *
 * fixed prinout of "srl" syntax
 *
 * Revision 3.16  1994/06/24  21:14:51  green
 * living with Solaris
 *
 * Revision 3.15  1994/06/16  20:25:52  green
 * forced logging of pid_file in qmaster/dqs_execd
 *
 * Revision 3.14  1994/06/12  19:39:38  green
 * added dqs_sleep() to provide usec sleep resolutions
 *
 * Revision 3.13  1994/06/12  04:00:15  green
 * minor function relocation mods
 *
 * Revision 3.12  1994/06/09  20:03:59  green
 * added "-par generic_sla" and "-par generic_all" to dqs_parse.c,
 * dqs_exec_job.c and dqs_utility.c
 *
 * forgot a couple ";" on my last checkin of dqs_sec.c(knew I should
 * have compiled before checking in...)
 *
 * Revision 3.11  1994/06/08  17:48:17  green
 * added P4 support(with the help of Ralph Butler - Thanks Ralph!)
 *
 * backed down to Rev. 3.3 of dqs_check_to_do_list.c
 *
 * Revision 3.10  1994/06/04  15:24:30  green
 * added "-par parallel_packge" support
 *
 * Revision 3.9  1994/06/03  00:17:30  green
 * modified default "conf_file" and "dqs.h"
 *
 * modified the parsing routines to move the "-exec" option into
 * "-l", "-master" and "-q"
 *
 * Revision 3.8  1994/05/31  01:40:09  green
 * disallowed "-passwd" and "-Passwd" if AFS support not compiled in
 *
 * Revision 3.7  1994/04/20  23:25:55  green
 * added qhold.c qrls.c
 *
 * Revision 3.6  1994/04/01  02:59:36  green
 * added "qalter" support
 *
 * Revision 3.5  1994/03/26  16:33:37  green
 * added "-srl" support.
 *
 * dqs_resolve.c:dqs_read_resolve_file() now returns the primary qmaster
 * name for fields marked as "none"
 *
 * Revision 3.4  1994/03/26  15:29:18  green
 * allowed for "qconf -sq [dest_id_list]" vs "qconf -sq dest_id_list"
 *
 * write generic queue configuration in common_dir
 *
 * Revision 3.3  1994/03/23  14:37:42  green
 * patched dqs_utility.c:dqs_ctime() - tm->mon returns(0-11) where
 * I needed (1-12)...
 *
 * Revision 3.2  1994/03/17  21:23:05  green
 * added a "complex" field to "qconf -qmon"
 *
 * removed the "UNKNOWN group" warning from dqs_utility.c as it was
 * causing confusion and was only a trivial warning anyway...
 *
 * Revision 3.1  1994/03/17  15:40:20  green
 * added support for "qconf -qmon"
 *
 * Revision 3.0  1994/03/07  04:14:50  green
 * 3.0 freeze
 *
 * Revision 1.10  1994/03/04  16:04:57  green
 * all calls to setenv() now funnel through dqs_setenv() to verify they
 * are strlen() < MAX_STRING_SIZE
 *
 * Revision 1.9  1994/03/01  19:23:41  green
 * removed "test" from the default dependancy list in Makefile.proto.
 *
 * changed dqs_show_all_cofigurations() to dqs_show_all_configurations()
 * in dqs_execd.c, qmaster.c and dqs_utility.c.
 *
 * fixed the broken comment exclusion feature in dqs_resolve.c.
 *
 * fixed bug in me.default_cell in dqs_setup.c where conf_file
 * default_cell was not updating me.default_cell.
 *
 * getenv(DQS_CELL) mved out of dqs_getme() into dqs_setup()
 * to allow dqs_getme() to be called on forks.
 *
 * remade func.h.
 *
 * pulled garbage out of test.c.
 *
 * added syntax instructions to resolve_file
 *
 * Revision 1.8  1994/02/28  03:03:11  green
 * added DEFAULT_MANAGER(2) to allow installs without root access.
 *
 * special character in def MAINPROGRAM causing some compilers to choke -
 * removed.
 *
 * Revision 1.7  1994/02/27  22:07:41  green
 * added DQS_VERSION to def.h and dqs_usage()
 *
 * Revision 1.6  1994/02/25  23:13:25  green
 * added "PID_FILE" to def.h to log process id.
 *
 * modified dqs_execd.c and qmaster.c to log pids to a file
 *
 * added dqs_log_pid() to dqs_utility.c
 *
 * remade func.h
 *
 * forced insertion of "green" into Man_head  -- this needs to be removed
 * and a def in dqs.h if running as non-root.
 *
 * Revision 1.5  1994/02/24  18:11:33  green
 * added dqs_show_all_cofigurations() to dqs_execd.c an qmaster.c
 *
 * modified dqs_execd.c and dqs_load_avg.c to use me.default_cell rather than
 * conf.default_cell
 *
 * previous message about errant pointer reference was incorrect.
 * dqs_sig_handlers.c put back like it was previously
 *
 * there was however a point problem with dusage->master in dqs_setup.c.
 *
 * added dqs_show_all_cofigurations() to dqs_utility.c
 *
 * remade func.h
 *
 * activated the "-cell cell_name" option for dqs_execd in globals.h
 *
 * changed fscanf() to fgets() in qsub.c to fix problems on SV machines
 * and to avoid byte-stuffing problems.
 *
 * Revision 1.4  1994/02/10  18:24:39  green
 * removed the following options from "qsub"
 *
 *      -k
 *      -p
 *      -u
 *      -z
 *
 * fixed the following options in "qsub"
 *
 *      -e
 *      -o
 *      -N
 *      -v
 *
 * synced with docs
 *
 * Revision 1.3  1994/02/09  19:48:19  green
 * syncing source with docs
 *
 * Revision 1.2  1994/02/02  20:22:22  green
 * cleaned up "qconf.c" to sync with docs
 *
 * Revision 1.1.1.1  1994/02/01  17:57:48  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/************************************************************************/
void dqs_show_all_configurations()
     
{
  
  u_long32 i,j;
  
  DENTER_EXT((DQS_EVENT,"dqs_dequalify_path"));
  
  i=DEBUG_LOGLEVEL;
  j=DEBUG_ON;
  
  DEBUG_LOGLEVEL=LOG_DEBUG;
  DEBUG_ON=TRUE;
  
  dqs_show_conf();
  dqs_show_job(options);
  dqs_show_me();
  
  DEBUG_LOGLEVEL=i;
  DEBUG_ON=j;
  
  DEXIT;
  return;
  
}

/************************************************************************/
char *dqs_dequalify_path(old_path_str,path_str)
     char *old_path_str;
     char *path_str;
     
{
  
  int i;
  char *cp;
  char *cp2;
  
  DENTER_EXT((DQS_EVENT,"dqs_dequalify_path"));
  
  if (old_path_str)
    FREE(old_path_str);
  
  if (!path_str) {
    CRITICAL((DQS_EVENT,"DQS_ERROR_0538 NULL path_str in dqs_dequalify_path()"));
    DEXITE;
    abort();
  } /* if */
  
  cp=dqs_malloc(MAX_STRING_SIZE);
  cp2=strrchr(path_str,'/');
  if (!cp2)
    strcpy(cp,path_str);
  else
    strcpy(cp,++cp2);
  
  DEXIT;
  return (cp);
  
}

/************************************************************************/
char *dqs_dequalify_hostname(old_host_str,host_str)
     char *old_host_str;
     char *host_str;
     
{
  
  char *cp=NULL;
  char *cp2=NULL;
  char *cp3=NULL;
  
  DENTER_EXT((DQS_EVENT,"dqs_dequalify_hostname"));
  
  if (old_host_str)
    FREE(old_host_str);
  
  if (!host_str) {
    CRITICAL((DQS_EVENT,"DQS_ERROR_0539 NULL host_str in dqs_dequalify_hostname()"));
    DEXITE;
    abort();
  }
  
  cp=dqs_string_insert(NULL,host_str);
  cp2=strtok(cp,".");
  cp3=dqs_string_insert(NULL,cp2);
  FREE(cp2);
  
  DEXIT;
  return (cp3);
  
}

/************************************************************************/
void dqs_print_group(gid)
     int gid;
     
{
  
  u_long lgid;
  struct group *grpptr;
  
  DENTER_EXT((DQS_EVENT,"dqs_print_group"));
  
  lgid=(u_long)gid;
  
  grpptr=(struct group *)getgrgid(gid);
  
  if (!grpptr) {
    DPRINTF((DQS_EVENT,"%ul (UNKNOWN) group\n",lgid));
    DEXITE;
    return;
  }
  
  DPRINTF((DQS_EVENT,"%u      (%s)",lgid,grpptr->gr_name));
  
  DEXIT;
  return;
  
}     

/************************************************************************/
int dqs_fgetstring(fp,str,size)
     FILE *fp;
     char *str;
     int size;
     
{
  
  int  i=0;
  char c;
  
  DENTER_EXT((DQS_EVENT,"dqs_fgetstring"));
  
  bzero((char *)str,MAX_STRING_SIZE);
  
  for (;;) {
    c=getc(fp);
    
    if (c==0) {
      DEXIT;
      return(i);
    }
    
    
    if ((unsigned char)c==255) {
      DEXIT;
      return(EOF);
    }
    
    if (!isspace(c))
      break;
    
  } /* for */
  
  for (;;) {
    
    if (c==0) {
      DEXIT;
      return(i);
    }
    
    if ((unsigned char)c==255) {
      DEXIT;  
      return(EOF);
    }
    
    if (isspace(c)) {
      DEXIT;
      return(i);
    }
    
    if (i>(size-1)) {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0540 error: string too long >%s< ",str));
      abort();
    }
    
    str[i]=c;
    i++;
    c=getc(fp);
    
  }
  
  
}

/**************************************************************************/
int dqs_strcasecmp(a,b)
     char *a;
     char *b;
     
     /*
       a number of libs don't include a strcasecmp() - hard to believe I know 
     */
     
{
  
  DENTER_EXT((DQS_EVENT,"dqs_strcasecmp"));
  DEXIT;
  return(strcasecmp(a,b));
  
}

/**************************************************************************/
int dqs_strncasecmp(a,b,i)
     char *a;
     char *b;
     int  i;
     
     /*
       a number of libs don't include a strncasecmp() - hard to believe I know 
     */
     
{
  
  DENTER_EXT((DQS_EVENT,"dqs_strncasecmp"));
  DEXIT;
  return(strncasecmp(a,b,i));
  
}

/**************************************************************************/
char *dqs_strtok(str,delimitor)
     char *str;
     char *delimitor;
     
{
  
  char          *cp;
  char          *saved_cp;
  static char   *static_cp;
  static string static_str;
  
  DENTER_EXT((DQS_EVENT,"dqs_strtok"));
  
  if (str)
    {
      bzero((char *)static_str,sizeof(static_str));
      strcpy(static_str,str);
      cp=static_str;
      
      while (1)
	{
	  if (!cp[0])
	    {
	      static_cp=cp;
	      DEXIT;
	      return(static_str);
	    }
	  if (cp[0]==delimitor[0])
	    {
	      cp[0]='\0';
	      cp++;
	      static_cp=cp;
	      DEXIT;
	      return(static_str);
	    }
	  cp++;
	}
    }    
  else
    {
      if (!static_cp[0])
	{
	  DEXIT;
	  return(NULL);
	}
      saved_cp=static_cp;
      cp=static_cp;
      while (1)
	{
	  if (!cp[0])
	    {
	      static_cp=cp;
	      DEXIT;
	      return(saved_cp);
	    }
	  if (cp[0]==delimitor[0])
	    {
	      cp[0]='\0';
	      cp++;
	      static_cp=cp;
	      DEXIT;
	      return(saved_cp);
	    }
	  cp++;
	}
    }
  
}

/************************************************************************/
void dqs_usage()
     
{
  
#define PRINTIT(a) sprintf(tmp_str," %s",a);\
  string_len=strlen(tmp_str);\
			       if (string_len+col>max_col)\
    {\
       fprintf(stderr,"\n%s",indent_str);\
					   col=indention+string_len;\
								      }\
									 else\
									   {\
									      col+=string_len;\
												}\
												   fprintf(stderr,"%s",tmp_str);
  
#define PRINT_OPR(a,b) \
  if (!a)\
    {\
       strcat(opt_descrip,b);\
			       a++;\
				     }
  
  int    col=0;
  int    max_col=78;
  int    indention=0;
  int    string_len;
  
  int account_list=0,complex_list=0,date_time=0,destin_id=0;
  int destin_id_list=0,hold_list=0,interval=0,job_id_list=0,keep_list=0;
  int listname_list=0,mail_address=0,mail_list=0,mail_options=0;
  int op=0,path_list=0,priority=0,resource_list=0,resource=0;
  int resource_name=0,signals=0,states=0,server_list=0,server=0;
  int signal=0,user_list=0,variable_list=0;
  
  string tmp_str,indent_str;
  string account_list_str,complex_list_str,date_time_str,destin_id_str;
  string destin_id_list_str,hold_list_str,interval_str,job_id_list_str,keep_list_str;
  string listname_list_str,mail_address_str,mail_list_str,mail_options_str;
  string op_str,path_list_str,priority_str,resource_list_str;
  string signals_str,states_str,server_list_str,server_str;
  string signal_str,user_list_str,variable_list_str, consumable_list_str;
  
  char   opt_descrip[16384];
  
  DENTER_EXT((DQS_EVENT,"dqs_usage"));
  
  fprintf(stderr,"\n DQS %s\n\n",DQS_VERSION);
  
  sprintf(account_list_str,  "account_list            account_name[@cell][,account_name[@cell],...]\n");
  sprintf(complex_list_str,  "complex_list            complex[,complex,...]\n");
  sprintf(consumable_list_str,"consumable_list         consumable[,consumable,...]\n");     
  sprintf(date_time_str,     "date_time               [[CC]YY]MMDDhhmm[.SS]\n");
  sprintf(destin_id_str,     "destin_id               \"queue\" \"queue@cell\"\n");
  sprintf(destin_id_list_str,"destin_id_list          destin_id[,destin_id,...]\n");
  sprintf(hold_list_str,     "hold_list               `u' `s' `o' `n'\n");
  sprintf(interval_str,      "interval                `n' `s' `m' `u' minutes\n");
  sprintf(job_id_list_str,   "job_id_list             job_id[@cell][,job_id[@cell],...]\n");
  sprintf(keep_list_str,     "keep_list               `e' `o' `n'\n");
  sprintf(listname_list_str, "listname_list           listname[,listname,...]\n");
  sprintf(mail_address_str,  "mail_address            username[@host]\n");
  sprintf(mail_list_str,     "mail_list               mail_address[,mail_address,...]\n");
  sprintf(mail_options_str,  "mail_options            `e' `b' `a' `n' `s'\n");
  sprintf(op_str,            "op                      \".eq.\" \".ge.\" \".gt.\" \".lt.\" \".le.\" \".ne.\"\n");
  sprintf(path_list_str,     "path_list               path[@host][,path[@host],...]\n");
  sprintf(priority_str,      "priority                -1024 - 1023\n");
  sprintf(resource_list_str, "resource_list           resource[.op.resource_field][,resource[.op.resource_field],...]\n");
  sprintf(states_str,        "states                  `e' `q' `r' `t' `h' `w' `m' `s'\n");
  sprintf(server_list_str,   "server_list             server[,server,...]\n");
  sprintf(server_str ,       "server                  hostname\n");
  sprintf(signal_str,        "signal                  -int_val, symbolic names\n");
  sprintf(user_list_str,     "user_list               user[@host][,user[@host],...]\n");
  sprintf(variable_list_str, "variable_list           variable[=value][,variable[=value],...]\n");
  
  
  bzero((char *)opt_descrip,sizeof(opt_descrip));
  
  fprintf(stderr,"\nusage:\n");
  
  sprintf(tmp_str,"%s ",me.unqualified_prog_name);
  fprintf(stderr,tmp_str);
  col=strlen(tmp_str);
  bzero((char *)indent_str,sizeof(indent_str));
  for (indention=0;indention<col;indention++)
    strcat(indent_str," ");
  
  if (VALID_OPT(a_OPT,me.who))
    {
      if (me.who==QSELECT)
	{
	  PRINTIT("[-a [op] date_time]");
	}
      else
	{
	  PRINTIT("[-a date_time]");
	}
      PRINT_OPR(date_time,date_time_str);
    }
  
  if (VALID_OPT(ac_OPT,me.who))
    {
      PRINTIT("[-ac complex_name]");
    }
  
  if (VALID_OPT(acons_OPT,me.who))
    {
      PRINTIT("[-acons consumable_name]");
    }
  
  if (VALID_OPT(ah_OPT,me.who))
    {
      
      PRINTIT("[-ah server_list]");
      PRINT_OPR(server_list,server_list_str);
    }
  
  if (VALID_OPT(am_OPT,me.who))
    {
      PRINTIT("[-am user_list]");
      PRINT_OPR(user_list,user_list_str);
    }
  
  if (VALID_OPT(ao_OPT,me.who))
    {
      PRINTIT("[-ao user_list]");
      PRINT_OPR(user_list,user_list_str);
    }
  
  if (VALID_OPT(aq_OPT,me.who)) 
    {
      PRINTIT("[-aq [q_template]]");
    }
  
  if (VALID_OPT(au_OPT,me.who))
    {
      PRINTIT("[-au user_list listname_list]");
      PRINT_OPR(user_list,user_list_str);
      PRINT_OPR(listname_list,listname_list_str);
    }
  
  if (VALID_OPT(A_OPT,me.who)) 
    {
      PRINTIT("[-A account_list]");
      PRINT_OPR(account_list,account_list_str);
    }
  
  if (VALID_OPT(Aq_OPT,me.who))
    {
      PRINTIT("[-Aq fname]");
    }
  
  if (VALID_OPT(B_OPT,me.who)) 
    {
      PRINTIT("[-B]");
    }
  
  if (VALID_OPT(c_OPT,me.who)) 
    {
      if (me.who==QSELECT) 
	{
	  PRINTIT("[-c [op] interval]");
	  PRINT_OPR(op,op_str);
	}
      else 
	{
	  PRINTIT("[-c interval]");
	}
      PRINT_OPR(interval,interval_str);
    }
  
  if (VALID_OPT(cell_OPT,me.who)) 
    {
      PRINTIT("[-cell cell_name]");
    }
  
  if (VALID_OPT(clean_OPT,me.who))
    {
      PRINTIT("[-clean]");
    }
  
  
  if (VALID_OPT(cwd_OPT,me.who))
    {
      PRINTIT("[-cwd]");
    }
  
  if (VALID_OPT(cq_OPT,me.who))
    {
      PRINTIT("[-cq destin_id_list]");
      PRINT_OPR(destin_id_list,destin_id_list_str);
    }
  
  if (VALID_OPT(C_OPT,me.who))
    {
      PRINTIT("[-C]");
    }
  
  if (VALID_OPT(d_OPT,me.who))
    {
      PRINTIT("[-d]");
    }
  
  if (VALID_OPT(dc_OPT,me.who))
    {
      PRINTIT("[-dc destin_id_list ]");
      PRINT_OPR(server_list,server_list_str);
    }
  
  if (VALID_OPT(dcons_OPT,me.who))
    {
      PRINTIT("[-dcons consumable_list]");
      PRINT_OPR(server_list,server_list_str);
    }
  
  if (VALID_OPT(dh_OPT,me.who))
    {
      PRINTIT("[-dh server_list]");
      PRINT_OPR(server_list,server_list_str);
    }
  
  if (VALID_OPT(dm_OPT,me.who))
    {
      PRINTIT("[-dm user_list]");
      PRINT_OPR(user_list,user_list_str);
    }
  
  if (VALID_OPT(do_OPT,me.who))
    {
      PRINTIT("[-do user_list]");
      PRINT_OPR(user_list,user_list_str);
    }
  
  if (VALID_OPT(dq_OPT,me.who))
    {
      PRINTIT("[-dq destin_id_list]");
      PRINT_OPR(destin_id_list,destin_id_list_str);
      PRINT_OPR(destin_id,destin_id_str);
    }
  
  if (VALID_OPT(du_OPT,me.who))
    {
      PRINTIT("[-du user_list listname_list]");
      PRINT_OPR(user_list,user_list_str);
      PRINT_OPR(listname_list,listname_list_str);
    }
  
  if (VALID_OPT(e_OPT,me.who)) 
    {
      if (me.who==QMOD)
	{
	  PRINTIT("[-e]");
	}
      else
	{
	  PRINTIT("[-e path_list]");
	  PRINT_OPR(path_list,path_list_str);
	}
    }
  
  if (VALID_OPT(ext_OPT,me.who)) {
    PRINTIT("[-ext]");
  }
  
  if (VALID_OPT(E_OPT,me.who)) 
    {
      PRINTIT("[-E]");
    }
  
  if (VALID_OPT(f_OPT,me.who)) 
    {
      PRINTIT("[-f]");
    }
  
  if (VALID_OPT(F_OPT,me.who)) 
    {
      PRINTIT("[-F]");
    }
  
  if (VALID_OPT(h_OPT,me.who)) 
    {
      if ((me.who==QALTER)||(me.who==QHOLD)||(me.who==QRLS))
	{
	  PRINTIT("[-h hold_list]");
	  PRINT_OPR(hold_list,hold_list_str);
	}
      else 
	{
	  PRINTIT("[-h]");
	}
    }
  
  if (VALID_OPT(hard_OPT,me.who)) 
    {
      PRINTIT("[-hard]");
    }
  
  if (VALID_OPT(help_OPT,me.who))
    {
      
      PRINTIT("[-help]");
      
    }
  
  if (VALID_OPT(hold_jid_OPT,me.who))
    {
      PRINTIT("[-hold_jid jid[,jid,...]]");
    }
  
  if (VALID_OPT(j_OPT,me.who)) 
    {
      PRINTIT("[-j]");
    }
  
  if (VALID_OPT(jid_OPT,me.who))
    {
      if (me.who==QSTAT)
	{
          PRINTIT("[-jid jid_list]");
          PRINT_OPR(job_id_list,job_id_list_str);
	}
      else
	{
          PRINTIT("[-jid jid]");
	}
    }
  
  if (VALID_OPT(k_OPT,me.who)) 
    {
      PRINTIT("[-k keep_list]");
      PRINT_OPR(keep_list,keep_list_str);
    }
  
  if (VALID_OPT(kq_OPT,me.who))
    {
      PRINTIT("[-kq server_list]");
    }
  
  if (VALID_OPT(kqs_OPT,me.who))
    {
      PRINTIT("[-kqs]");
    }
  
  if (VALID_OPT(l_OPT,me.who)) 
    {
      PRINTIT("[-l resource_list]");
      PRINT_OPR(resource_list,resource_list_str);
    }
  
  if (VALID_OPT(m_OPT,me.who)) 
    {
      PRINTIT("[-m mail_options]");
      PRINT_OPR(mail_options,mail_options_str);
    }
  
  if (VALID_OPT(master_OPT,me.who)) 
    {
      PRINTIT("[-master destin_id_list]");
      PRINT_OPR(destin_id_list,destin_id_list_str);
      PRINT_OPR(destin_id,destin_id_str);
    }
  
  if (VALID_OPT(mc_OPT,me.who))
    {
      PRINTIT("[-mc [complex]]");
    }
  
  if (VALID_OPT(mconf_OPT,me.who))
    {
      PRINTIT("[-mconf]");
    }
  
  if (VALID_OPT(mcons_OPT,me.who))
    {
      PRINTIT("[-mcons consumable_id]");
    }
  
  
  if (VALID_OPT(mq_OPT,me.who))
    {
      PRINTIT("[-mq [destin_id]]");
      PRINT_OPR(destin_id,destin_id_str);
    }
  
  if (VALID_OPT(notify_OPT,me.who))
    {
      PRINTIT("[-notify]");
    }
  
  if (VALID_OPT(M_OPT,me.who)) 
    {
      PRINTIT("[-M mail_list]");
      PRINT_OPR(mail_list,mail_list_str);
      PRINT_OPR(mail_address,mail_address_str);
    }
  
  if (VALID_OPT(N_OPT,me.who)) 
    {
      PRINTIT("[-N name]");
    }
  
  if (VALID_OPT(o_OPT,me.who)) 
    {
      PRINTIT("[-o path_list]");
      PRINT_OPR(path_list,path_list_str);
    }
  
  if (VALID_OPT(O_OPT,me.who)) 
    {
      PRINTIT("[-O]");
    }
  
  if (VALID_OPT(p_OPT,me.who)) 
    {
      if (me.who==QSELECT) 
	{
	  PRINTIT("[-p [op] priority]");
	}
      else 
	{
	  PRINTIT("[-p priority]");
	}
      PRINT_OPR(priority,priority_str);
    }
  
  if (VALID_OPT(par_OPT,me.who))
    {
      PRINTIT("[-par p4 || mpi || generic_sla || generic_all]");
    }
  
  if (AFS)
    {
      if (VALID_OPT(passwd_OPT,me.who))
	{
	  PRINTIT("[-passwd]");
	}
    }
  
  if (AFS)
    {
      if (VALID_OPT(Passwd_OPT,me.who))
	{
	  PRINTIT("[-Passwd fname]");
	}
    }
  
  if (VALID_OPT(q_OPT,me.who)) 
    {
      PRINTIT("[-q destin_id_list]");
      PRINT_OPR(destin_id_list,destin_id_list_str);
      PRINT_OPR(destin_id,destin_id_str);
    }
  
  if (VALID_OPT(qmon_OPT,me.who))
    {
      PRINTIT("[-qmon]");
    }
  
  if (VALID_OPT(Q_OPT,me.who)) 
    {
      PRINTIT("[-Q]");
    }
  
  if (VALID_OPT(r_OPT,me.who)) 
    {
      PRINTIT("[-r y|n]");
    }
  
  if (VALID_OPT(rc_OPT,me.who))
    {
      PRINTIT("[-rc consumable amount]");
    }
  
  if (VALID_OPT(reauth_OPT,me.who))
    {
      PRINTIT("[-reauth #seconds]");
    }
  
  if (VALID_OPT(refr_OPT,me.who))
    {
      PRINTIT("[-refr]");
    }
  
  if (VALID_OPT(s_OPT,me.who)) 
    {
      if (me.who==QSELECT)
	{
	  PRINTIT("[-s states]");
	  PRINT_OPR(states,states_str);
	}
      else if (me.who==QMOD)
	{
	  PRINTIT("[-s]");
	}
      else
	{
	  PRINTIT("[-s signal]");
	  PRINT_OPR(signals,signals_str);
	}
    }
  
  if (VALID_OPT(sc_OPT,me.who)) 
    {
      PRINTIT("[-sc [complex_list]]");
      PRINT_OPR(complex_list,complex_list_str);
    }
  
  if (VALID_OPT(scl_OPT,me.who))
    {
      PRINTIT("[-scl]");
    }
  
  if (VALID_OPT(scons_OPT,me.who)) 
    {
      PRINTIT("[-scons consumable_id]");
    }
  
  if (VALID_OPT(sconsl_OPT,me.who)) 
    {
      PRINTIT("[-sconsl ]");
    }
  
  if (VALID_OPT(sh_OPT,me.who))
    {
      PRINTIT("[-sh]");
    }
  
  if (VALID_OPT(shutd_OPT,me.who))
    {
      PRINTIT("[-shutd destin_id]");
    }
  
  if (VALID_OPT(sm_OPT,me.who))
    {
      PRINTIT("[-sm]");
    }
  
  if (VALID_OPT(so_OPT,me.who))
    {
      PRINTIT("[-so]");
    }
  
  if (VALID_OPT(soc_OPT,me.who))
    {
      PRINTIT("[-soc]");
    }
  
  if (VALID_OPT(soft_OPT,me.who)) 
    {
      PRINTIT("[-soft]");
    }
  
  if (VALID_OPT(sq_OPT,me.who))
    {
      PRINTIT("[-sq [destin_id_list]]");
      PRINT_OPR(destin_id_list,destin_id_list_str);
      PRINT_OPR(destin_id,destin_id_str);
    }
  
  if (VALID_OPT(sql_OPT,me.who))
    {
      PRINTIT("[-sql]");
    }
  
  if (VALID_OPT(su_OPT,me.who))
    {
      PRINTIT("[-su [listname_list]]");
      PRINT_OPR(listname_list,listname_list_str);
    }
  
  if (VALID_OPT(sul_OPT,me.who))
    {
      PRINTIT("[-sul]");
    }
  
  if (VALID_OPT(srl_OPT,me.who))
    {
      PRINTIT("[-srl]");
    }
  
  
  if (VALID_OPT(S_OPT,me.who))
    {
      PRINTIT("[-S path_list]");
      PRINT_OPR(path_list,path_list_str);
    }
  
  if (VALID_OPT(u_OPT,me.who)) 
    {
      PRINTIT("[-u user_list]");
      PRINT_OPR(user_list,user_list_str);
    }
  
  if (VALID_OPT(ul_OPT,me.who))
    {
      PRINTIT("[-ul]");
    }
  
  if (VALID_OPT(us_OPT,me.who))
    {
      PRINTIT("[-us]");
    }
  
  if (VALID_OPT(v_OPT,me.who)) 
    {
      PRINTIT("[-v variable_list]");
      PRINT_OPR(variable_list,variable_list_str);
    }
  
  if (VALID_OPT(verify_OPT,me.who)) 
    {
      PRINTIT("[-verify]");
    }
  
  if (VALID_OPT(V_OPT,me.who)) 
    {
      PRINTIT("[-V]");
    }
  
  if (VALID_OPT(xsoc_OPT,me.who))
    {
      PRINTIT("[-xsoc]");
    }
  
  if (VALID_OPT(z_OPT,me.who)) 
    {
      PRINTIT("[-z]");
    }
  
  if (VALID_OPT(DESTIN_OPR,me.who)) 
    {
      PRINTIT("destin_id_list");
      PRINT_OPR(destin_id,destin_id_str);
    }
  
  if (VALID_OPT(MESSAGE_OPR,me.who))
    {
      PRINTIT("message");
    }
  
  if (VALID_OPT(JOB_ID_OPR,me.who)) 
    {
      PRINTIT("job_id_list");
      PRINT_OPR(job_id_list,job_id_list_str);
    }
  
  if (VALID_OPT(SCRIPT_OPR,me.who)) 
    {
      PRINTIT("[script]");
    }
  
  if (VALID_OPT(SRVR_NM_OPR,me.who)) 
    {
      PRINTIT("server_name");
    }
  
  fprintf(stderr,"\n\n");
  fflush(stderr);
  
  fprintf(stderr,"%s",opt_descrip);
  
  
  DEXIT;
  /*     exit(DQS_EINVAL);???*/
  
}

/************************************************************************/
void dqs_show_hold_list(hold,how)
     int how;
     int hold;
     
{
  
  int    i=0;
  string str;
  
  DENTER_EXT((DQS_EVENT,"dqs_show_hold_list"));
  if (VALID(DQS_STDOUT,how)) {
    if (VALID(USER,hold)) {
      printf("%c",USER_SYM);
      i++;
    }
    if (VALID(SYSTEM,hold)) {
      printf("%c",SYSTEM_SYM);
      i++;
    }
    if (VALID(OTHER,hold)) {
      printf("%c",OTHER_SYM);
      i++;
    }
    if (VALID(NO_HOLD,hold)) {
      printf("%c",NO_HOLD_SYM);
      i++;
    }
    while (i<4) {
      printf(" ");
      i++;
    }
    fflush(stdout);
  }
  
  if (VALID(DQS_STDERR,how)) {
    if (VALID(USER,hold)) {
      fprintf(stderr,"%c",USER_SYM);
      i++;
    }
    if (VALID(SYSTEM,hold)) {
      fprintf(stderr,"%c",SYSTEM_SYM);
      i++;
    }
    if (VALID(OTHER,hold)) {
      fprintf(stderr,"%c",OTHER_SYM);
      i++;
    }
    if (VALID(NO_HOLD,hold)) {
      fprintf(stderr,"%c",NO_HOLD_SYM);
      i++;
    }
    while (i<4) {
      fprintf(stderr," ");
      i++;
    }
    fflush(stderr);
  }
  
  i=0;
  if (VALID(DQS_DEBUG,how)) {
    if (VALID(USER,hold)) {
      str[i]=USER_SYM;
      i++;
    }
    if (VALID(SYSTEM,hold)) {
      str[i]=SYSTEM_SYM;
      i++;
    }
    if (VALID(OTHER,hold)) {
      str[i]=OTHER_SYM;
      i++;
    }
    if (VALID(NO_HOLD,hold)) {
      str[i]=NO_HOLD_SYM;
      i++;
    }
    while (i<4) {
      str[i]=' ';
      i++;
    }
    DPRINTF((DQS_EVENT,str));
  }
  
  DEXIT;
  return;
  
}

/**************************************************************************/
int dqs_unmap_signal(dqs_sig)
     int dqs_sig;
     
{
  
  int sig;
  
  DENTER_EXT((DQS_EVENT,"dqs_unmap_signal"));;
  
  if (dqs_sig==DQS_SIGHUP) 
    sig=SIGHUP;
  else if (dqs_sig==DQS_SIGINT)
    sig=SIGINT;
  else if (dqs_sig==DQS_SIGQUIT)
    sig=SIGQUIT;
  else if (dqs_sig==DQS_SIGILL)
    sig=SIGILL;
  else if (dqs_sig==DQS_SIGTRAP)
    sig=SIGTRAP;
  else if (dqs_sig==DQS_SIGABRT)
    sig=SIGABRT;
  else if (dqs_sig==DQS_SIGFPE)
    sig=SIGFPE;
  else if (dqs_sig==DQS_SIGKILL)
    sig=SIGKILL;
  else if (dqs_sig==DQS_SIGSEGV)
    sig=SIGSEGV;
  else if (dqs_sig==DQS_SIGPIPE)
    sig=SIGPIPE;
  else if (dqs_sig==DQS_SIGALRM)
    sig=SIGALRM;
  else if (dqs_sig==DQS_SIGTERM)
    sig=SIGTERM;
  else if (dqs_sig==DQS_SIGURG)
    sig=SIGURG;
  else if (dqs_sig==DQS_SIGSTOP)
    sig=SIGSTOP;
  else if (dqs_sig==DQS_SIGTSTP)
    sig=SIGTSTP;
  else if (dqs_sig==DQS_SIGCONT)
    sig=SIGCONT;
  else if (dqs_sig==DQS_SIGCHLD)
    sig=SIGCHLD;
  else if (dqs_sig==DQS_SIGTTIN)
    sig=SIGTTIN;
  else if (dqs_sig==DQS_SIGTTOU)
    sig=SIGTTOU;
  else if (dqs_sig==DQS_SIGIO)
    sig=SIGIO;
  else if (dqs_sig==DQS_SIGVTALRM)
    sig=SIGVTALRM;
  else if (dqs_sig==DQS_SIGPROF)
    sig=SIGPROF;
  else if (dqs_sig==DQS_SIGWINCH)
    sig=SIGWINCH;
  else if (dqs_sig==DQS_SIGUSR1)
    sig=SIGUSR1;
  else if (dqs_sig==DQS_SIGUSR2)
    sig=SIGUSR2;
  else
    sig=(-1);
  
  DEXIT;
  return(sig);
  
}
/**************************************************************************/
int dqs_is_str(str)
     char *str;
     
{
  DENTER_EXT((DQS_EVENT,"dqs_is_str"));;
  
  DQS_ASSERT((str));
  
  while (str[0])
    {
      printf("%c",str[0]);
      if (isdigit(str[0]))
	{
	  printf("\n");
	  DEXITE;
	  return(-1);
	}
      str++;
    }
  printf("\n");
  
  DEXIT;
  return(0);
  
}

/**************************************************************************/
int dqs_is_int(str)
     char *str;
     
{
  
  DENTER_EXT((DQS_EVENT,"dqs_is_int"));;
  
  DQS_ASSERT((str));
  
  while (str[0])
    {
      if (isalpha(str[0]))
	{
	  DEXITE;
	  return(-1);
	}
      str++;
    }
  
  DEXIT;
  return(0);
  
}
/**************************************************************************/
int dqs_atoi(int_str)
     char *int_str;
     
{
  
  int i,j;
  char *cp;
  
  DENTER_EXT((DQS_EVENT,"dqs_atoi"));;
  
  if (!int_str)
    {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0541 unable to convert string \"%s\" to integer",int_str));
      dqs_usage();
      DEXITE;
      return -1;
    }
  
  i=atol(int_str);
  
  DEXIT;
  return(i);
  
}

/**************************************************************************/
char *dqs_malloc(size)
     int size;
     
{
  
  char *cp=NULL;
  
  DENTER_EXT((DQS_EVENT,"dqs_malloc"));
  
  if (!size)
    {
      DEXIT;
      return(NULL);
    }
  
  cp=(char *)malloc(size);
  if (!cp) 
    {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0542 malloc() failure"));
      DEXITE;
      abort();
    }
  
  bzero((char *)cp,size);
  
  DEXIT;
  return(cp);
}

/**************************************************************************/
char *dqs_realloc(ptr,size)
     char *ptr;
     int  size;
     
{
  
  char *cp=NULL;
  
  DENTER_EXT((DQS_EVENT,"dqs_realloc"));
  
  if (!size)
    {
      if (ptr)
	{
          FREE(ptr);
	}
      DEXIT;
      return(NULL);
    }
  
  cp=(char *)realloc(ptr,size);
  
  if (!cp)
    {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0543 realloc() failure"));
      DEXITE;
      abort();
    }
  
  DEXIT;
  return(cp);
  
}

/************************************************************************/
char *dqs_free(cp)
     char *cp;
     
{
  DENTER_EXT((DQS_EVENT,"dqs_free"));
  
  FREE(cp);
  
  DEXIT;
  return(NULL);
  
}

/************************************************************************/
void dqs_show_op(how,op)
     int how;
     int op;
     
{
  
  string tmp_str;
  
  DENTER_EXT((DQS_EVENT,"dqs_show_op"));
  
  if (op==EQ_OP)
    sprintf(tmp_str,".eq.");
  else if (op==GE_OP)
    sprintf(tmp_str,".ge.");
  else if (op==GT_OP)
    sprintf(tmp_str,".gt.");
  else if (op==LT_OP)
    sprintf(tmp_str,".lt.");
  else if (op==LE_OP)
    sprintf(tmp_str,".le.");
  else if (op==NE_OP)
    sprintf(tmp_str,".ne.");
  else if (op==STREQ_OP)
    sprintf(tmp_str,".eq.");
  else
    sprintf(tmp_str,".unknown.");     
  
  if (VALID(how,DQS_STDOUT))
    printf("%s",tmp_str);
  if (VALID(how,DQS_STDERR))
    fprintf(stderr,"%s",tmp_str);
  
  DEXIT;
  return;
}

/************************************************************************/
void dqs_show_checkpoint(how,op)
     int how;
     int op;
     
{
  
  int i=0;
  int count=0;
  string tmp_str;
  
  DENTER_EXT((DQS_EVENT,"dqs_show_checkpoint"));
  
  bzero((char *)tmp_str,sizeof(tmp_str));
  
  if (VALID(CHECKPOINT_AT_MINIMUM_INTERVAL,op)) 
    {
      tmp_str[count]=CHECKPOINT_AT_MINIMUM_INTERVAL_SYM;
      count++;
    }
  
  if (VALID(CHECKPOINT_AT_SHUTDOWN,op))
    {
      tmp_str[count]=CHECKPOINT_AT_SHUTDOWN_SYM;
      count++;
    }
  
  if (VALID(CHECKPOINT_AT_UNSPECIFIED,op))
    {
      tmp_str[count]=CHECKPOINT_AT_UNSPECIFIED_SYM;
      count++;
    }
  
  if (VALID(NO_CHECKPOINT,op))
    {
      tmp_str[count]=NO_CHECKPOINT_SYM;
      count++;
    }
  
  if (VALID(DQS_STDOUT,how))
    {
      printf("%s",tmp_str);
      for (i=count;i<4;i++)
	printf(" ");
    }
  
  if (VALID(DQS_STDERR,how))
    {
      fprintf(stderr,"%s",tmp_str);
      for (i=count;i<4;i++)
	fprintf(stderr," ");
    }
  
  DEXIT;
  
  return;
  
}


/************************************************************************/
void dqs_show_y_n(op,how)
     int op;
     int how;
     
{
  
  int i=0;
  int count=0;
  string tmp_str;
  
  DENTER_EXT((DQS_EVENT,"dqs_show_y_n"));
  
  if (op)
    sprintf(tmp_str,"y");
  else
    sprintf(tmp_str,"n");
  
  
  if (VALID(how,DQS_STDOUT))
    printf("%s",tmp_str);
  
  if (VALID(how,DQS_STDERR))
    fprintf(stderr,"%s",tmp_str);
  
  
  DEXIT;
  
  return;
  
}

/************************************************************************/
void dqs_show_keep_list(op,how)
     int op;
     int how;
     
{
  
  int i=0;
  int count=0;     
  string tmp_str;
  
  DENTER_EXT((DQS_EVENT,"dqs_show_keep_list"));
  
  if (VALID(KEEP_NONE,op)) 
    {
      tmp_str[count]=KEEP_NONE_SYM;
      count++;
    }
  
  if (VALID(KEEP_STD_ERROR,op))
    {
      tmp_str[count]=KEEP_STD_ERROR_SYM;
      count++;
    }
  
  if (VALID(KEEP_STD_OUTPUT,op))
    {
      tmp_str[count]=KEEP_STD_OUTPUT_SYM;
      count++;
    }
  
  if (VALID(DQS_STDOUT,how)) 
    {
      printf("%s",tmp_str);
      for (i=count;i<2;i++)
	printf(" ");
    }
  
  if (VALID(DQS_STDERR,how)) 
    {
      fprintf(stderr,"%s",tmp_str);
      for (i=count;i<2;i++)
	fprintf(stderr," ");
    }
  
  DEXIT;
  
  return;
  
}

/************************************************************************/
void dqs_show_mail_options(op,how)
     int op;
     int how;
     
{
  
  int i=0;
  int count=0;
  string tmp_str;
  
  DENTER_EXT((DQS_EVENT,"dqs_show_mail_list"));
  
  if (VALID(MAIL_AT_ABORT,op))
    {
      tmp_str[count]=MAIL_AT_ABORT_SYM;
      count++;
    }
  
  if (VALID(MAIL_AT_BEGINNING,op))
    {
      tmp_str[count]=MAIL_AT_BEGINNING_SYM;
      count++;
    }
  
  if (VALID(MAIL_AT_EXIT,op))
    {
      tmp_str[count]=MAIL_AT_EXIT_SYM;
      count++;
    }
  
  if (VALID(NO_MAIL,op))
    {
      tmp_str[count]=NO_MAIL_SYM;
      count++;
    }
  
  if (VALID(MAIL_AT_SUSPENSION,op))
    {
      tmp_str[count]=MAIL_AT_SUSPENSION_SYM;
      count++;
    }
  
  tmp_str[count]= '\0';  /* ensure string terminator */
  
  if (VALID(DQS_STDOUT,how))
    {
      printf("%s",tmp_str);
      for (i=count;i<4;i++)
	printf(" ");
      
    }
  
  if (VALID(DQS_STDERR,how))
    {
      fprintf(stderr,"%s",tmp_str);
      for (i=count;i<4;i++)
	fprintf(stderr," ");
      
    }
  
  DEXIT;
  
  return;
  
}

/************************************************************************/
void dqs_get_states(str,op)
     char     *str;
     u_long32 op;
     
{
  int count;
  
  DENTER_EXT((DQS_EVENT,"dqs_get_states"));
  
  count=strlen(str);
  
  if (VALID(ALARM,op))
    {
      str[count++]=ALARM_SYM;
    }
  
  if (VALID(SUSPEND_ON_COMP,op))
    {
      str[count++]=SUSPEND_ON_COMP_SYM;
    }
  
  if (VALID(DISABLED,op))
    {
      str[count++]=DISABLED_SYM;
    }
  
  if (VALID(ENABLED,op))
    {
      str[count++]=ENABLED_SYM;
    }
  if (VALID(HELD,op))
    {
      str[count++]=HELD_SYM;
    }
  
  if (VALID(MIGRATING,op))
    {
      str[count++]=MIGRATING_SYM;
    }
  
  if (VALID(NO_HOLD,op))
    {
      str[count++]=NO_HOLD_SYM;
    }
  
  if (VALID(QUEUED,op))
    {
      str[count++]=QUEUED_SYM;
    }
  
  if (VALID(RUNNING,op))
    {
      str[count++]=RUNNING_SYM;
    }
  
  if (VALID(SUSPENDED,op))
    {
      str[count++]=SUSPENDED_SYM;
    }
  
  if (VALID(TRANSISTING,op))
    {
      str[count++]=TRANSISTING_SYM;
    }
  
  if (VALID(UNKNOWN,op))
    {
      str[count++]=UNKNOWN_SYM;
    }
  
  if (VALID(WAITING,op))
    {
      str[count++]=WAITING_SYM;
    }
  
  if (VALID(EXITING,op))
    {
      str[count++]=EXITING_SYM;
    }
  
  if (VALID(HANDOFF_ERROR,op))
    {
      str[count++]=HANDOFF_ERROR_SYM;
    }
  if (VALID(SUBORDINATED,op))
    {
      str[count++]=SUBORDINATED_SYM;
    }
  
  DEXIT;
  
  return;
  
}

/************************************************************************/
void dqs_show_states(how,states)
     u_long32 how;
     u_long32 states;
     
{
  
  int i=0;
  int count=0;
  string tmp_str;
  
  DENTER_EXT((DQS_EVENT,"dqs_show_states"));
  
  bzero((char *)tmp_str,sizeof(tmp_str));
  
  dqs_get_states(tmp_str,states);
  
  while (strlen(tmp_str)<7)
    strcat(tmp_str," ");
  
  if (VALID(DQS_STDOUT,how))
    {
      printf("%s ",tmp_str);
    }
  
  if (VALID(DQS_STDERR,how))
    {
      fprintf(stderr,"%s ",tmp_str);
    }
  
  /* decode one flags into a more readable name */
  /* print only a single status name according to realtive importance */
  
  if ( (strstr(tmp_str,"u")) || (strstr(tmp_str,"H")) ){
    printf("%-10s","UNKNOWN");
    DEXIT;
    return;
  }
  
  if (strstr(tmp_str,"a")){
    printf("%-10s","ALARM");
    DEXIT;
    return;
  }

  if (strstr(tmp_str,"d")){
    printf("%-10s","DISABLED");
    DEXIT;
    return;
  }
  
  if (strstr(tmp_str,"S")){
    printf("%-10s","SUBRDINTD");
    DEXIT;
    return;
  }
  
  if (strstr(tmp_str,"s")){
    printf("%-10s","SUSPENDED");
    DEXIT;
    return;
  }
  if (strstr(tmp_str,"c")){
    printf("%-10s","SUSP_COMP");
    DEXIT;
    return;
  }
  
  if (strstr(tmp_str,"e")){
    printf("%-10s","UP");
    DEXIT;
    return;
  }
  
  if (strstr(tmp_str,"r")) {  
    printf ("%-10s","RUNNING");
    DEXIT;
    return;
  }
  
  if (strstr(tmp_str,"q"))   printf("%-10s","QUEUED");
  
  DEXIT;
  
  return;
  
}

/************************************************************************/
int dqs_show_queue_states(state)
     int state;
{
  
  DENTER_EXT((DQS_EVENT,"dqs_show_queue_states"));
  
  if (state==IDLE)
    printf("idle      ");
  if (state==RUNNING)
    printf("running   ");
  else if (state==SUSPENDED)
    printf("suspended ");
  else if (state==SUSPEND_ON_COMP)
    printf("soc       ");
  else
    printf("unknown   ");
  
  DEXIT;
  return;
  
}
/************************************************************************/
u_long32 dqs_get_gmt()
     
{
  
  u_long new_time;
  struct timeval  now;
  struct timezone tzp;
  
  DENTER_EXT((DQS_EVENT,"gettime"));
  
  gettimeofday(&now, &tzp);
  new_time=(u_long)now.tv_sec;
  
  DEXIT;
  return(new_time);
  
}

/************************************************************************/
unsigned int dqs_rand(min,max)
     int min;
     int max;
     
{
  
  static int first_pass=1;
  unsigned int i,j;
  struct timeval  now;
  struct timezone tzp;
  
  DENTER_EXT((DQS_EVENT,"dqs_rand"));
  
  if (first_pass)
    {
      gettimeofday(&now, &tzp);
      srand((u_long)now.tv_usec);
      first_pass=0;
    }
  
  i=rand();
  i=i%max;
  
  if (i<min)
    {
      j=rand();
      j=j%min;
      i=min+j;
    }
  
  DEXIT;
  return(i);
  
}

/************************************************************************/
u_long32 dqs_get_job_number()
     
{
  
  u_long32    i;
  int         fd;
  struct stat buf;
  
  DENTER((DQS_EVENT,"dqs_get_job_number"));
  
  if (stat(SEQ_NUM_FILE,&buf)) {
    INFO((DQS_EVENT,"DQS_ERROR_0544 file %s not found -- making",SEQ_NUM_FILE));
    fd=creat(SEQ_NUM_FILE,0755);
    i=1;
    write(fd,&i,sizeof(i));
    close(fd);
    DEXIT;
    return(1);
  }
  
  fd=open(SEQ_NUM_FILE,O_RDWR,0755);
  if (fd < 0) {
    CRITICAL((DQS_EVENT,"DQS_ERROR_0545 error: opening %s\n",SEQ_NUM_FILE));
    abort();
  }
  
  if (dqs_readnbytes(fd,(char *)&i,sizeof(i))!=sizeof(i))
    {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0546 error: reading  %s\n",SEQ_NUM_FILE));
      abort();
    }
  
  i++;
  
  if (i>MAX_SEQNUM) {
    DPRINTF((DQS_EVENT, "MAX_SEQNUM %d exceeded, starting over",MAX_SEQNUM));
    i=1;
  }
  
  lseek(fd,0,0);
  write(fd,&i,sizeof(i));
  close(fd);
  
  DPRINTF((DQS_EVENT,"returning %d",i));
  
  DEXIT;
  return(i);
  
}     

/************************************************************************/
char *dqs_get_path(lp,job_name,job_number,type)
     dqs_list_type *lp;
     char          *job_name;
     u_long32      job_number;
     int           type;
     
{
  
  char          *cp;
  dqs_list_type *listel_ptr;
  
  DENTER((DQS_EVENT,"dqs_get_path"));
  
  cp=dqs_malloc(MAX_STRING_SIZE);
  
  listel_ptr=lp;
  while (listel_ptr)
    {
      if (listel_ptr->str1)
	{
	  if (!dqs_strcasecmp(listel_ptr->str1,me.qualified_hostname))
	    {
	      if (type==DQS_PAR_STDOUT)
		sprintf(cp,"%s/%s.po%d.%d",listel_ptr->str0,job_name,job_number,me.pid);
	      else if (type==DQS_PAR_STDERR)
		sprintf(cp,"%s/%s.pe%d.%d",listel_ptr->str0,job_name,job_number,me.pid);
	      else if (type==DQS_STDOUT)
		sprintf(cp,"%s/%s.o%d.%d",listel_ptr->str0,job_name,job_number,me.pid);
	      else if (type==DQS_STDERR)
		sprintf(cp,"%s/%s.e%d.%d",listel_ptr->str0,job_name,job_number,me.pid);
	      else if (type==DQS_HOSTS)
		sprintf(cp,"%s/%s.hosts%d.%d",listel_ptr->str0,job_name,job_number,me.pid);
	      else if (type==DQS_SHELL)
		sprintf(cp,"%s",listel_ptr->str1);
	      else if (type==DQS_ACCOUNT)
		sprintf(cp,"%s",listel_ptr->str1);
	      DEXIT;
	      return(cp);
	    }
	}
      listel_ptr=listel_ptr->next;
    }
  
  /* hostname: wasn't set, look for a default */
  listel_ptr=lp;
  while (listel_ptr)
    {
      if (!listel_ptr->str1)
	{
	  DEXIT;
	  return(listel_ptr->str0);
	}
      listel_ptr=listel_ptr->next;
    }
  
  /* nothing specified - return "job_name" */
  if (type==DQS_PAR_STDOUT)
    sprintf(cp,"%s.po%d.%d",job_name,job_number,me.pid);
  else if (type==DQS_PAR_STDERR)
    sprintf(cp,"%s.pe%d.%d",job_name,job_number,me.pid);
  else if (type==DQS_STDOUT)
    sprintf(cp,"%s.o%d.%d",job_name,job_number,me.pid);
  else if (type==DQS_STDERR)
    sprintf(cp,"%s.e%d.%d",job_name,job_number,me.pid);
  else if (type==DQS_HOSTS)
    sprintf(cp,"%s.hosts%d.%d",job_name,job_number,me.pid);
  else if (type==DQS_SHELL)
    cp=NULL;
  else if (type==DQS_ACCOUNT)
    sprintf(cp,"%s",conf.default_account);
  
  DEXIT;
  return(cp);
  
}

/*****************************************************************/
void dqs_mark_unheard(host)
     char *host;
     
{
  
  dqs_hash_type *hashel_ptr;
  
  DENTER_EXT((DQS_EVENT,"dqs_mark_unheard"));
  
  hashel_ptr=dqs_locate_host(host);
  if (!hashel_ptr)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0547 cannot locate host >%s<",host));
    }
  else
    {
      *hashel_ptr->lt_heard_from_ptr=0;
    }
  
  DEXIT;
  return;
  
}

/*****************************************************************/
void dqs_show_resource_list(head)
     dqs_list_type *head;
     
{
  
  dqs_list_type *lp;
  
  DENTER_EXT((DQS_EVENT,"dqs_show_resource_list"));
  
  while (head)
    {
      printf("\tqty %d",head->int0);
      if (head->str2)
	printf (" -exec.eq.\"%s\"",head->str2);
      printf("\n");
      lp=head->chain;
      while (lp)
	{
	  printf ("\t\t%s",lp->str0);
	  if (lp->int1)
	    dqs_show_op(DQS_STDOUT,lp->int1);
	  if (lp->str1)
	    printf ("\"%s\"",lp->str1);
	  else if (lp->int0)
	    printf ("%d",lp->int0);
	  printf("\n");
	  lp=lp->next;
	}
      head=head->next;
    }
  
  DEXIT;
  return;
}

/*****************************************************************/
void dqs_show_complex_list(head)
     dqs_list_type *head;
     
{
  
  dqs_list_type *lp;
  
  DENTER_EXT((DQS_EVENT,"dqs_show_complex_list"));
  
  while (head)
    {
      printf("\tname %s\n",head->str0);
      lp=head->chain;
      while (lp)
	{
	  printf ("\t\t%s",lp->str0);
	  if (lp->int1==EQ_OP)
	    printf("=");
	  if (lp->str1)
	    printf ("\"%s\"",lp->str1);
	  else if (lp->int0)
	    printf ("%d",lp->int0);
	  printf("\n");
	  lp=lp->next;
	}
      head=head->next;
    }
  
  DEXIT;
  return;
}
/*****************************************************************/
void dqs_show_consumable_list(head)
     dqs_list_type *head;
     
{
  
  dqs_list_type *lp;
  
  DENTER_EXT((DQS_EVENT,"dqs_show_consumable_list"));
  
  while (head)
    {
      printf("\tname %s\n",head->str0);
      lp=head->chain;
      while (lp)
	{
	  printf ("\t\t%s",lp->str0);
	  printf ("\t available=\t%d",lp->int0);
	  printf ("\t consume_by\t%d",lp->int1);
	  printf ("\t current\t%d",lp->int2);
	}
      head=head->next;
    }
  
  DEXIT;
  return;
}

/*****************************************************************/
char *dqs_write_complex_list(head)
     dqs_list_type *head;
     
{
  FILE          *fp;
  char     *cp=NULL;
  string str;
  dqs_list_type *lp;
  
  DENTER_EXT((DQS_EVENT,"dqs_write_complex_list"));
  
  cp=(char *)tmpnam(str);
  sprintf(str,"%s",cp);
  fp = fopen(str,"w");
  if (!fp) {
    CRITICAL((DQS_EVENT,"DQS_ERROR_0548 error writing %s\n",str));
    DEXITE;
    return NULL;
  }
  
  lp=head->chain;
  while (lp)
    {
      fprintf (fp,"%s",lp->str0);
      if (lp->int1==EQ_OP)
        fprintf(fp,"=");
      if (lp->str1)
        fprintf (fp,"%s",lp->str1);
      else if (lp->int0)
        fprintf (fp,"%d",lp->int0);
      fprintf(fp,"\n");
      lp=lp->next;
    }
  fclose(fp);
  chmod(str,0744);
  cp=dqs_string_insert(NULL,str);
  
  DEXIT;
  return cp;
}

/*****************************************************************/
char *dqs_write_consumable_list(head)
     dqs_list_type *head;
     
{
  FILE          *fp;
  char     *cp=NULL;
  string str;
  dqs_list_type *lp;
  
  DENTER_EXT((DQS_EVENT,"dqs_write_consumable_list"));
  
  cp=(char *)tmpnam(str);
  sprintf(str,"%s",cp);
  fp = fopen(str,"w");
  if (!fp) {
    CRITICAL((DQS_EVENT,"DQS_ERROR_0549 error writing %s\n",str));
    DEXITE;
    return NULL;
  }
  
  lp=head->chain;
  fprintf(fp,"consumable %s\n",lp->str0);
  fprintf (fp,"available= %d\n", lp->int0);
  fprintf (fp,"consume_by= %d\n",lp->int1);
  fprintf (fp,"currentCount= %d\n",lp->int2);
  
  fclose(fp);
  chmod(str,0744);
  cp=dqs_string_insert(NULL,str);
  
  DEXIT;
  return cp;
}

/*****************************************************************/
char *dqs_ctime(i)
     time_t i;
     
{
  
  struct tm *tm;
  time_t ii;
  static char str[128];
  
  ii=i;
  tm=localtime(&ii);
  sprintf(str,"%02d/%02d/%02d %02d:%02d:%2d ",
	  tm->tm_mon + 1,tm->tm_mday,tm->tm_year,
	  tm->tm_hour,tm->tm_min,tm->tm_sec);
  return(str);
  
}

/*****************************************************************/
void dqs_close_fds()
     
{
  
  int fd;
  
  for (fd=0;fd<NOFILE;fd++)
    close(fd);
  
}

/*********************************************************************/
char     *dqs_concat_buf(script_ptr,str,script_size)
     char     *script_ptr;
     char     *str;
     u_long32 *script_size;
     
{
  
  int i;
  static char *buf=NULL;
  static int buf_size=0;
  
  DENTER_EXT((DQS_EVENT,"dqs_concat_buf"));
  
  if (!script_ptr) {
    buf_size=CHUNK;
    buf=dqs_malloc(buf_size);
  }
  
  i=strlen(str);
  if (i+(*script_size)>=buf_size)
    {
      buf_size+=CHUNK;
      buf=dqs_realloc(buf,buf_size);
    }
  
  strcat(buf,str);
  strcat(buf,"\n");
  i++;
  *script_size+=i;
  
  DPRINTF((DQS_EVENT,"%s",buf));
  
  DEXIT;
  return(buf);
  
}

/*****************************************************************/
void dqs_unlink(prefix,suffix)
     char *prefix;
     char *suffix;
     
{
  
  int    status;
  string str;
  
  DENTER((DQS_EVENT,"dqs_unlink"));
  
  if (!suffix)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0550 error: NULL suffix passed to dqs_unlink()"));
      DEXITE;
      return;
    }
  
  if (prefix)
    sprintf(str,"%s/%s",prefix,suffix);
  else
    sprintf(str,"%s",suffix);
  
  status=unlink(str);
  
  if (status)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0551 error: unlink() returned %d",status));
      DEXITE;
      return;
    }
  
  DEXIT;
  return;
  
}

/************************************************************************/
void dqs_log_pid()
     
{
  
  int         pid;
  FILE        *fp;
  struct stat buf;
  
  DENTER((DQS_EVENT,"dqs_log_pid"));
  
  close(creat(PID_FILE,0755));
  fp = fopen(PID_FILE,"w");
  pid=getpid();
  fprintf(fp,"%d",pid);
  fclose(fp);
  
  DEXIT;
  return;
  
}     

/************************************************************************/
char *dqs_getenv(env_str)
     char *env_str;
     
{
  
  char        *cp;
  
  DENTER((DQS_EVENT,"dqs_getenv"));
  
  cp=(char *)getenv(env_str);
  if (!cp)
    {
      DEXITE;
      return(cp);
    }
  
  if (strlen(cp)>=MAX_STRING_SIZE)
    {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0552 strlen($%s) exceeds MAX_STRING_SIZE %d",
		env_str,MAX_STRING_SIZE));
      DEXITE;
      abort();
    }
  
  DEXIT;
  return(cp);
  
}

/*******************************************************************************************/
int dqs_read_stats (f, Stats, qcomplex_str)
     FILE *f;
     dqs_stats_type *Stats;
     char *qcomplex_str;
     /*
       dqs_read_stats - read stat info from file.
       Returns: -3 if f is NULL
       -2 if unexpected EOF reached
       -1 if the number of items read was incorrect
       0 if success
       1 if expected EOF reached
     */
     
{
  int fscanf_count;
  
  DENTER((DQS_EVENT,"dqs_read_stats"));
  
  if (f == NULL)
    return (-3);
  
  fscanf_count = fscanf (f, STATFILE_FSCANF_FORMAT, STATFILE_FSCANF_VARS);
  if (fscanf_count == EOF)
    {
      /* Expected end of file. */
      return (1);
    }
  else if (fscanf_count != STATFILE_FSCANF_COUNT)
    {
      /* Bad news.  File must be malformed. */
      fscanf_count = fscanf(f, STATFILE_FSCANF_FORMAT, STATFILE_FSCANF_VARS);
      if (fscanf_count != EOF)
        return (-1);
      else
        return (-2);
    }
  
  return (0);
}

/*******************************************************************************************/
int dqs_sleep(sec,usec)
     int sec;
     int usec;
     
{
  
  static struct timeval timeout;
  
  timeout.tv_sec=sec;
  timeout.tv_usec=usec;
  
  select(0,(fd_set *)0,(fd_set *)0,(fd_set *)0,&timeout);
  
}

/******************************************************************/
/************   contact qmaster for exception conditions  *********/
/******************************************************************/
/*    The routine is only entered when all else has failed and   **/
/*  the normal processing of the dqs_execd must be suspended until*/
/*  given guidance by the qmaster                                 */
/******************************************************************/

int dqs_report_problem( report, wait )
     dqs_list_type *report;
     int wait ;
{
  
  dqs_list_type    *listel_ptr=NULL;
  dqs_list_type    *listel_ptr1=NULL;
  dqs_list_type    *listel_ptr2=NULL;
  int status, action_flag;
  int sfd, trycount;
  dqs_list_type *lp;
  char dqs_mail_subj[1024];
  char dqs_mail_body[1024];
  struct sockaddr_in from;
  ADDRLEN fromlen=sizeof(from);
  
  
  /*  first notify qmaster which will send mail to administrator          */
  
  DENTER((DQS_EVENT,"dqs_report_problem"));
  
  listel_ptr=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
  bzero((char *)&listel_ptr,sizeof(listel_ptr));
  listel_ptr1=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
  bzero((char *)&listel_ptr1,sizeof(listel_ptr1));
  listel_ptr2=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
  bzero((char *)&listel_ptr2,sizeof(listel_ptr2));
  
  listel_ptr->type=me.who;
  listel_ptr->int0= QMASTER_ACTION_REQUEST;
  listel_ptr->int1= ERROR_REPORT;
  
  listel_ptr->str0=dqs_string_insert(NULL,me.qualified_hostname);
  listel_ptr->str1=dqs_string_insert(NULL,report->str0);
  listel_ptr->next= report;
  trycount=0;
  if(wait<0) trycount++; /* flag forces us to avoid trying to fork off*/
  /* any new proccesses inthe mailer   */ 
  
  
  do{
    if ((sfd=dqs_send_list(me.default_cell,conf.qmaster_service,sfd,listel_ptr))<0){
      if(trycount==0){
	/* attempt to send mail directly to the administrator if we cannot contact qmaster */
	lp=dqs_resolve_cell(me.default_cell);   /*  get wmaster host */
	if(lp){
	  sprintf(dqs_mail_subj,"dqs_execd in distress!");
	  strcat(dqs_mail_body, report->str0);
	  dqs_send_mail(conf.administrator, lp->str0,dqs_mail_subj, dqs_mail_body);
	}
      }
      trycount++;
      sleep (5000);
    }
  } while (sfd<0);
  (void) dqs_free_list(listel_ptr);
  dqs_close_sfd(sfd);
  
  if (wait==0) return 0;
  
  /* then wait for action by qmaster or administrator, if specified  */
  action_flag=0;
  
  while (!action_flag) {
    
    
    sigprocmask(SIG_SETMASK,&default_mask,&omask);
    if ((sfd = accept(sfd,(struct sockaddr *) &from, &fromlen)) < 0)
      {
	continue;
      }
    else {
      sigprocmask(SIG_SETMASK,&io_mask,&omask);
      status=dqs_get_list(sfd,&listel_ptr1);
      sigprocmask(SIG_SETMASK,&default_mask,&omask);
    }
    
    if (status)      /* no connection try again later */
      {
        sleep(5000);
      }
    
    if ( (dqs_q_master(sfd)) || (listel_ptr1->who!=QMASTER) ){
      
      listel_ptr2->status=DQS_NAK;
      listel_ptr2->str0=dqs_string_insert(NULL, "error: you are not a DQS trusted host");
      (void) dqs_send_list(NULL,NULL,sfd,listel_ptr2);
      FREE(listel_ptr2->str0);
      dqs_close_sfd(sfd);
      continue;
    }
    switch(listel_ptr->type)
      {
	/*------------------------------------------------------*/
      case SHUTDOWN:
	dqs_close_sfd(sfd);
	(void) dqs_free_list(listel_ptr2);
	dqs_shutdown();
	
      default:
	action_flag= TRUE;
      }
    dqs_close_sfd(sfd);
    
    (void) dqs_free_list(listel_ptr);
    (void) dqs_free_list(listel_ptr1);
    (void) dqs_free_list(listel_ptr2);
  }   /* wait until qmaster action is spefied  */
  
  return 0;                    
}
