/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 ipvr stuttgart and thomas harrer
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for OSF/Motif(tm) applications. 
**  based on libhtmlw from NCSA Mosaic(tm) version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**  
** -------------------------------------------------------------------- *
*h  $Id: actionarea.h,v 1.12 1995/06/28 12:59:30 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		actionarea.h
**
**  contents:		based on button face lib.
**
**  interface:		#include "actionarea.h"
**
**  bugs:		should be named buttons.h
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
#ifndef _ACTIONAREA_H_
#define _ACTIONAREA_H_ 1

/* -------------------------------------------------------------------- *
*g  public type:	actions_t
** -------------------------------------------------------------------- */
typedef struct action_s  {
    int		action_type;
    void 	(*callback) (Widget, XtPointer, XtPointer);
} action_t;

/* type for accessing actions.  */
typedef struct actionrec_s {

    int		action_type;
    Widget	w;

} actionrec_t;

actionrec_t* 	actionrec;
int		number_of_actions;

/* -------------------------------------------------------------------- *
*g  definitions for pixmap types.
** -------------------------------------------------------------------- */
#define action_dismiss 	1
#define action_history 	2
#define action_back    	3
#define action_up	4
#define action_down	5
#define action_index	6

/* -------------------------------------------------------------------- *
*p  public prototype
** -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- *
*p  procedure-name:	create_actionarea
**
**  purpose:		creates buttons with desired bindings
** -------------------------------------------------------------------- *
**  args:		parent widget, 
**  return type:	returns the action area form.
**  precondition:	must be child of manager widget.
**  postcondition:	action area is created and managed.
**  error handling.:	-
** -------------------------------------------------------------------- */
Widget
create_actionarea (/* i  */ Widget 	parent, 
		   /* i  */ action_t* 	actions, 
		   /* i  */ int 	num_actions);

/* -------------------------------------------------------------------- *
*p  procedure-name:	actions_set_sensitive
**
**  purpose:		sets all actions of a specified action_type
**			to the sensitivity state.
** -------------------------------------------------------------------- *
**  args:		action id (only those are available that are
**			declared in actions.h)
**  return type:	public void
**  precondition:	actions must be initialized (else nothing is done).
**  postcondition:	sensitivity state is changed.
** -------------------------------------------------------------------- */
void
actions_set_sensitive (/* i  */ int	action_type,
		       /* i  */ Boolean	sensitive);

#endif /* !_ACTIONAREA_H_ */
/* -------------------------------------------------------------------- *
*l  emacs:
**  local variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  end:
** -------------------------------------------------------------------- */
