/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 thomas harrer. all rights reserved.
** -------------------------------------------------------------------- *
*H  $Id: check.h,v 1.4 1995/06/13 11:57:58 harrer Exp $
** -------------------------------------------------------------------- *
**
**  check.h
**
**	routines for debugging applications using 
** 	malloc and friends.
**
**  interface:		
**      #include "check.h"
**
**  by thomas harrer. e-mail thomas.harrer@rus.uni-stuttgart.de
** -------------------------------------------------------------------- */
#ifndef _CHECK_H_
#define _CHECK_H_ 1

/* -------------------------------------------------------------------- *
*g  include files
** -------------------------------------------------------------------- */
#include <string.h>
#include <stdlib.h>

/* -------------------------------------------------------------------- *
*g  malloc debug macros
** -------------------------------------------------------------------- */
#ifdef MALLOC_DEBUG
#define MD_MALLOC 1
#define SD_STRING 1
#endif /* MALLOC_DEBUG  */

#ifdef MD_MALLOC
#include "mallocdebug.h"
#define _md_size(_ptr,_val) ((_val) == 0 ? md_get_size ((_ptr)) : (_val))
#else
#define _md_size(_ptr,_val) (_val)
#endif /* MD_MALLOC */

#ifdef MALLOC_DEBUG
#define check(_fun,__target,__size)					\
{									\
    (void) fprintf (stderr, "%s\t%s [%x] ", _fun, #__target,		\
		    (int) __target);					\
    (void) fprintf (stderr, "(%d)", (int) _md_size (__target, __size));	\
    (void) fprintf (stderr, " [%s line %d]\n", __FILE__, __LINE__);	\
    (void) fflush (stderr);						\
}
#undef NO_CHECK_WARNING
#else 
#define check(_fun,__target,__size) /* empty  */
#endif 	   /* MALLOC_DEBUG  */

#ifdef NO_CHECK_WARNING
#define check_warning(_fun,_ptr) /* empty */
#else
#define check_warning(_fun,__ptr)					\
{									\
    (void) fprintf (stderr, "%s\twarning: called with null arg %s",	\
		    _fun, #__ptr);					\
    (void) fprintf (stderr, " [file %s line %d]\n",			\
		    __FILE__, __LINE__);				\
    (void) fflush (stderr);						\
}
#endif /* NO_CHECK_WARNING  */

#define check_fatal(_fun,__ptr)						\
{									\
    (void) fprintf (stderr, "Error: %s failed for %s.\n", 		\
		    _fun, #__ptr);					\
    exit (2);								\
}

#define checked_malloc(_target,_count,_type)				\
{									\
    size_t _size = sizeof ( _type ) * (_count);				\
    _target = (_type *) malloc (_size);					\
    if (!_target) {							\
	check_fatal ("malloc", _target);				\
    }									\
    check ("malloc", _target, _size);					\
}

#define checked_calloc(_target,_count,_type)				\
{ 									\
    size_t _size = sizeof ( _type ) * (_count);				\
    _target = (_type *) malloc (_size);					\
    if (!_target) { 							\
	check_fatal ("calloc", _target); 				\
    } 									\
    (void) memset (_target, 0, _size); 					\
    check ("calloc", _target, _size);					\
}

#define checked_realloc(_target,_newcount,_type)			\
{									\
    size_t _size =  sizeof (_type) * ( _newcount );			\
    _type * _tmp_ptr;							\
    check ("realloc", _target, 0);					\
    _tmp_ptr = (_type *) realloc (_target, _size);			\
    if (!_tmp_ptr) {							\
	check_fatal ("realloc", _target);				\
    }									\
    _target = _tmp_ptr;							\
    check ("->", _target, _size);					\
}

#define checked_strdup(_target,_src)					\
{									\
    if (_src) {								\
	size_t _size = strlen (_src) + 1;				\
	_target = (char*) malloc (_size);				\
	if (!_target) {							\
	    check_fatal ("strdup", _src);				\
	}								\
	strcpy (_target, _src);						\
	check ("strdup", _target, _size);				\
    } else  {								\
	check_warning ("strdup", _src);					\
    }									\
}

#define checked_free(_ptr) 						\
{									\
    if (_ptr) { 							\
        check ("free", _ptr, 0);					\
	free (_ptr); 							\
	_ptr = NULL; 							\
    } else  {								\
	check_warning ("free", _ptr);					\
    }									\
}

/* -------------------------------------------------------------------- *
*g  checked macros for string functions
**  prefix for them is c_
** -------------------------------------------------------------------- */
#ifdef SD_STRING
#include "stringdebug.h"
#else
#define c_strcmp(_str1,_str2)						\
((_str1) && (_str2) ? strcmp (_str1, _str2) : -1)

#define c_strncmp(_str1,_str2,_len)					\
((_str1) && (_str2) ? strncmp (_str1, _str2, _len) : -1)

#define c_strlen(_str) ((_str) ? strlen (_str) : 0)

#define c_strcpy(_target,_src) 						\
((_target) && (_src) ? strcpy (_target, _src) : NULL)

#define c_strncpy(_target,_src,_len) 					\
((_target) && (_src) ? strncpy (_target, _src, _len) : NULL)

#define c_strcat(_target,_src) 						\
((_target) && (_src) ? strcat (_target, _src) : NULL)

#define c_strncat(_target,_src,_len) 					\
((_target) && (_src) ? strncat (_target, _src, _len) : NULL)

#endif /* SD_STRING  */

#ifndef NO_MEMMOVE
#define c_memmove memmove
#else
#define c_memmove memcpy
#endif

#endif /* !_CHECK_H_ */
/* -------------------------------------------------------------------- *
*l  emacs:
**  local variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  end:
** -------------------------------------------------------------------- */
