/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 ipvr stuttgart and thomas harrer
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for OSF/Motif(tm) applications. 
**  based on libhtmlw from NCSA Mosaic(tm) version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**  
** -------------------------------------------------------------------- *
*h  $Id: help.h,v 1.15 1995/06/28 12:59:30 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		help.h
**
**  contents:		public header file for libhelp and libhlpclient
**			(two different implementations for get_help).
**
**  interface:		#include it to the motif application which
**			needs a help system
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
#ifndef _HELP_H_
#define _HELP_H_ 1

#include <X11/Intrinsic.h>

/* -------------------------------------------------------------------- *
*g  public resources
** -------------------------------------------------------------------- */
#define help_class_name 	0
#define help_standalone 	1
#define help_index		2
#define help_update		3

/* resources for libhlpclient:  */
#define help_server		4
/* differet kinds of servers.  */
#define NO_SERVER		((XtPointer) 0)
#define XMHELP_SERVER		((XtPointer) 1)
#define MOSAIC_SERVER		((XtPointer) 2)

/* -------------------------------------------------------------------- *
*g  prototypes
** -------------------------------------------------------------------- */
#ifdef __cplusplus
extern "C" {
#endif /* c++ */

void get_help (Widget, XtPointer, XtPointer);
void help_set_resource (int, XtPointer);

#ifdef __cplusplus
} 
#endif /* c++ */

#endif /* !_HELP_H_ */
/* -------------------------------------------------------------------- *
*l  emacs:
**  local variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  end:
** -------------------------------------------------------------------- */
