/************************************************************************/
/* Module : highlightData.h					        */
/* Purpose: syntax highlighting pattern creation                        */
/* Mod. By: Keith R. Davis 				                */
/* Date   : 3/23/95					                */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay Software	                */
/*          Copyright(c) 1996 Universities Research Association, Inc.	*/
/*          All rights reserved.					*/
/*                                                                      */
/*          Fermilab Nirvana GUI Library				*/
/*          June 24, 1996                      				*/
/*          By Mark Edel			                        */
/************************************************************************/

#ifndef _HIGHLIGHT_DATA_H
#define _HIGHLIGHT_DATA_H

#define PLAIN_LANGUAGE_MODE -1

/* maximum number of language modes allowed */
#define MAX_LANGUAGE_MODES 40

patternSet *FindPatternSet(char *langModeName);
int LoadStylesString(char *inString);
int LoadLanguageModesString(char *inString);
XFontStruct *FontOfNamedStyle(WindowInfo *window, char *styleName);
char *ColorOfNamedStyle(char *styleName);
int NamedStyleExists(char *styleName);
patternSet *readDefaultPatternSet(char *langModeName);
void freePatternSet(patternSet *p);
char *GetWindowDelimiters(WindowInfo *window);
int ReadNumericField(char **inPtr, int *value);
char *ReadSymbolicField(char **inPtr);
int ReadQuotedString(char **inPtr, char **errMsg, char **string);
char *MakeQuotedString(char *string);
int SkipDelimiter(char **inPtr, char **errMsg);
int ParseError(Widget toDialog, char *stringStart, char *stoppedAt,
    char *errorIn, char *message);
char *CopyAllocatedString(char *string);
int AllocatedStringsDiffer(char *s1, char *s2);
XFontStruct *GetDefaultFontStruct(XmFontList font);
char *EscapeSensitiveChars(char *string);
char *LanguageModeName(int mode);

#endif
