/* @(#) $Header: kissdump.c,v 1.7 92/11/29 17:37:52 deyke Exp $ */

/* Tracing routines for KISS TNC
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"

#define	PARAM_DATA	0
#define	PARAM_TXDELAY	1
#define	PARAM_PERSIST	2
#define	PARAM_SLOTTIME	3
#define	PARAM_TXTAIL	4
#define	PARAM_FULLDUP	5
#define	PARAM_HW	6
#define	PARAM_RETURN	255

void ki_dump(unsigned char *data, int length)
{
	int type;
	int val;

#if 0
	fprintf(stdout, "KISS: ");
#endif

	type = data[0] & 0xf;

	if (type == PARAM_DATA)
	{
#if 0
		fprintf(stdout, "Data, %d bytes\n", length - 1);
#endif
		ax25_dump(data + 1, length - 1);
		return;
	}
	
	val = data[1];
	
	switch (type)
	{
	case PARAM_TXDELAY:
		fprintf(stdout, "TX Delay: %lu ms\n", val * 10L);
		break;
	case PARAM_PERSIST:
		fprintf(stdout, "Persistence: %u/256\n", val + 1);
		break;
	case PARAM_SLOTTIME:
		fprintf(stdout, "Slot time: %lu ms\n", val * 10L);
		break;
	case PARAM_TXTAIL:
		fprintf(stdout, "TX Tail time: %lu ms\n", val * 10L);
		break;
	case PARAM_FULLDUP:
		fprintf(stdout, "Duplex: %s\n", val == 0 ? "Half" : "Full");
		break;
	case PARAM_HW:
		fprintf(stdout, "Hardware %u\n", val);
		break;
	case PARAM_RETURN:
		fprintf(stdout, "RETURN\n");
		break;
	default:
		fprintf(stdout, "code %u arg %u\n", type, val);
		break;
	}
}
 
