// $Id: Cxx_Fileset.cc,v 1.65 2001/10/11 14:07:23 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Cxx.hh"
#include "Configuration.hh"
#include "writers/WriterBase.hh"
#include "WidgetMap.hh"

Cxx_Fileset::Cxx_Fileset(const Tag &t, Cxx &_toplevel)
	: top(t), toplevel(_toplevel)
{
}

void Cxx_Fileset::WriteFiles(bool _toplevel)
{  const Widget w(top);
   ReregisterLocal(w);
   gh.open(&w,File_FOO_GLADE_HH); WriteHeader(gh,File_FOO_GLADE_HH);
   gc.open(&w,File_FOO_GLADE_CC); WriteHeader(gc,File_FOO_GLADE_CC);
   if (!Configuration.bare_bones) 
   { h.open(&w,File_FOO_HH); WriteHeader(h,File_FOO_HH);
     c.open(&w,File_FOO_CC); WriteHeader(c,File_FOO_CC);
   
     if (_toplevel)
     {toplevel.main.Include(h.FileName(),true);
      (Remember<CxxFile>(toplevel.main).Statement()
      	  << "manage(new class " << Configuration.TypeName(w.Name()) << "())")
      	 .EndLine();
     }

      if (!Configuration.no_autoconf)
      {  toplevel.makefile_am.Dependancy(gc.FileName(File_NODIR))
      		.Dependancy(c.FileName(File_NODIR));
         Remember<MakeFile>(toplevel.makefile_am).Dependancy(gh.FileName(File_NODIR))
         	.Dependancy(h.FileName(File_NODIR));
         if (Configuration.gettext_support)
         {  toplevel.potfiles << gc.FileName(0) << '\n'
         	<< c.FileName(0) << '\n';
         }
      }
      else
      {  toplevel.makefile.Dependancy(gc.FileName(File_NODIR|File_OBJECT))
      		.Dependancy(c.FileName(File_NODIR|File_OBJECT));
      }
   }
   
   if (!Configuration.bare_bones) 
   {  c.Include(h.FileName(),true);
      gc.Include(h.FileName(),true);
   }
   gc.Include(gc.FileName(File_FOO_HH),true);

   WriteClasses(w);
   
   if (!Configuration.bare_bones)
   {  WriteFooter(c,File_FOO_CC); c.close();
      WriteFooter(h,File_FOO_HH); h.close();
   }
   WriteFooter(gc,File_FOO_GLADE_CC); gc.close();
   WriteFooter(gh,File_FOO_GLADE_HH); gh.close();
}

void Cxx_Fileset::DoIncludes(const Widget &w)
{  {  const WriterBase &wr(LookupWriter(w,false));
      wr.GHInclude(w,gh);
   }
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
	i!=w.end_contained();++i)
   {  Widget w2(*i);
      const WriterBase &wr(LookupWriter(w2,true));
      wr.GHInclude(w2,gh);
//      std::cout << (*i).getTagPtr() << '=' << (*i).Class() << '\n';  
   }
}

void Cxx_Fileset::WriteClasses(const Widget &w)
{  //if (Configuration.use_libglade)
   //{  WriteClasses_libglade(w);
   //   return;
   //}
   // Include own type and type of all included widgets
//   std::cerr << "WriteClasses(" << w.Name() << ") {\n";
   DoIncludes(w);
   // start class generation

   /******* GH: class Xyz_Glade ******/
   const WriterBase &top_wr(LookupWriter(w));
   gh.Definition().Class(Configuration.TypeName(w.Name(),true));
   top_wr.Derivation(w,gh);
   gh.StartBlock();
   top_wr.AdditionalMemberVars(w,gh,true);

   for (Widget::const_contained_iterator i=w.begin_contained();
	i!=w.end_contained();++i)
   {  Widget w2(*i);
      const WriterBase &wr(LookupWriter(w2,true));
      wr.GHDeclaration(w2,gh);
      wr.AdditionalMemberVars(w2,gh);
   }
   
   /****** GH: ctor, dtor *********/
   gh.Protected().Declaration()
   	.FunctionName(Configuration.TypeName(w.Name(),true));
   if (Configuration.has_accelerators && top_wr.needDataArg(w))
   {  gh.FunctionArg("GlademmData *_data");
   }
#ifdef NEED_CONSTRUCT_ARGS
   top_wr.ConstructArgs(w,gh);
   for (Widget::const_contained_iterator i=w.begin_contained(InternalBoth);
	i!=w.end_contained();++i)
   {  Widget w2(*i);
      const WriterBase &wr(LookupWriter(w2,true));
      wr.ConstructArgs(w2,gh);
   }
#endif
   gh.EndLine();
   gh.Declaration()
        .FunctionName("~"+Configuration.TypeName(w.Name(),true)).EndLine();
   gh.EndBlock();
   
   /******* GH: defines (glademm_get) ***********/
   if (w.getString("cxx_visibility","private")=="public") 
   // we can't use top_wr since we need the component type, not the widget type
      GenerateMapDefine(LookupWriter(w,true),w);
   for (Widget::const_contained_iterator i=w.begin_contained();
	i!=w.end_contained();++i)
   {  Widget w2(*i);
      if (w2.getString("cxx_visibility","private")=="public"
         	 && !w2.getBool(CXX_SEPERATE_CLASS)) 
         GenerateMapDefine(LookupWriter(w2,true),w2);
   }
   
   /******* H: class Xyz ******/
   h.Definition().Class(Configuration.TypeName(w.Name()));
   h.Derive("public "+Configuration.TypeName(w.Name(),true));
   h.StartBlock();

   h.Declaration() << "friend class " << Configuration.TypeName(w.Name(),true);
   h.EndLine();
   if (Configuration.has_accelerators && top_wr.needDataArg(w))
   {  h.Public().Definition().FunctionName(Configuration.TypeName(w.Name()))
   	.FunctionArg("GlademmData *_data")
   	.Construct(Configuration.TypeName(w.Name(),true),"_data")
   	.StartBlock().EndBlock();
   } 
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
	i!=w.end_contained();++i)
   {  Widget w2(*i);
      const WriterBase &wr(LookupWriter(w2,true));
      DeclareSignalHandler(wr,w2,w);
   }

   DeclareSignalHandler(top_wr,w,w,true);
   h.EndBlock();
   
   /****** GC: include, definitions **************/
   
   top_wr.GCInclude(w,gc);
   top_wr.GCDefinition(w,gc);
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
	i!=w.end_contained();++i)
   {  Widget w2(*i);
      const WriterBase &wr(LookupWriter(w2,true));
      wr.GCInclude(w2,gc);
      wr.GCDefinition(w2,gc);
   }
   
   /****** GC: ctor **************/
   ClearRadioGroups();
   gc.Definition().FunctionName() << Configuration.TypeName(w.Name(),true)
   	<< "::" << Configuration.TypeName(w.Name(),true);
   if (Configuration.has_accelerators && top_wr.needDataArg(w))
   {  gc.FunctionArg("GlademmData *_data");
   }
#ifdef NEED_CONSTRUCT_ARGS
   top_wr.ConstructArgs(w,gc);
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
	i!=w.end_contained();++i)
   {  Widget w2(*i);
      const WriterBase &wr(LookupWriter(w2,true));
      wr.ConstructArgs(w2,gc);
   }
#else
   if (!Configuration.has_accelerators|| !top_wr.needDataArg(w)) gc.FunctionArg();
#endif
   // member constructors
   gc.NewLine(false); // XXX: because of SourceWriter limitation
   if (top_wr.NeedExplicitCtor(w))
      top_wr.ParentConstruction(w,gc);
   // function body
   gc.StartBlock();
   // ctor head initialization
   if (top_wr.CantMemberConstruct(w))
   {  std::cerr << "ERROR: " << w.Name() << ": Can't form a class of its own (yet).\n";
   }
   top_wr.CreatePointer_Toplevel(w,gc);
   top_wr.ClassConstructor(w,gc);
   
   // create widgets
   for (Widget::const_contained_iterator i=w.begin_contained(NoInternal,Configuration.debug);
	i!=w.end_contained();++i)
   {  Widget w2(*i);
      const WriterBase &wr(LookupWriter(w2,true));
      wr.CreatePointer(w2,gc);
   }
   
   // configure widgets
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both,Configuration.debug);
	i!=w.end_contained();++i)
   {  if (!i->getBool(CXX_SEPERATE_CLASS))
      {  const Widget WriterWidget(*i.getWriterTag());
         Widget w2(*i);
         const WriterBase &ww_wr(LookupWriter(WriterWidget));
         std::string instance(ww_wr.Instance(WriterWidget,w2,i.getSWType()));
         if (!instance.size()) 
         {  std::cerr << "can't modify " << WriterWidget.Name() << ':' << w2.Name() << "\n";
            continue; // can't modify this widget
         }
         const WriterBase &wr2(LookupWriter(w2,true));
         wr2.Configure(w2,gc,instance);
         wr2.AddChildren(w2,gc,instance);
//         wr2.Constructor(w2,gc,instance);
      }
   }
   const std::string inst(top_wr.Instance(w,w,not_Subwidget));
   top_wr.Configure(w,gc,inst);
   top_wr.AddChildren(w,gc,inst);
//   top_wr.Constructor(w,gc,inst);
   
   // show widgets (no need to show internal ones)
   for (Widget::const_contained_iterator i=w.begin_contained();
	i!=w.end_contained();++i)
   {  Widget w2(*i);
      if (!w2.getBool(CXX_SEPERATE_CLASS))
      {  const Widget WriterWidget(*i.getWriterTag());
         const WriterBase &ww_wr(LookupWriter(WriterWidget));
         std::string instance(ww_wr.Instance(WriterWidget,w2,i.getSWType()));
         if (!instance.size()) 
         {  std::cerr << "Configure_show has problems with " 
         	<< WriterWidget.Name() << ':' << w2.Name() << '\n';
            continue;
         }
//         assert(instance.size()); // we should not see internal widgets!
         const WriterBase &wr(LookupWriter(w2,true));
         wr.Configure_show(w2,gc,instance);
      }
   }
   top_wr.Configure_show(w,gc,inst);
   
   // Connect callbacks
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
	i!=w.end_contained();++i)
   {  if (!i->getBool(CXX_SEPERATE_CLASS))
      {  const Widget WriterWidget(*(i.getWriterTag()));
         Widget w2(*i);
         const WriterBase &ww_wr(LookupWriter(WriterWidget));
         std::string instance(ww_wr.Instance(WriterWidget,w2,i.getSWType()));
         if (!instance.size()) 
         {  continue; // can't connect this widget
         }
         const WriterBase &wr2(LookupWriter(w2,true));
	 ConnectSignalHandler(wr2,w2,w,instance);
      }
   }
   ConnectSignalHandler(top_wr,w,w,inst);

   // add them to the map
   if (w.getString("cxx_visibility","private")=="public") 
   // we can't use top_wr since we need the component type, not the widget type
      AddToMap(w,"this");
   for (Widget::const_contained_iterator i=w.begin_contained();
	i!=w.end_contained();++i)
   {  Widget w2(*i);
      if (w2.getString("cxx_visibility","private")=="public"
         	 && !w2.getBool(CXX_SEPERATE_CLASS)) 
         AddToMap(w2,WriterBase::Pointer(w2));
   }
   
   gc.EndBlock();

   /************ GC: dtor *************/
   gc.Definition().FunctionName() << Configuration.TypeName(w.Name(),true)
   	<< "::~" << Configuration.TypeName(w.Name(),true);
   gc.StartBlock();
   // destroy widgets
   for (Widget::const_contained_iterator i=w.begin_contained();
	i!=w.end_contained();++i)
   {  Widget w2(*i);
      const WriterBase &wr(LookupWriter(w2,true));
      wr.Destructor(w2,gc);
      wr.DestroyPointer(w2,gc);
   }
   top_wr.ClassDestructor(w,gc);
   top_wr.DestroyPointer_Toplevel(w,gc);
   gc.EndBlock();
   
   /****** C: signal handler stubs *******/
   
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
	i!=w.end_contained();++i)
   {  Widget w2(*i);
      if (w2.getBool(CXX_SEPERATE_CLASS)) continue;
      const WriterBase &wr(LookupWriter(w2,true));
      DefineSignalHandler(wr,w2,w);
   }

   DefineSignalHandler(top_wr,w,w);
   
   /****** other classes/files ********/
   // recurse
   for (Widget::const_contained_iterator i=w.begin_contained();
	i!=w.end_contained();++i)
   {  Widget w2(*i);
      if (w2.getBool(CXX_SEPERATE_FILE))
      {  Cxx_Fileset sub_fs(*(w2.getTagPtr()),toplevel);
         sub_fs.WriteFiles();
      }
      else if (w2.getBool(CXX_SEPERATE_CLASS))
         WriteClasses(w2);
   }
//   std::cerr << "}\n";
}

void Cxx_Fileset::WriteHeader(WidgetFile &f,File_type tp)
{  switch(tp)
   {  case File_FOO_HH:
         Cxx::WriteCreation(f,tp);
   	 f << "//\n// newer (non customized) versions of this file go to ";
   	 f << Configuration.FileName(f.widgetName(),f.type(),File_GLADE|File_NODIR) << "\n"
   	      "\n"
   	          "// you might replace\n"
   	          "//    class " << Configuration.TypeName("foo",false) << " : public ";
   	 f << Configuration.TypeName("foo",true) << " { ... };\n"
   	      "// by\n"
   	          "//    typedef " << Configuration.TypeName("foo",true)<< ' '
   	       << Configuration.TypeName("foo",false) << ";\n"
   	      "// if you didn't make any modifications to the widget\n"
   	      "\n";
   	 f << "#ifndef "<<Configuration.FileDefine(f.widgetName(),f.type())<<'\n';
   	 f << "#  include \"" << Configuration.FileName(f.widgetName(),File_FOO_GLADE_HH,File_NODIR)<<"\"\n" 
   	      "#  define "<<Configuration.FileDefine(f.widgetName(),f.type())<<'\n';
         if (Configuration.lookup_table)
   	 	f.Include(f.FileName(File_SUPPORT_HH),true);
   	 break;
      case File_FOO_GLADE_HH:
         Cxx::WriteCreation(f,tp);
      	 f << "//\n// DO NOT EDIT THIS FILE ! It was created using\n// " 
      	   << Configuration.commandline << "\n"
      	      "// for gtk " <<Configuration.gtk_version.mymajor <<'.'
			<< Configuration.gtk_version.myminor<<'.'
			<< Configuration.gtk_version.mymicro<<
	      " and gtkmm " <<Configuration.gtkmm_version.mymajor <<'.'
			<< Configuration.gtkmm_version.myminor<<'.'
			<< Configuration.gtkmm_version.mymicro<< "\n"
      	      "//\n// Please modify the corresponding derived classes in ";
      	 f << Configuration.FileName(f.widgetName(),File_FOO_HH) << " and"
      	   << Configuration.FileName(f.widgetName(),File_FOO_CC) << "\n"
// XXX f.type() or tp?
      	      "\n#ifndef "<<Configuration.FileDefine(f.widgetName(),f.type())<<"\n" 
      	      "#  define "<<Configuration.FileDefine(f.widgetName(),f.type())<<"\n\n";
      	 if (Configuration.has_accelerators)
      	 {  f.CppIf() << "!defined(GLADEMM_DATA)";
      	    f.DefineName("GLADEMM_DATA").DefineBody().EndLine();
      	    f.Include("gtk--/accelgroup.h");
      	    f.Definition().Class("GlademmData").StartBlock();
      	    f.Declaration(WriterBase::GtkPrefix()+"AccelGroup *accgrp");
      	    f.Public().Definition().FunctionName("GlademmData")
      	     	.FunctionArg(WriterBase::GtkPrefix()+"AccelGroup *ag").Construct("accgrp","ag")
      	     	.StartBlock().EndBlock();
      	    f.Definition().Funct_ReturnType(WriterBase::GtkPrefix()+"AccelGroup *")
      	    	.FunctionName("getAccelGroup")
      	    	.StartBlock().Statement("return accgrp").EndBlock();
      	    f.EndBlock();
      	    f.EndIf() << "GLADEMM_DATA";
      	    f.EndLine(); // needed for sanity
      	 }
      	 break;
      case File_FOO_GLADE_CC:
         Cxx::WriteCreation(f,tp);
      	 f << "//\n// DO NOT EDIT THIS FILE ! It was created using\n// " 
      	   << Configuration.commandline << "\n"
      	      "// for gtk " <<Configuration.gtk_version.mymajor <<'.'
			<< Configuration.gtk_version.myminor<<'.'
			<< Configuration.gtk_version.mymicro<<
	      " and gtkmm " <<Configuration.gtkmm_version.mymajor <<'.'
			<< Configuration.gtkmm_version.myminor<<'.'
			<< Configuration.gtkmm_version.mymicro<< "\n"
      	      "//\n// Please modify the corresponding derived classes in ";
      	 f << Configuration.FileName(f.widgetName(),File_FOO_CC) << "\n"
      	 	"\n";
      	 // TODO: we might include only the libgnome includes we need
      	 // to speed up compilation
      	 f.Include("config.h",true); // always a good idea !!!
	 if (Configuration.gettext_support)
	    f.Include("libgnome/libgnome.h"); // or gnome-i18n.h ?
         break;
      case File_FOO_CC:
         Cxx::WriteCreation(f,tp);
   	 f << "//\n// newer (non customized) versions of this file go to ";
   	 f << Configuration.FileName(f.widgetName(),f.type(),File_GLADE|File_NODIR) << "\n"
   	      "\n"
   	      "// This file is for your program, I won't touch it again!\n\n";
      	 f.Include("config.h",true); // always a good idea !!!
      	 if (Configuration.sample_code)
      	 {  f.Include("iostream",false);
      	    f << '\n';
      	 }
   	 break;
      default: assert(0);
   }	
}

void Cxx_Fileset::WriteFooter(WidgetFile &f,File_type tp)
{  switch(tp)
   {  case File_FOO_HH:
   	 f << "#endif\n";
   	 break;
      case File_FOO_GLADE_HH:
   	 f << "#endif\n";
   	 break;
      default: 
         break;
   }
}

void Cxx_Fileset::GenerateMapDefine(const WriterBase &wr, const Widget &w)
{  gh.DefineName("GMM_"+ Configuration.DefineName(w.Name()));
   gh.DefineBody() << "(glademm_get<" << wr.TypeName(w) 
   	<<" >(\"" << w.Name() << "\"))";
   gh.EndLine();
}

void Cxx_Fileset::AddToMap(const Widget &w, const std::string &pointer)
{  gc.Statement() << "glademm_set_Widget(\"" << w.Name() << "\", " << pointer << ')';
   gc.EndLine();
}

// this is a hack to give local names preference (only interesting with
// duplicate names). Perhaps we should test for duplicates and turn
// this function off if not needed.
void Cxx_Fileset::ReregisterLocal(const Widget &w) const
{  for (Widget::const_contained_iterator i(w.begin_contained());
	i!=w.end_contained();++i)
   {  WidgetMap[(*i).Name()]=(*i).getTagPtr();
   }
}

// this is not really a hack but an attempt to resolve this problem
// while not needing to pass Cxx_Fileset to WriterBase::Configure
// so we need it static - sorry

Cxx_Fileset::RadioGroupList_t Cxx_Fileset::RadioGroupList;

bool Cxx_Fileset::NeedToDeclareRadioGroup(const std::string &Name)
{  bool res(find(RadioGroupList.begin(),RadioGroupList.end(),Name)==RadioGroupList.end());
   if (res) RadioGroupList.push_back(Name);
   return res;
}

void Cxx_Fileset::ClearRadioGroups()
{  RadioGroupList.clear();
}

