// $Id: SystemFile.cc,v 1.10 2001/10/12 07:11:09 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1999 Adolf Petig GmbH. & Co. KG., written by Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "SystemFile.hh"
#include <cstdio>

SystemFile::~SystemFile()
{  close();
   free();
}

void SystemFile::close()
{  
// 2do: emit remembered lines?
   if (is_stringstream)
   {  *streamptr.os << char(0);
      if (remembered) remembered->remember(mystage,streamptr.os->str());
      streamptr.os->freeze(0);
      streamptr.os->seekp(0,std::ios::beg);
   }
   else if (streamptr.of) streamptr.of->close();
   remembered_lines.erase(remembered_lines.begin(),remembered_lines.end());
}

#if 0
void SystemFile::open(const Widget *w,File_type tp)
{  if (w) basename=w->Name(); // force duplication
   else basename="<null>";
   if (of) of->open(Configuration.FileName(basename,tp,File_NOREPLACE).c_str(),std::ios::out,
	tp==File_AUTOGEN_SH?0755:0644);
   else
   {  of=new std::ofstream(Configuration.FileName(basename,tp,File_NOREPLACE).c_str(),std::ios::out,
	tp==File_AUTOGEN_SH?0755:0644);
      tie(of);
   }
   filetype=tp;
   widget=w;
   has_requirements=false;
   if (!good()) perror(Configuration.FileName(basename,tp,File_NOREPLACE).c_str());
}
#endif

void SystemFile::write_remembered(unsigned int stage)
{  if ((stage<0) || (stage>=remembered_lines.size())) 
      return; // no data to print
   for (std::vector<std::string>::iterator i=remembered_lines[stage].begin();
            		i!=remembered_lines[stage].end();++i)
   {  *this<<(*i);
   }
   remembered_lines[stage].erase(remembered_lines[stage].begin(),
   					remembered_lines[stage].end());
}

#if 0
std::ostream &operator<<(std::ostream &o,const std::vector<std::string> x)
{  o << "(";
   for (std::vector<std::string>::const_iterator i=x.begin();i!=x.end();++i)
   {  o << (i!=x.begin() ? ", \"" : "\"") << (*i) << "\""; 
   }
   return o << ")";
}

std::ostream &operator<<(std::ostream &o,const SystemFile &f)
{ return o << '{'
     << " remembered_lines=" << f.remembered_lines << "}";
}
#endif

void SystemFile::Indent(int level)
{  while (level>8) { *this<<'\t'; level-=8; }
   if (!is_stringstream)
   {  if (streamptr.of && level) streamptr.of->write("        ",level);
   }
   else if (streamptr.os && level) streamptr.os->write("        ",level);
}

void SystemFile::open(const std::string &name, std::ios::openmode mode, int prot)
{  filename=name;
   if (is_stringstream)
   {  free();
      streamptr.of=0;
      is_stringstream=false;
   }
// mode is not portable ...
   if (streamptr.of) streamptr.of->open(name.c_str(),mode/*,prot*/);
   else
   {  streamptr.of=new std::ofstream(name.c_str(),mode/*,prot*/);
//      tie(of);
   }
}

SystemFile::SystemFile(const std::string &name,std::ios::openmode mode=std::ios::out, int prot=0664)
   : filename(name), is_stringstream(false), deallocate(true), 
   	remembered(0), mystage(0)
{  streamptr.of=new std::ofstream(name.c_str(),mode/*,prot*/);
//   tie(of);
}

void SystemFile::free()
{  if (is_stringstream)
   {  if (deallocate) delete streamptr.os;
      streamptr.os=0;
   }
   else
   {  if (deallocate) delete streamptr.of;
      streamptr.of=0;
   }
}

void SystemFile::prepare_stage(unsigned int stage) throw()
{  while (remembered_lines.size()<=stage) 
      remembered_lines.push_back(std::vector<std::string>());
}

void SystemFile::remember(unsigned int stage,const std::string &s) throw()
{  prepare_stage(stage);
   remembered_lines[stage].push_back(s); 
}
