// $Id: Widget_iterators.hh,v 1.17 2001/10/12 07:11:08 christof Exp $

// this file is included inside Widget.hh, never use it anywhere else

// new iterators:
// - internal subwidgets (depth)
// - contained widgets (depth)
// perhaps we need to construct a path !!! (e.g. xyz.ab)

#define WIDGET_CCI_DEBUG_ON_DEMAND true

class const_contained_iterator
{	typedef Tag::const_iterator T;
public:
	typedef forward_iterator_tag iterator_category;

	struct stack
	{  T first;
	   T second;
	   const Tag *third;
	   Subwidget fourth;
	   const Tag *fifth;
	   
	   stack(const T &f,const T &s,const Tag *w,Subwidget fo,const Tag *fi)
	   	: first(f), second(s), third(w), fourth(fo), fifth(fi) {}
	};
private:
	typedef const_contained_iterator _Self;
	T ti,end; // current, end
	const Tag *parent; // direct ancestor
	Subwidget sub; // this is the relation of parent to internal_determining_widget
	const Tag *internal_determining_widget; // ancestor
	
	std::list<stack> pushed;
	static const char * const type;
	// leaves_first or root_first
	InternalSelection internal; // whether we want internal widgets

	void dive();	
#ifdef WIDGET_CCI_DEBUG_ON_DEMAND
	bool print_debug;
#endif	
public:
#ifdef WIDGET_CCI_DEBUG_ON_DEMAND
	_Self &debug(bool on) { print_debug=on; return *this; }
#endif	
	bool acceptable() const;
	bool need_recurse() const;
	void normalize() { if (!acceptable()) ++(*this); }

	const_contained_iterator(const T &t,const Tag *parent,InternalSelection _internal=NoInternal, bool debug=false);
	_Self &operator++();
	_Self operator++(int)
	{  _Self tmp=*this;
	   ++(*this);
	   return tmp;
	}
	bool operator==(const _Self &i) const
	{  return i.ti==ti; }
	bool operator!=(const _Self &i) const
	{  return i.ti!=ti; }
	// ugly!
	const Widget operator *() const
	{  return Widget(*ti);
	}
	// returning a Widget* is not possible, so we return Tag*
	const Tag *operator->() const
	{  return &*ti; }
	const Tag *getWriterTag() const
	{  return internal_determining_widget; }
	Subwidget getSWType() const;
//	{  return sub; }
};

// iterator stuff
class const_iterator
{public:
	typedef forward_iterator_tag iterator_category;
private:
	typedef const_iterator _Self;
	typedef Tag::const_iterator T;
	T ti,end;
	const std::string type;
public:
	const_iterator(const T &t,const T &e,const std::string &st="widget")
		 : ti(t),end(e),type(st) {}
	_Self operator++(int)
	{  _Self tmp=*this;
	   if (ti!=end) ti=find(ti+1,end,type);
	   return tmp;
	}
	_Self &operator++()
	{  if (ti!=end) ti=find(ti+1,end,type);
	   return *this;
	}
	bool operator==(const _Self &i)
	{  return i.ti==ti; }
	bool operator!=(const _Self &i)
	{  return i.ti!=ti; }
	// ugly !
	const Widget operator *()
	{  return Widget(*ti);
	}
	Tag::const_iterator get_Tag_const_iterator()
	{  return ti;
	}
	// returning a Widget* is not possible, so we return Tag*
	const Tag *operator ->()
	{  return &*ti;
	}
#if 0	
	operator Tag::const_iterator()
	{  return ti;
	}
#endif
};

class iterator
{public:
	typedef forward_iterator_tag iterator_category;
private:
	typedef iterator _Self;
	typedef Tag::iterator T;
	T ti,end;
	const std::string type;
public:
	iterator(const T &t,const T &e,const std::string &st="widget")
		: ti(t),end(e),type(st) {}
	_Self operator++(int)
	{  _Self tmp=*this;
	   if (ti!=end) ti=find(ti+1,end,type);
	   return tmp;
	}
	_Self &operator++()
	{  if (ti!=end) ti=find(ti+1,end,type);
	   return *this;
	}
	bool operator==(const _Self &i)
	{  return i.ti==ti; }
	bool operator!=(const _Self &i)
	{  return i.ti!=ti; }
	// ugly!
	Widget operator *()
	{  return Widget(&*ti);
	}
	Tag::const_iterator get_Tag_iterator()
	{  return ti;
	}
	Tag &get_Tag()
	{  return *ti;
	}
	// returning a Widget* is not possible, so we return Tag*
	Tag *operator->()
	{  return &*ti; }
};
