// $Id: combo.cc,v 1.31 2001/11/05 15:28:20 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "combo.hh"
#include "../strsep.h"

static Gtk_Combo Gtk_Combo(false);

const std::string Gtk_Combo::TypeName(const Widget &w) const
{  return GtkPrefix()+"Combo";
}

const std::string Gtk_Combo::IncludeName(const Widget &w) const
{  return "gtk--/combo.h";
}

Gtk_Combo::Gtk_Combo(bool base_class_init)
{  if (!base_class_init) Writer["GtkCombo"]=this;
}

void Gtk_Combo::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   // work around gtk bug (see gbwidget.c:3584)
   // "GTK BUG WORKAROUND - a combo should manage the size of its entry."
   int width=w.getInt("width",-1);
   int height=w.getInt("height",-1);
   if (width!=-1 || height!=-1)
   {  f.Statement() << instance << "get_entry()->set_usize(" 
        << (width>16?width-16:-1) << ", " << height << ')';
   }
   bool case_sensitive=w.getBool("case_sensitive",true);
   if (case_sensitive)
      f.Statement() << instance << "set_case_sensitive(" << PRINT_BOOL(case_sensitive)
        << ')';
   bool use_arrows=w.getBool("use_arrows",true);
   if (!use_arrows)
      f.Statement() << instance << "set_use_arrows(" << PRINT_BOOL(use_arrows)
        << ')';
   bool use_arrows_always=w.getBool("use_arrows_always");
   if (use_arrows_always)
      f.Statement() << instance << "set_use_arrows_always(" << PRINT_BOOL(use_arrows_always) << ')';
   // items   
   if (w.hasTag("items")) // append them
   {  const std::string items(w.getString("items","<none>\n"));
      const std::string name(Configuration.InstanceName(w.Name()));
      char *buffer=(char*)alloca(items.size()+1);
      memcpy(buffer,items.c_str(),items.size()+1);
      char *token,*stringp=buffer;
      f.StartBlock().Declaration() << "const char * const items[]";
      f.Assignment() << "{ ";
      if ((token=strsep(&stringp,"\n")))
      {  f << Configuration.static_Translatable(token) << ", ";
      }
      while (stringp && (token=strsep(&stringp,"\n")))
      {  if (!stringp && !token[0]) // do not use the last empty string
            break;
         f << Configuration.static_Translatable(token) << ", ";
      }
      f << "0 }";
      // hmmm can we translate this?
      f.Statement() << instance << "set_popdown_strings(items)";
      f.EndBlock();
   }
   // configure subwidget (entry) 
   // - why is this needed (why not automatically?) CP 20001012
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).ChildName()=="GtkCombo:entry")
         LookupWriter("GtkEntry").Configure((*i),f,instance+"get_entry()->");
   }
}

Subwidget Gtk_Combo::IsSubwidget(const Widget &w,const Widget &ch) const
{  if (ch.ChildName()=="GtkCombo:entry") return is_Subwidget_only;
   return not_Subwidget;
}

const std::string Gtk_Combo::InternalInstance(const Widget &parent,const Widget &w2) const
{  if (w2.ChildName()=="GtkCombo:entry") return "get_entry()->";
   return Parent::InternalInstance(parent,w2);
}
