// $Id: dialog.cc,v 1.29 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "window.hh"

class Gtk_Dialog : public Gtk_Window
{public:
	typedef Gtk_Window Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Dialog();
	virtual Subwidget IsSubwidget(const Widget &parent,const Widget &w2) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const 
	{ f.FunctionArg(); }
	virtual bool NeedExplicitCtor(const Widget &w) const
	{ return false; }
	virtual const std::string InternalInstance(const Widget &parent,const Widget &w2) const;
};

static Gtk_Dialog Gtk_Dialog;

const std::string Gtk_Dialog::TypeName(const Widget &w) const
{  return GtkPrefix()+"Dialog";
}

const std::string Gtk_Dialog::IncludeName(const Widget &w) const
{  return "gtk--/dialog.h";
}

Gtk_Dialog::Gtk_Dialog()
{  Writer["GtkDialog"]=this;
}

Subwidget Gtk_Dialog::IsSubwidget(const Widget &w,const Widget &ch) const
{  const std::string chn(ch.ChildName());
   if (chn=="Dialog:vbox") return is_Subwidget;
   if (chn=="Dialog:action_area") return is_Subwidget_only;
   if (chn!="") {  std::cerr << "Dialog: Unexpected child name '" << chn << "'\n"; }
   return not_Subwidget;
}

const std::string Gtk_Dialog::InternalInstance(const Widget &parent,const Widget &w2) const
{  const std::string chn(w2.ChildName());
   if (chn=="Dialog:vbox") return "get_vbox()->";
   if (chn=="Dialog:action_area") return "get_action_area()->";
   return Parent::InternalInstance(parent,w2);
}

