// $Id: editable.cc,v 1.4 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "editable.hh"

const std::string Gtk_Editable::SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype) const
{  if (signal=="changed" || signal=="activate" || signal=="cut_clipboard"
	|| signal=="copy_clipboard" || signal=="paste_clipboard") return "";
   if (signal=="insert_text") return "const gchar *text, gint length, gint *position";
   if (signal=="delete_text") return "gint start_pos, gint end_pos";
   if (signal=="set_editable") return "gboolean is_editable";
   if (signal=="move_cursor" || signal=="move_page") return "gint x, gint y";
   if (signal=="move_word") return "gint n";
   if (signal=="move_to_row" || signal=="move_to_column") return "gint row";
   if (signal=="kill_char" || signal=="kill_word" || signal=="kill_line") return "gint direction";
   return Parent::SignalHandlerArgs(w,signal,rettype);
}

bool Gtk_Editable::isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
{  if (WriterBase::isInternalMethod("gtk_editable_",w,method,args,scope,is_signal)) return true;
   if (((method=="changed" || method=="activate" || method=="cut_clipboard" 
   		|| method=="copy_clipboard" || method=="paste_clipboard") 
   			&& !args.size())
        || (method=="insert_text" 
        && matches("const gchar\\ *\\ \\_,\\ gint \\_,\\ gint\\ *\\ \\_",args))
        || ((method=="delete_text" || method=="move_cursor" || method=="move_page")
        		&& matches("gint \\_,\\ gint \\_",args))
        || ((method=="move_word" || method=="move_to_row" || method=="move_to_column"
        	|| method=="kill_char" || method=="kill_word" || method=="kill_line") 
        		&& matches("gint \\_",args))
        || (method=="set_editable" && matches("gboolean \\_",args)))
   {  scope=Gtk_Widget::TypeName(w);
      is_signal=true;
      return true;
   }
   if ((method=="select_region" && matches("gint\\ \\_,gint\\ \\_",args))
   	|| (method=="delete_selection" && !args.size()))
   {  scope=Gtk_Widget::TypeName(w);
      is_signal=false;
      return true;
   }
   return Parent::isInternalMethod(w,method,args,scope,is_signal);
}
