// $Id: entry.cc,v 1.22 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "entry.hh"

static Gtk_Entry Gtk_Entry(false);

const std::string Gtk_Entry::TypeName(const Widget &w) const
{  return GtkPrefix()+"Entry";
}

const std::string Gtk_Entry::IncludeName(const Widget &w) const
{  return "gtk--/entry.h";
}

Gtk_Entry::Gtk_Entry(bool base_class_init)
{  if (!base_class_init) Writer["GtkEntry"]=this;
}

void Gtk_Entry::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   int position(w.getInt("position",0));
   if (position)
      f.Statement() << instance << "set_position(" << position << ')';
   bool text_visible(w.getBool("text_visible",true));
   if (!text_visible)
      f.Statement() << instance << "set_visibility(" << PRINT_BOOL(text_visible) << ')';
   bool editable(w.getBool("editable",true));
   f.Statement() << instance << "set_editable(" << PRINT_BOOL(editable) << ')';
   // max length ... seems to be not in gtkmm
   std::string text(w.getString("text",""));
   if (text.size())
      f.Statement() << instance << "set_text(" << Configuration.Translatable(text) << ')';
}

bool Gtk_Entry::isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
{  const char *prefix("gtk_entry_");
   const int plen(sizeof(prefix)-1);
   if (!strncmp(prefix,method.c_str(),plen))
      method=std::string(method.c_str()+plen);
   if (((method=="set_text" || method=="set") && matches("const std::string &\\_",args))
	|| (method=="append_text" && matches("const std::string &\\_",args))
	|| (method=="prepend_text" && matches("const std::string &\\_",args))
	|| (method=="set_position" && (matches("int\\ \\_",args) || matches("gint\\ \\_",args)))
	|| (method=="set_max_length" && (matches("int\\ \\_",args) || matches("gint\\ \\_",args)))
	|| (method=="set_visibility" && matches("bool\\ \\_",args)))
   {  scope=Gtk_Entry::TypeName(w);
      is_signal=false;
      return true;
   }
   return Parent::isInternalMethod(w,method,args,scope,is_signal);
}

