// $Id: optionmenu.cc,v 1.34 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "button.hh"
#include "../strsep.h"

class Gtk_OptionMenu : public Gtk_Button
{	static const char * const MenuTags;
	static Tag menu;
	
	const Widget get_menu(const Widget &w) const;
public:
	typedef Gtk_Button Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_OptionMenu();
//	bool CantMemberConstruct(const Widget &w) const;
	virtual void GCInclude(const Widget &w, CxxFile &f) const;
	virtual void AdditionalMemberVars(const Widget &w,CxxFile &f,bool container=false) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
};

static Gtk_OptionMenu Gtk_OptionMenu;

const std::string Gtk_OptionMenu::TypeName(const Widget &w) const
{  return GtkPrefix()+"OptionMenu";
}

const std::string Gtk_OptionMenu::IncludeName(const Widget &w) const
{  return "gtk--/optionmenu.h";
}

Gtk_OptionMenu::Gtk_OptionMenu()
{  Writer["GtkOptionMenu"]=this;
}

void Gtk_OptionMenu::GCInclude(const Widget &w, CxxFile &f) const
{  if (w.hasTag("items")) 
   {  f.Include("gtk--/menu.h");
      f.Include("gtk--/menuitem.h");
   }
   Parent::GCInclude(w,f);
}

void Gtk_OptionMenu::AdditionalMemberVars(const Widget &w,CxxFile &f,bool container=false) const
{  Parent::AdditionalMemberVars(w,f,container);
   if (w.hasTag("items") && Configuration.optionmenu_create_enum)
   {  const std::string name(Configuration.InstanceName(w.Name()));
      const std::string visibility(w.getString("cxx_visibility","private"));
      const std::string items(w.getString("items","<none>\n"));      
      if (visibility!="private" && items.size())
      {  if (visibility=="public") f.Public();
         else f.Protected();
         
         // weird but works perfectly
         f.Definition() << "struct " << name;
         f.StartBlock();
         f.Definition() << "enum enum_t ";
         f.StartBlock();
         char *buffer=(char*)alloca(items.size()+1);
         memcpy(buffer,items.c_str(),items.size()+1);
         char *token,*stringp=buffer;
         while ((token=strsep(&stringp,"\n")))
         {  if (!stringp && !token[0]) // do not use the last empty string
               break;
            if (!*token) f << "__empty__, ";
            else f << Naming::ToCIdentifier(token) << ", ";
         }
         f.EndBlock().EndBlock();
      }
   }
}

void Gtk_OptionMenu::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   // XXX: Configure menu???
   if (w.hasTag("items")) // append them
   {  const std::string items(w.getString("items","<none>\n"));
      const std::string name(Configuration.InstanceName(w.Name()));
      char *buffer=(char*)alloca(items.size()+1);
      memcpy(buffer,items.c_str(),items.size()+1);
      char *token,*stringp=buffer;
      f.StartBlock();
      f.Declaration() << GtkPrefix() << "Menu *_m(manage(new "
      		<< GtkPrefix() << "Menu()))";
      f.Declaration() << GtkPrefix() << "MenuItem *_mi";
      int index=0;
      while ((token=strsep(&stringp,"\n")))
      {  if (!stringp && !token[0]) // do not use the last empty string
            break;
         f.Statement() << "_mi = manage(new " << GtkPrefix() << "MenuItem(" 
         	<< Configuration.Translatable(token) << "))";
         f.Statement() << "_m->append(*_mi)";
         f.Statement() << "_mi->show()";
         if (Configuration.optionmenu_strings)
            f.Statement() << "_mi->set_user_data((gpointer)" 
            	<< Configuration.CString_WithQuotes(token) << ')';
         else
            f.Statement() << "_mi->set_user_data((gpointer)" << index << ')';
         index++;
      }
      f.Statement() << name << "->set_menu(*_m)";
      int initial_choice=w.getInt("initial_choice",0);
      f.Statement() << name << "->set_history("<<initial_choice <<')';
      f.EndBlock();
   }
}

