// $Id: safemap.hh,v 1.6 2001/10/12 07:11:09 christof Exp $

#include <map>
//#include <cstdio>

// The reason for this class is that the execution order of static
// class initializers is unpredictable.
// Since many static ctors used the map before it was constructed I wrapped
// it in this class.

template <class _Key,class _Tp> 
 class safemap
{public:
  typedef _Key key_type;
  typedef _Tp data_type;
  typedef _Tp mapped_type;
private:
  typedef std::map<_Key,_Tp> _Rep_type;
public:
  typedef typename _Rep_type::value_type value_type;
  typedef typename _Rep_type::pointer pointer;
  typedef typename _Rep_type::const_pointer const_pointer;
  typedef typename _Rep_type::reference reference;
  typedef typename _Rep_type::const_reference const_reference;
  typedef typename _Rep_type::iterator iterator;
  typedef typename _Rep_type::const_iterator const_iterator;
  typedef typename _Rep_type::reverse_iterator reverse_iterator;
  typedef typename _Rep_type::const_reverse_iterator const_reverse_iterator;
  typedef typename _Rep_type::size_type size_type;
  typedef typename _Rep_type::difference_type difference_type;

private:
	_Rep_type *m;
	
	void init() { if (!m) m=new _Rep_type; }
public:
	// NOTICE: member functions might got called before we
	//         enter the ctor, NEVER touch m unconditionally here
	safemap() { init(); } 
	~safemap() { delete m; m=0; }
	
  iterator begin() { init(); return m->begin(); }
  const_iterator begin() const { init(); return m->begin(); }
  iterator end() { init(); return m->end(); }
  const_iterator end() const { init(); return m->end(); }
  reverse_iterator rbegin() { init(); return m->rbegin(); }
  const_reverse_iterator rbegin() const { init(); return m->rbegin(); }
  reverse_iterator rend() { init(); return m->rend(); }
  const_reverse_iterator rend() const { init(); return m->rend(); }
  bool empty() const { init(); return m->empty(); }
  size_type size() const { init(); return m->size(); }
  size_type max_size() const { init(); return m->max_size(); }
  _Tp& operator[](const key_type& k) { init(); return (*m)[k]; }
  iterator find(const key_type& __x) { init(); return m->find(__x); }
};
