// $Id: scrolledwindow.cc,v 1.21 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gtk_ScrolledWindow : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_ScrolledWindow();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
};

static Gtk_ScrolledWindow Gtk_ScrolledWindow;

const std::string Gtk_ScrolledWindow::TypeName(const Widget &w) const
{  return GtkPrefix()+"ScrolledWindow";
}

const std::string Gtk_ScrolledWindow::IncludeName(const Widget &w) const
{  return "gtk--/scrolledwindow.h";
}

Gtk_ScrolledWindow::Gtk_ScrolledWindow()
{  Writer["GtkScrolledWindow"]=this;
}

void Gtk_ScrolledWindow::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
//   std::string shadow_type(w.getString("shadow_type","GTK_SHADOW_NONE"));
//   and what to do with this?
//   f.Statement() << instance << "set_shadow_type(" << shadow_type << ')';
   std::string hscrollbar_policy(w.getString("hscrollbar_policy","GTK_POLICY_AUTOMATIC"));
   std::string vscrollbar_policy(w.getString("vscrollbar_policy","GTK_POLICY_AUTOMATIC"));
   f.Statement() << instance << "set_policy(" << hscrollbar_policy
   	<< ", " << vscrollbar_policy << ')';
   // I don't know how to set update policies ... sorry
   // glade does this via 
   // gtk_range_set_update_policy (GTK_RANGE (GTK_SCROLLED_WINDOW (scrolledwindow1)
   // ->hscrollbar), GTK_POLICY_NEVER);
}
