// $Id: table.cc,v 1.27 2001/10/11 14:07:25 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gtk_Table : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Table();
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
	virtual void AddChild(const Widget &w,CxxFile &f,const std::string &instance) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
};

static Gtk_Table Gtk_Table;

const std::string Gtk_Table::TypeName(const Widget &w) const
{  return GtkPrefix()+"Table";
}

const std::string Gtk_Table::IncludeName(const Widget &w) const
{  return "gtk--/table.h";
}

Gtk_Table::Gtk_Table()
{  Writer["GtkTable"]=this;
}

void Gtk_Table::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg() << w.getInt("rows",2);
   f.FunctionArg() << w.getInt("columns",2);
   f.FunctionArg() << PRINT_BOOL(w.getBool("homogeneous",true));
}

void Gtk_Table::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{  const ChildParamList ch=w.get_Child_params();
   int left_attach=ch.getInt("left_attach",-1);
   int right_attach=ch.getInt("right_attach",-1);
   int top_attach=ch.getInt("top_attach",-1);
   int bottom_attach=ch.getInt("bottom_attach",-1);
   std::string xoptions("0"),yoptions("0");
   if (ch.getBool("xexpand",true)) xoptions+="|GTK_EXPAND";
   if (ch.getBool("xshrink",false)) xoptions+="|GTK_SHRINK";
   if (ch.getBool("xfill",true)) xoptions+="|GTK_FILL";
   if (ch.getBool("yexpand",true)) yoptions+="|GTK_EXPAND";
   if (ch.getBool("yshrink",false)) yoptions+="|GTK_SHRINK";
   if (ch.getBool("yfill",true)) yoptions+="|GTK_FILL";
   int xpad=ch.getInt("xpad",0);
   int ypad=ch.getInt("ypad",0);
   
   // strip leading '0|'
   if (xoptions.size()>1) xoptions=std::string(xoptions.begin()+2,xoptions.end());
   if (yoptions.size()>1) yoptions=std::string(yoptions.begin()+2,yoptions.end());
   if (xoptions=="GTK_FILL|GTK_EXPAND" 
       && yoptions=="GTK_FILL|GTK_EXPAND" && !xpad && !ypad)
         f.Statement() << instance << "attach(" << Reference(w) << ", "
   	      << left_attach << ", " << right_attach << ", " << top_attach << ", " 
   	      << bottom_attach << ')';
   else
      f.Statement() << instance << "attach(" 
        << Reference(w) << ", " << left_attach << ", " << right_attach 
        << ", " << top_attach << ", " << bottom_attach << ", " 
        << xoptions << ", " << yoptions << ", " << xpad << ", " << ypad << ')';
}

void Gtk_Table::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   int row_spacing=w.getInt("row_spacing");
   if (row_spacing)
      f.Statement() << instance << "set_row_spacings(" << row_spacing << ')';
   int column_spacing=w.getInt("column_spacing");
   if (column_spacing)
      f.Statement() << instance << "set_col_spacings(" << column_spacing << ')';
}

