// $Id: imagemenuitem.cc,v 1.13 2002/11/04 11:31:03 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2002  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "menuitem.hh"

class Gtk_ImageMenuItem : public Gtk_MenuItem
{public:
	typedef Gtk_MenuItem Parent;
	virtual const std::string TypeName(const Widget &w) const
	{  return GtkPrefix()+"ImageMenuItem"; }
	virtual const std::string IncludeName(const Widget &w) const
	{  return Configuration.GtkmmIncludePath()+"imagemenuitem.h"; }
	virtual void GCInclude(const Widget &w, CxxFile &f) const
	{  Parent::GCInclude(w,f);
	   // FIXME: Under recent versions of gtkmm, the underlying
	   // gtk header is NOT automatically included, and it IS
	   // needed if we are to use casting macros such as
	   // GTK_IMAGE_MENU_ITEM
	   f.Include("gtk/gtkimagemenuitem.h");
	}
	Gtk_ImageMenuItem();
	// hmm what is this for ? CP
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
//        virtual void MenuElemCreation(const Widget &w, CxxFile &f) const;
        virtual std::string MenuElemName(const Widget &w) const;
        virtual void MenuElemArgs(const Widget &w, CxxFile &f) const;
//	const std::string GtkName(const Widget &w) const
//	{  return "GtkImageMenuItem"; }
//	const std::string GtkCast(const Widget &w) const
//	{  return "GTK_IMAGE_MENU_ITEM"; }
	virtual void ApplyPreferences(Tag &t) const;
};

static Gtk_ImageMenuItem Gtk_ImageMenuItem;

Gtk_ImageMenuItem::Gtk_ImageMenuItem()
{  Writer["GtkImageMenuItem"]=this;
}

std::string Gtk_ImageMenuItem::MenuElemName(const Widget &w) const
{  if (!w.getBoolProperty("use_stock")) return MenuElemPrefix()+"ImageMenuElem";
   return MenuElemPrefix()+"StockMenuElem";
}

void Gtk_ImageMenuItem::MenuElemArgs(const Widget &w, CxxFile &f) const
{  if (!w.getBoolProperty("use_stock"))
   {  Parent::MenuElemArgs0(w,f);
      if(w.hasChildren())
      {  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
         {  if (Widget(*i).Class()=="GtkImage") f.FunctionArg() << Reference(*i);
            else if (Widget(*i).Class()!="GtkMenu") 
               std::cerr << "Gtk_ImageMenuItem "<< w.Name()<<": strange child type "
               	<<Widget(*i).Class()<<'\n';
         }
      }
      else std::cerr << "Gtk_ImageMenuItem: no image found\n";
   }
   else
   {  std::string stock=w.getProperty("label");
      f.FunctionArg() << "Gtk::StockID(" << Configuration.CString_WithQuotes(stock) << ')';
   }
   Parent::MenuElemArgsSub(w,f);
}

void Gtk_ImageMenuItem::ApplyPreferences(Tag &t) const
{  Widget w(&t);
   if (w.hasProperty("stock")) // old glade-2 version
   {  w.setProperty("label",w.getProperty("stock"));
      w.setProperty("use_stock","True");
   }
   if (GTKMM1)
   {  static_cast<GladeTag*>(&t)->setWidgetType("GtkMenuItem");
      LookupWriter(w).ApplyPreferences(t);
   }
   else
      Parent::ApplyPreferences(t);
}
