// $Id: gnome_appbar.cc,v 1.5 2002/11/18 11:46:09 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "box.hh"

class Gnome_AppBar : public Gtk_HBox
{public:
	typedef Gtk_HBox Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gnome_AppBar();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const;
};

static Gnome_AppBar Gnome_AppBar;

static std::string map_preferences(const std::string &pt)
{  if (GNOME2) {
      if (pt == "GNOME_PREFERENCES_USER")
	 return "Gnome::UI::PREFERENCES_USER";
      if (pt == "GNOME_PREFERENCES_ALWAYS")
	 return "Gnome::UI::PREFERENCES_ALWAYS";
      return "Gnome::UI::PREFERENCES_NEVER";
   }
   return pt;
}

void Gnome_AppBar::ConstructionArgs(Widget const &w, CxxFile &f) const
{  bool has_progress(w.getBoolProperty("has_progress"));
   bool has_status(w.getBoolProperty("has_status"));
   std::string interactivity(map_preferences(w.getProperty("interactivity","GNOME_PREFERENCES_NEVER")));
#warning is interactivity the correct name?   
   f.FunctionArg() << PRINT_BOOL(has_progress) << ", " 
   	<< PRINT_BOOL(has_status) << ", " << interactivity;
}

const std::string Gnome_AppBar::TypeName(const Widget &w) const
{  return GnomeUIPrefix()+"AppBar";
}

const std::string Gnome_AppBar::IncludeName(const Widget &w) const
{  return Configuration.GnomeUImmIncludePath()+"appbar.h";
}

Gnome_AppBar::Gnome_AppBar()
{  Writer["GnomeAppBar"]=this;
}

void Gnome_AppBar::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   // set_status
   // set_default
#warning some configurations missing
}

#warning signals (clear_prompt(), user_response()) missing
