.TH MINMAX l "18 Apr 2001"
.SH NAME
minmax \- Find extreme values in data tables
.SH SYNOPSIS
\fBminmax\fP [ \fIfiles\fP] [ \fB\-C\fP ] [ \fB\-D\fP ] [ \fB\-H\fP[\fInrec\fP] ] [ \fB\-I\fP\fIdx\fP[/\fIdy\fP] ] [ \fB\-L\fP ] [ \fB\-M\fP[\fIflag\fP] ]
[ \fB\-:\fP ] [ \fB\-bi\fP[\fBs\fP][\fIn\fP] ]
.SH DESCRIPTION
\fBminmax\fP reads its standard input [or from files] and finds the
extreme values in each of the columns. It recognizes NaNs and
will print warnings if the number of columns vary from record to record.
As an option, \fBminmax\fP will find the extent of the first two columns rounded
up and down to the nearest multiple of dx/dy. This output will be in the form
\fB\-R\fP\fIw/e/s/n\fP which can be used directly in the command line for other programs, or simply in column form.
.TP
\fIxyzfile\fP
ASCII [or binary, see \fB\-b\fP] file(s) holding a fixed number of data columns.
.SH OPTIONS
.TP
.B \-C
Report the min/max values per column in separate columns [Default uses <min/max> format]
.TP
.B \-D
Sets longitude discontinuity to the Dateline (-180/+180) [Default is Greenwich (0-360)].
Requires \fB\-L\fP.
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults file. If used, \fBGMT\fP default is 1 header record.
.TP
.B \-I
Report the min/max of the first two columns to the nearest multiple of dx and dy,
and output this in the form -Rw/e/s/n (unless \fB\-C\fP is set).
.TP
.B \-L
Indicates that the x column contains longitudes, which may be periodic in 360 degrees [Default assumes no periodicity].
.TP
.B \-M
Multiple segment file(s). Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output. [Default is (longitude,latitude)].
Applies to geographic coordinates only.
Only works when \fB\-I\fP is selected.
.TP
.B \-bi
Selects binary input. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
[Default is 2 input columns].
.SH EXAMPLES
To find the extreme values in the file ship_gravity.xygd, try
.br
.sp
minmax ship_gravity.xygd
.br
.sp
Output should look like
.br
.sp
ship_gravity.xygd: N = 6992 <326.125/334.684> <-28.0711/-8.6837> <-47.7/177.6> <0.6/3544.9>
.br
.sp
To find the extreme values in the file track.xy to the nearest 5 units and use this
region to draw a line using psxy, try
.br
.sp
psxy `minmax \fB\-I\fP5 track.xy` track.xy \fB\-Jx\fP1 \fB\-B\fP5 \fB\-P\fP > track.ps
.br
.sp
To find the min and max values for each column, but rounded to integers, try
.br
.sp
minmax junkfile \fB\-C \-I\fP1
.SH "SEE ALSO"
.IR gmt (l)
