------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2003 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-servers.adb,v 1.5 2003/10/28 06:17:23 vagul Exp $

with Interfaces.C;
with OCI.Thread;

package body OCI.Thick.Servers is

   ------------
   -- Attach --
   ------------

   function Attach (Name : String) return Server is
      H  : OCIHandle := Alloc_Handle (Thread.Environment, OCI_HTYPE_SERVER);
      Rc : SWord := OCIServerAttach
                      (OCIServer (H),
                       Thread.Error,
                       Interfaces.C.To_C (Name),
                       Name'Length);
   begin
      Check_Error (RC);
      return (RF.Controlled_Reference with
              Handle      => H,
              Environment => Thread.Synch.Environment);
   exception
      when LIB_ERROR =>
         Free (H, OCI_HTYPE_SERVER);
         raise;
   end Attach;

   -----------
   -- Break --
   -----------

   procedure Break (It : Server) is
      Rc : SWord := OCIBreak (Handle (It), Thread.Error);
   begin
      Check_Error (RC);
   end Break;

   -------------
   -- Destroy --
   -------------

   procedure Destroy (It : in out Server) is
      Rc : SWord;
      use type OCI.Lib.OCIHandle;
   begin
      if It.Handle /= Empty_Handle then
         Rc := OCIServerDetach (OCIServer (It.Handle), Thread.Error);
         Free (It.Handle, OCI_HTYPE_SERVER);
      end if;
   end Destroy;

   -----------
   -- Reset --
   -----------

   procedure Reset (It : Server) is
      Rc : SWord := OCIReset (Handle (It), Thread.Error);
   begin
      Check_Error (RC);
   end Reset;

   --------------------
   -- Server_Version --
   --------------------

   function Server_Version (Item : in Server) return String is
      use type Ub4;
      Buff : aliased Text := (0..511 => c.nul);
      RC   : SWord := OCIServerVersion
              (hndlp    => Item.Handle,
               errhp    => Thread.Error,
               bufp     => CStr.To_Chars_Ptr (Buff'Unchecked_Access),
               bufsz    => buff'Length - 1,
               hndltype => OCI_HTYPE_SERVER);
   begin
      Check_Error (RC);
      return C.To_Ada (Buff);
   end Server_Version;

   ------------------
   -- Set_Blocking --
   ------------------

   procedure Set_Blocking (Item : in out Server; Mode : in Boolean) is
   begin
      Set_Attr
        (Item.Handle,
         OCI_HTYPE_SERVER,
         Boolean'Pos (not Mode),
         OCI_ATTR_NONBLOCKING_MODE);
   end Set_Blocking;

end OCI.Thick.Servers;

