/*
 * GPG Keys 
 * cdlgproperties.h
 * (c) 2001 Peter Mathiasson <peter@mathiasson.nu>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation
 */

#ifndef __CDLGPROPERTIES_H__
#define __CDLGPROPERTIES_H__ 

#include <qdialog.h>

class QListBox;
class QTextEdit;
class QWidgetStack;
class QTabWidget;
class QComboBox;

class CDlgProperties : public QDialog
{
    Q_OBJECT

public:
    CDlgProperties( QWidget* parent = 0 );

public slots:
    void selectFont();
    void currentChanged( QWidget* );
    void selectionChanged();
    void saveSettings();

private:
    int getStartOption();
    void createWidget( int id );
    void fillComboBoxes( QComboBox *comboBox, int id );

    QListBox *listBox;
    QTextEdit *textEdit;
    QWidgetStack *widgetStack;
    QTabWidget *tabWidget;

};

#endif //__CDLGPROPERTIES_H__
