// -*- C++ -*-
// --------------------------------------------------------------------
// Snapping.
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPESNAP_H
#define IPESNAP_H

#include "ipegeo.h"

// --------------------------------------------------------------------

class IpePage;

class IPE_EXPORT IpeSnapData {
public:
  //! The different snap modes as bitmasks.
  enum TSnapModes { ESnapNone = 0,
		    ESnapVtx = 1, ESnapBd = 2, ESnapInt = 4,
		    ESnapGrid = 8, ESnapAngle = 0x10,
		    ESnapAuto = 0x20 };

  int iSnap;              //!< Activated snapping modes (TSnapModes)
  bool iGridVisible;      //!< Is the grid visible?
  int iGridSize;          //!< Snap grid spacing.
  double iAngleSize;      //!< Angle for angular snapping.
  int iSnapDistance;      //!< Snap distance (in pixels).
  int iSelectDistance;    //!< Select distance (in pixels).
  bool iWithAxes;         //!< Show coordinate system?
  IpeVector iOrigin;      //!< Origin of coordinate system
  IpeAngle iDir;          //!< Direction of x-axis

  bool IntersectionSnap(IpeVector &pos, const IpePage *page,
			double snapDist) const;
  bool SnapAngularIntersection(IpeVector &pos, const IpeLine &l,
			       const IpePage *page,
			       double snapDist) const;
  bool SimpleSnap(IpeVector &pos, const IpePage *page, double snapDist) const;
  bool Snap(IpeVector &pos, const IpePage *page, double snapDist,
	    IpeVector *autoOrg = 0) const;
  IpeLine GetLine(const IpeVector &mouse, const IpeVector &base) const;
  bool SetEdge(const IpeVector &pos, const IpePage *page);
};

// --------------------------------------------------------------------
#endif
