/*
 * DSI utilities
 *
 * Copyright (C) 2010-2020 Sebastiano Vigna
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Lesser General Public License as published by the Free
 *  Software Foundation; either version 3 of the License, or (at your option)
 *  any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

package it.unimi.dsi.io;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.junit.Test;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.lang.MutableString;

public class OfflineIterableTest {
	public void doIt(final String[] strings) throws IOException {
		final OfflineIterable.Serializer<MutableString,MutableString> stringSerializer = new OfflineIterable.Serializer<MutableString,MutableString>() {
			@Override
			public void read(final DataInput dis, final MutableString x) throws IOException {
				x.readSelfDelimUTF8((InputStream)dis);
			}
			@Override
			public void write(final MutableString x, final DataOutput dos) throws IOException {
				x.writeSelfDelimUTF8((OutputStream)dos);
			}
		};
		final OfflineIterable<MutableString,MutableString> stringIterable = new OfflineIterable<>(stringSerializer, new MutableString());
		for (final String s: strings)
			stringIterable.add(new MutableString(s));
		ObjectIterator<String> shouldBe = ObjectIterators.wrap(strings);
		for (final MutableString m: stringIterable)
			assertEquals(new MutableString(shouldBe.next()), m);
		assertFalse(shouldBe.hasNext());

		// Let's do it again.
		stringIterable.clear();
		for (final String s: strings)
			stringIterable.add(new MutableString(s));
		shouldBe = ObjectIterators.wrap(strings);
		for (final MutableString m: stringIterable)
			assertEquals(new MutableString(shouldBe.next()), m);
		assertFalse(shouldBe.hasNext());

		stringIterable.close();
		stringIterable.close(); // Twice, to test for safety
	}

	@Test
	public void testSimple() throws IOException {
		doIt(new String[] { "this", "is", "a", "test" });
	}

	@Test
	public void testEmpty() throws IOException {
		doIt(new String[0]);
	}
}
