/* This file is part of the KDE project
   Copyright (C) 2006-2007 KovoKs <info@kovoks.nl>
   Copyright (C) 2007 Frode M. Døving <frode@lnix.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#include <kapplication.h>
#include <krun.h>
#include <klocale.h>
#include <qca.h>
#include <kwallet.h>
using KWallet::Wallet;
#include "../libkmime/kmime_headers.h"
#include "global.h"

namespace Mailody {

Global *Global::m_instance = 0;

Global::Global( QObject *parent, const char *name )
    : QObject( parent, name )
{}

Global::~Global()
{}

Global* Global::instance()
{
    if ( !m_instance )
        m_instance = new Global();
    return m_instance;
}


QStringList Global::identities( bool refresh )
{
    static QStringList identities;
    if (!identities.count()|| refresh)
    {
        identities.clear();
        QStringList groups = kapp->config()->groupList();
        QStringList::iterator its = groups.begin();
        while ( its != groups.end() )
        {
            if ((*its).startsWith("identity_"))
                identities.append((*its).mid(9));
            ++its;
        }
    }
    return identities;
}

bool Global::myEmail( const QString& email, bool refresh )
{
    static QStringList emails;
    QStringList identities = Global::identities(refresh);
    if (refresh || !emails.count())
    {
        emails.clear();
        QStringList::iterator its = identities.begin();
        while ( its != identities.end() )
        {
            KConfig* config = kapp->config();
            config->setGroup("identity_" + (*its));
            emails.append(config->readEntry("emailAddress"));
            ++its;
        }
    }

    QStringList::iterator its = emails.begin();
    while ( its != emails.end() )
    {
        if (email.find(*its) != -1)
            return true;
       ++its;
    }

    return false;
}

QString Global::getIdentityForEmail( const QString& email )
{
    QStringList identities = Global::identities();
    QStringList::iterator its = identities.begin();
    while ( its != identities.end() )
    {
        KConfig* config = kapp->config();
        config->setGroup("identity_" + (*its));
        if (email.find(config->readEntry("emailAddress")) != -1)
            return (*its);
        ++its;
    }
    return QString::null;
}

bool Global::cryptoConnectionSupported()
{
    return QCA::isSupported(QCA::CAP_TLS);
}

void Global::convertOldSmtpToIdentities()
{
    kdDebug() << k_funcinfo << endl;
    KConfig* config = kapp->config();
    config->setGroup("General");
    QString server = config->readEntry("smtpServer");
    QString name = config->readEntry("fullName");
    QString email = config->readEntry("emailAddress");
    QString user = config->readEntry("smtpUserName");
    int safe = config->readNumEntry("safeSMTP",0);
    bool needAuth = config->readBoolEntry("smtpNeedAuth",false);

    config->deleteEntry("smtpServer");
    config->deleteEntry("fullName");
    config->deleteEntry("emailAddress");
    config->deleteEntry("smtpUserName");
    config->deleteEntry("safeSMTP");
    config->deleteEntry("smtpNeedAuth");

    config->setGroup("identity_" + i18n("Account"));
    config->writeEntry("smtpServer", server );
    config->writeEntry("fullName", name );
    config->writeEntry("emailAddress", email );
    config->writeEntry("smtpUserName", user );
    config->writeEntry("safeSMTP", safe );
    config->writeEntry("smtpNeedAuth", needAuth );

    config->sync();

    QString pass;
    Wallet* wallet = Wallet::openWallet(Wallet::NetworkWallet());
    if (wallet && wallet->isOpen())
    {
        if (!wallet->hasFolder("mailody"))
            wallet->createFolder( "mailody" );

        wallet->setFolder( "mailody" );
        wallet->readPassword("smtpAccount1", pass);
        wallet->removeEntry("smtpAccount1");
        wallet->writePassword("smtpidentity_" + i18n("Account"), pass);
    }

}

void Global::timing(const QString& text, struct timeval tv1, struct timeval tv2)
{
    kdDebug() << "Time: "
              << text + ": "
              << (((tv2.tv_sec-tv1.tv_sec)*1000000 +
                   (tv2.tv_usec-tv1.tv_usec))/1000)
              << " ms" << endl;
}

QString Global::highlightText(const QString& text)
{
    // make the quotation colors.
    QStringList temp = QStringList::split("\n",text);
    QString result;
    QStringList::iterator it = temp.begin();
    while(it != temp.end())
    {
        result.append(highlightParagraph((*it)+'\n'));
        ++it;
    }
    return result;
}

QString Global::highlightParagraph( const QString& text)
{
    //kdDebug() << "received: " << text << endl;

    bool found = false;
    QColor color;
    if (text.startsWith("&gt;&gt;&gt;&gt;")
        || text.startsWith("&gt; &gt; &gt; &gt;")
        || text.startsWith("||||") )
    {
        found = true;
        color = Qt::darkGreen;
    }
    else if (text.startsWith("&gt;&gt;&gt;") || text.startsWith("&gt; &gt; &gt;")
             || text.startsWith("|||") )
    {
        found = true;
        color = Qt::darkRed;
    }
    else if (text.startsWith("&gt;&gt;") || text.startsWith("&gt; &gt;")
             || text.startsWith("||") )
    {
        found = true;
        color = Qt::blue;
    }
    else if (text.startsWith("&gt;") || text.startsWith("|") )
    {
        found = true;
        color = Qt::red;
    }

    if (found)
        return "<font color=\""+color.name()+"\">"+text+"</font>";
    else
        return text;
}




}
