# Reference
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

**Functions**

* [`translate`](#translate): A function that calls the _() function in gettext. This is because _ is protected in the puppet language

## Functions

### translate

Type: Ruby 4.x API

A function that calls the _() function in gettext. This is because _ is protected in the puppet language

* **Note** Translate with simple strings:
  - Takes in a string and passes it to fast_gettext's _() function. Primarily used for 'marking' a string to be added to a .pot file.
Translate with interpolation:
  - Takes in a string and a hash. Please note that variables in the message are wrapped with %{VAR} not ${VAR}.
  - The hash contains key value pairs with marker and the variable it will be assigned to.
  - The translate module passes it to fast_gettext's _() function. Primarily used for 'marking' a string to be added to a .pot file.

#### Examples

##### 

```puppet
fail(translate("Failure message"))
```

##### 

```puppet
fail(translate('message is %{color}'), {'color' => 'green'})
```

#### `translate(String $message, Optional[Hash] $interpolation_values)`

The translate function.

Returns: `String` translated message.

##### Examples

###### 

```puppet
fail(translate("Failure message"))
```

###### 

```puppet
fail(translate('message is %{color}'), {'color' => 'green'})
```

##### `message`

Data type: `String`

Message to translate

##### `interpolation_values`

Data type: `Optional[Hash]`

Optional.

