# type: ignore
from ase import Atoms
from ase.calculators.turbomole import Turbomole
import os.path
import pytest


@pytest.fixture(scope="function")
def atoms():
    return Atoms('H2', positions=[(0, 0, 0), (0, 0, 1.1)])


def test_turbomole_H2(atoms):
    # Write all commands for the define command in a string
    define_str = '\n\na coord\n*\nno\nb all sto-3g hondo\n*\neht\n\n\n\n*'

    atoms.calc = Turbomole(define_str=define_str)

    # Run turbomole
    atoms.get_potential_energy()


def test_turbomole_H2_uhf_singlet(atoms):
    atoms.calc = Turbomole(**{
        "multiplicity": 1, "uhf": True, "use dft": True
    })

    # Run turbomole
    atoms.get_potential_energy()

    # check that it performed a DFT calculation (i.e. basic inputs were most
    # likely understood, cf. issue #735)
    dft_in_output = False
    with open("ASE.TM.dscf.out") as f:
        for line in f:
            if "density functional" in line:
                dft_in_output = True
    assert dft_in_output

    # also check that UHF was understood (alpha and beta files present)
    assert os.path.exists("alpha")
    assert os.path.exists("beta")
    assert not os.path.exists("mos")
