# frozen_string_literal: true

class TmpIndexForOwaspOnVulnerabilityReads < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!
  milestone '17.4'

  INDEX_NAME = 'tmp_index_for_owasp_null_on_vulnerability_reads'
  COLUMNS = %i[vulnerability_id].freeze
  WHERE_CLAUSE = 'owasp_top_10 IS NULL'

  def up
    # rubocop:disable Migration/PreventIndexCreation -- Legacy migration
    add_concurrent_index :vulnerability_reads, COLUMNS, name: INDEX_NAME, where: WHERE_CLAUSE
    # rubocop:enable Migration/PreventIndexCreation
  end

  def down
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_NAME
  end
end
