---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Exposure of confidential secret or token Clojars API token

## Description

The response body contains content that matches the pattern of a Clojars API token.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

Review the response body content and remove any exposed values.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 798.20 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
